/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.Arc;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.impl.ReactiveType;
import io.smallrye.mutiny.Multi;
import io.smallrye.mutiny.Uni;
import jakarta.annotation.Priority;
import jakarta.enterprise.context.control.ActivateRequestContext;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

@Interceptor
@ActivateRequestContext
@Priority(value=100)
public class ActivateRequestContextInterceptor {
    @AroundInvoke
    Object aroundInvoke(InvocationContext ctx) throws Exception {
        switch (ReactiveType.valueOf(ctx.getMethod())) {
            case UNI: {
                return this.invokeUni(ctx);
            }
            case MULTI: {
                return this.invokeMulti(ctx);
            }
            case STAGE: {
                return this.invokeStage(ctx);
            }
        }
        return this.invoke(ctx);
    }

    private CompletionStage<?> invokeStage(InvocationContext ctx) {
        ManagedContext requestContext = Arc.requireContainer().requestContext();
        if (requestContext.isActive()) {
            return this.proceedWithStage(ctx);
        }
        return ActivateRequestContextInterceptor.activate(requestContext).thenCompose(state -> this.proceedWithStage(ctx).whenComplete((r, t) -> {
            requestContext.destroy((InjectableContext.ContextState)state);
            requestContext.deactivate();
        }));
    }

    private static CompletionStage<InjectableContext.ContextState> activate(ManagedContext requestContext) {
        try {
            requestContext.activate();
            return CompletableFuture.completedStage(requestContext.getState());
        }
        catch (Throwable t) {
            return CompletableFuture.failedStage(t);
        }
    }

    private CompletionStage<?> proceedWithStage(InvocationContext ctx) {
        try {
            return (CompletionStage)ctx.proceed();
        }
        catch (Throwable t) {
            return CompletableFuture.failedStage(t);
        }
    }

    private Multi<?> invokeMulti(InvocationContext ctx) {
        return Multi.createFrom().deferred(() -> {
            ManagedContext requestContext = Arc.requireContainer().requestContext();
            if (requestContext.isActive()) {
                return this.proceedWithMulti(ctx);
            }
            return Multi.createFrom().deferred(() -> {
                requestContext.activate();
                InjectableContext.ContextState state = requestContext.getState();
                return this.proceedWithMulti(ctx).onTermination().invoke(() -> {
                    requestContext.destroy(state);
                    requestContext.deactivate();
                });
            });
        });
    }

    private Multi<?> proceedWithMulti(InvocationContext ctx) {
        try {
            return (Multi)ctx.proceed();
        }
        catch (Throwable t) {
            return Multi.createFrom().failure(t);
        }
    }

    private Uni<?> invokeUni(InvocationContext ctx) {
        return Uni.createFrom().deferred(() -> {
            ManagedContext requestContext = Arc.requireContainer().requestContext();
            if (requestContext.isActive()) {
                return this.proceedWithUni(ctx);
            }
            return Uni.createFrom().deferred(() -> {
                requestContext.activate();
                InjectableContext.ContextState state = requestContext.getState();
                return this.proceedWithUni(ctx).eventually(() -> {
                    requestContext.destroy(state);
                    requestContext.deactivate();
                });
            });
        });
    }

    private Uni<?> proceedWithUni(InvocationContext ctx) {
        try {
            return (Uni)ctx.proceed();
        }
        catch (Throwable t) {
            return Uni.createFrom().failure(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object invoke(InvocationContext ctx) throws Exception {
        ManagedContext requestContext = Arc.requireContainer().requestContext();
        if (requestContext.isActive()) {
            return ctx.proceed();
        }
        try {
            requestContext.activate();
            Object object = ctx.proceed();
            return object;
        }
        finally {
            requestContext.terminate();
        }
    }
}

