/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.CurrentContext;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.impl.ContextInstanceHandleImpl;
import io.quarkus.arc.impl.ContextInstances;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.Scopes;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public abstract class CurrentManagedContext
implements ManagedContext {
    private static final Logger LOG = Logger.getLogger(CurrentManagedContext.class);
    private final CurrentContext<CurrentContextState> currentContext;
    private final Supplier<ContextInstances> contextInstances;
    private final Consumer<Object> initializedNotifier;
    private final Consumer<Object> beforeDestroyedNotifier;
    private final Consumer<Object> destroyedNotifier;

    protected CurrentManagedContext(CurrentContext<CurrentContextState> currentContext, Supplier<ContextInstances> contextInstances, Consumer<Object> initializedNotifier, Consumer<Object> beforeDestroyedNotifier, Consumer<Object> destroyedNotifier) {
        this.currentContext = currentContext;
        this.contextInstances = contextInstances;
        this.initializedNotifier = initializedNotifier;
        this.beforeDestroyedNotifier = beforeDestroyedNotifier;
        this.destroyedNotifier = destroyedNotifier;
    }

    @Override
    public InjectableContext.ContextState getState() {
        CurrentContextState state = this.currentState();
        if (state == null) {
            throw this.notActive();
        }
        return state;
    }

    @Override
    public InjectableContext.ContextState activate(InjectableContext.ContextState initialState) {
        if (this.traceLog().isTraceEnabled()) {
            this.traceActivate(initialState);
        }
        if (initialState == null) {
            CurrentContextState state = this.initializeState();
            this.currentContext.set(state);
            if (state.shouldFireInitializedEvent()) {
                this.fireIfNotNull(this.initializedNotifier);
            }
            return state;
        }
        if (initialState instanceof CurrentContextState) {
            CurrentContextState current = (CurrentContextState)initialState;
            this.currentContext.set(current);
            if (current.isValid() && current.shouldFireInitializedEvent()) {
                this.fireIfNotNull(this.initializedNotifier);
            }
            return initialState;
        }
        throw new IllegalArgumentException("Invalid initial state: " + initialState.getClass().getName());
    }

    @Override
    public void deactivate() {
        if (this.traceLog().isTraceEnabled()) {
            this.traceDeactivate();
        }
        this.currentContext.remove();
    }

    @Override
    public <T> T getIfActive(final Contextual<T> contextual, Function<Contextual<T>, CreationalContext<T>> creationalContextFun) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        Objects.requireNonNull(creationalContextFun, "CreationalContext function must not be null");
        final InjectableBean bean = (InjectableBean)contextual;
        if (!Scopes.scopeMatches(this, bean)) {
            throw Scopes.scopeDoesNotMatchException(this, bean);
        }
        CurrentContextState state = this.currentState();
        if (state == null || !state.isValid()) {
            return null;
        }
        ContextInstances contextInstances = state.contextInstances;
        ContextInstanceHandle<?> instance = contextInstances.getIfPresent(bean.getIdentifier());
        if (instance == null) {
            final CreationalContext<T> creationalContext = creationalContextFun.apply(contextual);
            return contextInstances.computeIfAbsent(bean.getIdentifier(), new Supplier<ContextInstanceHandle<?>>(){

                @Override
                public ContextInstanceHandle<?> get() {
                    return new ContextInstanceHandleImpl(bean, contextual.create(creationalContext), creationalContext);
                }
            }).get();
        }
        return instance.get();
    }

    @Override
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        T result = this.getIfActive(contextual, CreationalContextImpl.unwrap(Objects.requireNonNull(creationalContext, "CreationalContext must not be null")));
        if (result == null) {
            throw this.notActive();
        }
        return result;
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        InjectableBean bean = (InjectableBean)contextual;
        if (!Scopes.scopeMatches(this, bean)) {
            throw Scopes.scopeDoesNotMatchException(this, bean);
        }
        CurrentContextState state = this.currentState();
        if (state == null || !state.isValid()) {
            throw this.notActive();
        }
        ContextInstanceHandle<?> instance = state.contextInstances.getIfPresent(bean.getIdentifier());
        return instance == null ? null : (T)instance.get();
    }

    @Override
    public boolean isActive() {
        CurrentContextState contextState = this.currentState();
        return contextState == null ? false : contextState.isValid();
    }

    @Override
    public void destroy() {
        this.destroy(this.currentState());
    }

    @Override
    public void destroy(Contextual<?> contextual) {
        CurrentContextState state = this.currentState();
        if (state == null || !state.isValid()) {
            throw this.notActive();
        }
        InjectableBean bean = (InjectableBean)contextual;
        ContextInstanceHandle<?> instance = state.contextInstances.remove(bean.getIdentifier());
        if (instance != null) {
            instance.destroy();
        }
    }

    @Override
    public void destroy(InjectableContext.ContextState state) {
        if (this.traceLog().isTraceEnabled()) {
            this.traceDestroy(state);
        }
        if (state == null) {
            return;
        }
        if (state instanceof CurrentContextState) {
            CurrentContextState currentState = (CurrentContextState)state;
            if (currentState.isValid() && currentState.shouldFireBeforeDestroyedEvent()) {
                this.fireIfNotNull(this.beforeDestroyedNotifier);
            }
            if (currentState.invalidate()) {
                currentState.contextInstances.removeEach(new Consumer<ContextInstanceHandle<?>>(){

                    @Override
                    public void accept(ContextInstanceHandle<?> contextInstanceHandle) {
                        contextInstanceHandle.destroy();
                    }
                });
                this.fireIfNotNull(this.destroyedNotifier);
            }
        } else {
            throw new IllegalArgumentException("Invalid state implementation: " + state.getClass().getName());
        }
    }

    @Override
    public CurrentContextState initializeState() {
        CurrentContextState state = new CurrentContextState(this.contextInstances.get());
        return state;
    }

    protected Logger traceLog() {
        return LOG;
    }

    protected void traceActivate(InjectableContext.ContextState initialState) {
    }

    protected void traceDeactivate() {
    }

    protected void traceDestroy(InjectableContext.ContextState state) {
    }

    private CurrentContextState currentState() {
        return this.currentContext.get();
    }

    protected abstract ContextNotActiveException notActive();

    private void fireIfNotNull(Consumer<Object> notifier) {
        if (notifier != null) {
            try {
                notifier.accept(this.toString());
            }
            catch (Exception e) {
                LOG.warn((Object)("An error occurred during delivery of the context lifecycle event for " + this.toString()), e);
            }
        }
    }

    public static class CurrentContextState
    implements InjectableContext.ContextState {
        private static final VarHandle STATE_UPDATER;
        private static final byte INVALID_MASK = 1;
        private static final byte INITIALIZED_FIRED_MASK = 2;
        private static final byte BEFORE_DESTROYED_FIRED_MASK = 4;
        private final ContextInstances contextInstances;
        private volatile byte state;

        CurrentContextState(ContextInstances contextInstances) {
            this.contextInstances = Objects.requireNonNull(contextInstances);
        }

        @Override
        public Map<InjectableBean<?>, Object> getContextualInstances() {
            return this.contextInstances.getAllPresent().stream().collect(Collectors.toUnmodifiableMap(InstanceHandle::getBean, InstanceHandle::get));
        }

        boolean invalidate() {
            return this.set((byte)1);
        }

        @Override
        public boolean isValid() {
            return this.isNotSet((byte)1);
        }

        boolean shouldFireInitializedEvent() {
            return this.set((byte)2);
        }

        boolean shouldFireBeforeDestroyedEvent() {
            return this.set((byte)4);
        }

        private boolean isNotSet(byte bitMask) {
            return (this.state & bitMask) == 0;
        }

        private boolean set(byte bitMask) {
            byte newState;
            byte state = this.state;
            do {
                if ((state & bitMask) == 0) continue;
                return false;
            } while ((state = STATE_UPDATER.compareAndExchange(this, state, newState = (byte)(state | bitMask))) != newState);
            return true;
        }

        static {
            try {
                STATE_UPDATER = MethodHandles.lookup().findVarHandle(CurrentContextState.class, "state", Byte.TYPE);
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        }
    }
}

