/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common.impl;

import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.streams.ReadStream;
import io.vertx.core.streams.impl.InboundBuffer;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcReadStream;
import io.vertx.grpc.common.InvalidMessageException;
import io.vertx.grpc.common.InvalidMessagePayloadException;
import io.vertx.grpc.common.MessageSizeOverflowException;

public abstract class GrpcReadStreamBase<S extends GrpcReadStreamBase<S, T>, T>
implements GrpcReadStream<T>,
Handler<Buffer> {
    static final GrpcMessage END_SENTINEL = new GrpcMessage(){

        @Override
        public String encoding() {
            return null;
        }

        @Override
        public Buffer payload() {
            return null;
        }
    };
    protected final ContextInternal context;
    private final String encoding;
    private final long maxMessageSize;
    private final ReadStream<Buffer> stream;
    private final InboundBuffer<GrpcMessage> queue;
    private Buffer buffer;
    private long bytesToSkip;
    private Handler<GrpcError> errorHandler;
    private Handler<Throwable> exceptionHandler;
    private Handler<GrpcMessage> messageHandler;
    private Handler<Void> endHandler;
    private Handler<InvalidMessageException> invalidMessageHandler;
    private GrpcMessage last;
    private final GrpcMessageDecoder<T> messageDecoder;
    private final Promise<Void> end;

    protected GrpcReadStreamBase(Context context, ReadStream<Buffer> stream, String encoding, long maxMessageSize, GrpcMessageDecoder<T> messageDecoder) {
        this.context = (ContextInternal)context;
        this.encoding = encoding;
        this.maxMessageSize = maxMessageSize;
        this.stream = stream;
        this.queue = new InboundBuffer(context);
        this.messageDecoder = messageDecoder;
        this.end = ((ContextInternal)context).promise();
    }

    public void init() {
        this.stream.handler(this);
        this.stream.endHandler((Void v) -> this.queue.write(END_SENTINEL));
        this.stream.exceptionHandler(err -> {
            if (err instanceof StreamResetException) {
                this.handleReset(((StreamResetException)err).getCode());
            } else {
                this.handleException((Throwable)err);
            }
        });
        this.queue.drainHandler(v -> this.stream.resume());
        this.queue.handler((E msg) -> {
            if (msg == END_SENTINEL) {
                this.handleEnd();
            } else {
                this.handleMessage((GrpcMessage)msg);
            }
        });
    }

    private T decodeMessage(GrpcMessage msg) throws CodecException {
        switch (msg.encoding()) {
            case "identity": {
                break;
            }
            case "gzip": {
                msg = GrpcMessage.message("identity", GrpcMessageDecoder.GZIP.decode(msg));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        return this.messageDecoder.decode(msg);
    }

    @Override
    public final void handle(Buffer chunk) {
        if (this.bytesToSkip > 0L) {
            int len = chunk.length();
            if ((long)len <= this.bytesToSkip) {
                this.bytesToSkip -= (long)len;
                return;
            }
            chunk = chunk.slice((int)this.bytesToSkip, len);
            this.bytesToSkip = 0L;
        }
        if (this.buffer == null) {
            this.buffer = chunk;
        } else {
            this.buffer.appendBuffer(chunk);
        }
        int idx = 0;
        boolean pause = false;
        while (idx + 5 <= this.buffer.length()) {
            boolean compressed;
            long len = (long)this.buffer.getInt(idx + 1) & 0xFFFFFFFFL;
            if (len > this.maxMessageSize) {
                Handler<InvalidMessageException> handler = this.invalidMessageHandler;
                if (handler != null) {
                    MessageSizeOverflowException msoe = new MessageSizeOverflowException(len);
                    this.context.dispatch(msoe, handler);
                }
                if ((long)this.buffer.length() < len + 5L) {
                    this.bytesToSkip = len + 5L - (long)this.buffer.length();
                    this.buffer = null;
                    return;
                }
                this.buffer = this.buffer.slice((int)(len + 5L), this.buffer.length());
                continue;
            }
            if (len > (long)(this.buffer.length() - (idx + 5))) break;
            boolean bl = compressed = this.buffer.getByte(idx) == 1;
            if (compressed && this.encoding == null) {
                throw new UnsupportedOperationException("Handle me");
            }
            Buffer payload = this.buffer.slice(idx + 5, (int)((long)(idx + 5) + len));
            GrpcMessage message = GrpcMessage.message(compressed ? this.encoding : "identity", payload);
            pause |= !this.queue.write(message);
            idx = (int)((long)idx + (5L + len));
        }
        if (pause) {
            this.stream.pause();
        }
        this.buffer = idx < this.buffer.length() ? this.buffer.getBuffer(idx, this.buffer.length()) : null;
    }

    public final S pause() {
        this.queue.pause();
        return (S)this;
    }

    public final S resume() {
        this.queue.resume();
        return (S)this;
    }

    public final S fetch(long amount) {
        this.queue.fetch(amount);
        return (S)this;
    }

    public final S errorHandler(Handler<GrpcError> handler) {
        this.errorHandler = handler;
        return (S)this;
    }

    public final S exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return (S)this;
    }

    public final S messageHandler(Handler<GrpcMessage> handler) {
        this.messageHandler = handler;
        return (S)this;
    }

    public final S invalidMessageHandler(@Nullable Handler<InvalidMessageException> handler) {
        this.invalidMessageHandler = handler;
        return (S)this;
    }

    public final S handler(@Nullable Handler<T> handler) {
        if (handler != null) {
            return (S)this.messageHandler(msg -> {
                T decoded;
                try {
                    decoded = this.decodeMessage((GrpcMessage)msg);
                }
                catch (CodecException e) {
                    Handler<InvalidMessageException> errorHandler = this.invalidMessageHandler;
                    if (errorHandler != null) {
                        InvalidMessagePayloadException impe = new InvalidMessagePayloadException((GrpcMessage)msg, (Throwable)e);
                        errorHandler.handle(impe);
                    }
                    return;
                }
                handler.handle(decoded);
            });
        }
        return (S)this.messageHandler((Handler)null);
    }

    public S endHandler(Handler<Void> endHandler) {
        this.endHandler = endHandler;
        return (S)this;
    }

    protected void handleReset(long code) {
        GrpcError error;
        Handler<GrpcError> handler = this.errorHandler;
        if (handler != null && (error = GrpcError.mapHttp2ErrorCode(code)) != null) {
            handler.handle(error);
        }
    }

    public void tryFail(Throwable err) {
        Handler<Throwable> handler;
        if (this.end.tryFail(err) && (handler = this.exceptionHandler) != null) {
            this.context.dispatch(err, handler);
        }
    }

    protected void handleException(Throwable err) {
        this.tryFail(err);
    }

    protected void handleEnd() {
        this.end.tryComplete();
        Handler<Void> handler = this.endHandler;
        if (handler != null) {
            handler.handle(null);
        }
    }

    private void handleMessage(GrpcMessage msg) {
        this.last = msg;
        Handler<GrpcMessage> handler = this.messageHandler;
        if (handler != null) {
            handler.handle(msg);
        }
    }

    @Override
    public Future<T> last() {
        return this.end().map(v -> this.decodeMessage(this.last));
    }

    @Override
    public Future<Void> end() {
        return this.end.future();
    }
}

