/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.ArcInvocationContext;
import io.quarkus.arc.impl.AbstractInvocationContext;
import io.quarkus.arc.impl.ContextDataMap;
import io.quarkus.arc.impl.InterceptedMethodMetadata;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Set;

class AroundInvokeInvocationContext
extends AbstractInvocationContext {
    private final InterceptedMethodMetadata metadata;

    static Object perform(Object target, Object[] args, InterceptedMethodMetadata metadata) throws Exception {
        if (metadata.chain.isEmpty()) {
            return metadata.aroundInvokeForward.apply(target, new AroundInvokeInvocationContext(target, args, metadata));
        }
        return metadata.chain.get(0).invoke(new AroundInvokeInvocationContext(target, args, metadata));
    }

    AroundInvokeInvocationContext(Object target, Object[] args, InterceptedMethodMetadata metadata) {
        super(target, args, new ContextDataMap(metadata.bindings));
        this.metadata = metadata;
    }

    @Override
    public Set<Annotation> getInterceptorBindings() {
        return this.metadata.bindings;
    }

    @Override
    public Method getMethod() {
        return this.metadata.method;
    }

    @Override
    public Object[] getParameters() {
        return this.parameters;
    }

    @Override
    public void setParameters(Object[] params) {
        AroundInvokeInvocationContext.validateParameters(this.metadata.method, params);
        this.parameters = params;
    }

    @Override
    public Object proceed() throws Exception {
        return this.proceed(1);
    }

    private Object proceed(int currentPosition) throws Exception {
        try {
            if (currentPosition < this.metadata.chain.size()) {
                return this.metadata.chain.get(currentPosition).invoke(new NextAroundInvokeInvocationContext(currentPosition + 1));
            }
            return this.metadata.aroundInvokeForward.apply(this.target, this);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof Exception) {
                throw (Exception)cause;
            }
            throw new RuntimeException(cause);
        }
    }

    class NextAroundInvokeInvocationContext
    implements ArcInvocationContext {
        private final int position;

        public NextAroundInvokeInvocationContext(int position) {
            this.position = position;
        }

        @Override
        public Object proceed() throws Exception {
            return AroundInvokeInvocationContext.this.proceed(this.position);
        }

        @Override
        public Object getTarget() {
            return AroundInvokeInvocationContext.this.getTarget();
        }

        @Override
        public Object getTimer() {
            return AroundInvokeInvocationContext.this.getTimer();
        }

        @Override
        public Method getMethod() {
            return AroundInvokeInvocationContext.this.getMethod();
        }

        @Override
        public Constructor<?> getConstructor() {
            return AroundInvokeInvocationContext.this.getConstructor();
        }

        @Override
        public Object[] getParameters() {
            return AroundInvokeInvocationContext.this.getParameters();
        }

        @Override
        public void setParameters(Object[] params) {
            AroundInvokeInvocationContext.this.setParameters(params);
        }

        @Override
        public Map<String, Object> getContextData() {
            return AroundInvokeInvocationContext.this.getContextData();
        }

        @Override
        public Set<Annotation> getInterceptorBindings() {
            return AroundInvokeInvocationContext.this.getInterceptorBindings();
        }

        @Override
        public <T extends Annotation> T findIterceptorBinding(Class<T> annotationType) {
            return AroundInvokeInvocationContext.this.findIterceptorBinding(annotationType);
        }

        @Override
        public <T extends Annotation> List<T> findIterceptorBindings(Class<T> annotationType) {
            return AroundInvokeInvocationContext.this.findIterceptorBindings(annotationType);
        }
    }
}

