/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableReferenceProvider;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.impl.EagerInstanceHandle;
import io.quarkus.arc.impl.SyntheticCreationalContextImpl;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.InjectionPoint;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;

public class CreationalContextImpl<T>
implements CreationalContext<T>,
Function<Contextual<T>, CreationalContext<T>> {
    private final Contextual<T> contextual;
    private final CreationalContextImpl<?> parent;
    private List<InstanceHandle<?>> dependentInstances;
    private InjectionPoint currentInjectionPoint;
    private Object currentDecoratorDelegate;

    public CreationalContextImpl(Contextual<T> contextual) {
        this(contextual, null);
    }

    public CreationalContextImpl(Contextual<T> contextual, CreationalContextImpl<?> parent) {
        this.contextual = contextual;
        this.parent = parent;
        this.dependentInstances = null;
    }

    public <I> void addDependentInstance(InjectableBean<I> bean, I instance, CreationalContext<I> ctx) {
        this.addDependentInstance(new EagerInstanceHandle<I>(bean, instance, ctx));
    }

    public synchronized <I> void addDependentInstance(InstanceHandle<I> instanceHandle) {
        if (this.dependentInstances == null) {
            this.dependentInstances = new ArrayList();
        }
        this.dependentInstances.add(instanceHandle);
    }

    public synchronized boolean hasDependentInstances() {
        return this.dependentInstances != null && !this.dependentInstances.isEmpty();
    }

    public synchronized boolean removeDependentInstance(Object dependentInstance, boolean destroy) {
        if (this.dependentInstances != null) {
            Iterator<InstanceHandle<?>> it = this.dependentInstances.iterator();
            while (it.hasNext()) {
                InstanceHandle<?> handle = it.next();
                if (handle.get() != dependentInstance) continue;
                if (destroy) {
                    handle.destroy();
                }
                it.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public void push(T incompleteInstance) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        CreationalContextImpl creationalContextImpl = this;
        synchronized (creationalContextImpl) {
            if (this.dependentInstances != null) {
                for (InstanceHandle<?> instance : this.dependentInstances) {
                    instance.destroy();
                }
            }
        }
    }

    public CreationalContextImpl<?> getParent() {
        return this.parent;
    }

    public Contextual<T> getContextual() {
        return this.contextual;
    }

    public <C> CreationalContextImpl<C> child(Contextual<C> contextual) {
        return new CreationalContextImpl<C>(contextual, this);
    }

    @Override
    public CreationalContext<T> apply(Contextual<T> contextual) {
        return this;
    }

    public static <T> CreationalContextImpl<T> unwrap(CreationalContext<T> ctx) {
        if (ctx instanceof CreationalContextImpl) {
            return (CreationalContextImpl)ctx;
        }
        if (ctx instanceof SyntheticCreationalContextImpl) {
            return CreationalContextImpl.unwrap(((SyntheticCreationalContextImpl)ctx).creationalContext);
        }
        throw new IllegalArgumentException("Failed to unwrap CreationalContextImpl: " + String.valueOf(ctx));
    }

    public static <C> CreationalContextImpl<C> child(CreationalContext<?> creationalContext) {
        return CreationalContextImpl.child(null, creationalContext);
    }

    public static <C> CreationalContextImpl<C> child(InjectableReferenceProvider<?> provider, CreationalContext<?> creationalContext) {
        return CreationalContextImpl.unwrap(creationalContext).child(provider instanceof InjectableBean ? (InjectableBean)provider : null);
    }

    public static <I> void addDependencyToParent(InjectableBean<I> bean, I instance, CreationalContext<I> ctx) {
        CreationalContextImpl<?> parent = CreationalContextImpl.unwrap(ctx).getParent();
        if (parent != null) {
            parent.addDependentInstance(bean, instance, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> InjectionPoint getCurrentInjectionPoint(CreationalContext<T> ctx) {
        CreationalContextImpl<Object> instance = CreationalContextImpl.unwrap(ctx);
        while (instance != null) {
            CreationalContextImpl<T> creationalContextImpl = instance;
            synchronized (creationalContextImpl) {
                InjectionPoint result = instance.currentInjectionPoint;
                if (result != null) {
                    return result;
                }
            }
            instance = instance.parent;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> InjectionPoint setCurrentInjectionPoint(CreationalContext<T> ctx, InjectionPoint injectionPoint) {
        CreationalContextImpl<T> instance;
        CreationalContextImpl<T> creationalContextImpl = instance = CreationalContextImpl.unwrap(ctx);
        synchronized (creationalContextImpl) {
            InjectionPoint previous = instance.currentInjectionPoint;
            instance.currentInjectionPoint = injectionPoint;
            return previous;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Object getCurrentDecoratorDelegate(CreationalContext<T> ctx) {
        CreationalContextImpl<Object> instance = CreationalContextImpl.unwrap(ctx);
        while (instance != null) {
            CreationalContextImpl<T> creationalContextImpl = instance;
            synchronized (creationalContextImpl) {
                Object result = instance.currentDecoratorDelegate;
                if (result != null) {
                    return result;
                }
            }
            instance = instance.parent;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static <T> Object setCurrentDecoratorDelegate(CreationalContext<T> ctx, Object decoratorDelegate) {
        CreationalContextImpl<T> instance;
        CreationalContextImpl<T> creationalContextImpl = instance = CreationalContextImpl.unwrap(ctx);
        synchronized (creationalContextImpl) {
            Object previous = instance.currentDecoratorDelegate;
            instance.currentDecoratorDelegate = decoratorDelegate;
            return previous;
        }
    }
}

