/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common.impl;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.vertx.core.buffer.Buffer;
import io.vertx.grpc.common.GrpcMessage;

public class GrpcMessageImpl
implements GrpcMessage {
    private final String encoding;
    private final Buffer payload;

    public GrpcMessageImpl(String encoding, Buffer payload) {
        this.encoding = encoding;
        this.payload = payload;
    }

    @Override
    public String encoding() {
        return this.encoding;
    }

    @Override
    public Buffer payload() {
        return this.payload;
    }

    public static Buffer encode(GrpcMessage message) {
        return GrpcMessageImpl.encode(message.payload(), !message.encoding().equals("identity"));
    }

    public static Buffer encode(Buffer message, boolean compressed) {
        ByteBuf bbuf = message.getByteBuf();
        int len = bbuf.readableBytes();
        ByteBuf prefix = Unpooled.buffer(5, 5);
        prefix.writeByte(compressed ? 1 : 0);
        prefix.writeInt(len);
        CompositeByteBuf composite = Unpooled.compositeBuffer();
        composite.addComponent(true, prefix);
        composite.addComponent(true, bbuf);
        return Buffer.buffer(composite);
    }
}

