/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client.impl;

import io.netty.handler.codec.http.QueryStringDecoder;
import io.vertx.core.Future;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.grpc.client.GrpcClientResponse;
import io.vertx.grpc.client.impl.GrpcClientRequestImpl;
import io.vertx.grpc.common.GrpcMessageDecoder;
import io.vertx.grpc.common.GrpcStatus;
import io.vertx.grpc.common.impl.GrpcReadStreamBase;
import java.nio.charset.StandardCharsets;

public class GrpcClientResponseImpl<Req, Resp>
extends GrpcReadStreamBase<GrpcClientResponseImpl<Req, Resp>, Resp>
implements GrpcClientResponse<Req, Resp> {
    private final GrpcClientRequestImpl<Req, Resp> request;
    private final HttpClientResponse httpResponse;
    private GrpcStatus status;
    private String statusMessage;
    private String encoding;

    public GrpcClientResponseImpl(GrpcClientRequestImpl<Req, Resp> request, HttpClientResponse httpResponse, long maxMessageSize, GrpcMessageDecoder<Resp> messageDecoder) {
        super(Vertx.currentContext(), httpResponse, httpResponse.headers().get("grpc-encoding"), maxMessageSize, messageDecoder);
        this.request = request;
        this.encoding = httpResponse.headers().get("grpc-encoding");
        this.httpResponse = httpResponse;
        String responseStatus = httpResponse.getHeader("grpc-status");
        if (responseStatus != null) {
            String msg;
            this.status = GrpcStatus.valueOf(Integer.parseInt(responseStatus));
            if (this.status != GrpcStatus.OK && (msg = httpResponse.getHeader("grpc-message")) != null) {
                this.statusMessage = QueryStringDecoder.decodeComponent(msg, StandardCharsets.UTF_8);
            }
        }
    }

    @Override
    public MultiMap headers() {
        return this.httpResponse.headers();
    }

    @Override
    public String encoding() {
        return this.encoding;
    }

    @Override
    public MultiMap trailers() {
        return this.httpResponse.trailers();
    }

    @Override
    protected void handleEnd() {
        String responseStatus = this.httpResponse.getTrailer("grpc-status");
        if (responseStatus != null) {
            this.status = GrpcStatus.valueOf(Integer.parseInt(responseStatus));
            if (this.status != GrpcStatus.OK) {
                this.statusMessage = this.httpResponse.getTrailer("grpc-message");
            }
        }
        super.handleEnd();
        if (!this.request.trailersSent) {
            this.request.cancel();
        }
    }

    @Override
    public GrpcStatus status() {
        return this.status;
    }

    @Override
    public String statusMessage() {
        return this.statusMessage;
    }

    @Override
    public Future<Void> end() {
        return super.end().compose(v -> {
            if (this.status == GrpcStatus.OK) {
                return Future.succeededFuture();
            }
            return Future.failedFuture("Invalid gRPC status " + (Object)((Object)this.status));
        });
    }
}

