/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common.impl;

import io.grpc.Compressor;
import io.grpc.Drainable;
import io.grpc.MethodDescriptor;
import io.vertx.core.buffer.Buffer;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageEncoder;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class BridgeMessageEncoder<T>
implements GrpcMessageEncoder<T> {
    private MethodDescriptor.Marshaller<T> marshaller;
    private Compressor compressor;

    public BridgeMessageEncoder(MethodDescriptor.Marshaller<T> marshaller, Compressor compressor) {
        this.marshaller = marshaller;
        this.compressor = compressor;
    }

    @Override
    public GrpcMessage encode(final T msg) {
        return new GrpcMessage(){
            private Buffer encoded;

            @Override
            public String encoding() {
                return BridgeMessageEncoder.this.compressor == null ? "identity" : BridgeMessageEncoder.this.compressor.getMessageEncoding();
            }

            @Override
            public Buffer payload() {
                if (this.encoded == null) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Drainable stream = (Drainable)((Object)BridgeMessageEncoder.this.marshaller.stream(msg));
                    try {
                        OutputStream compressingStream = BridgeMessageEncoder.this.compressor == null ? baos : BridgeMessageEncoder.this.compressor.compress(baos);
                        stream.drainTo(compressingStream);
                        compressingStream.close();
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                    byte[] bytes = baos.toByteArray();
                    this.encoded = Buffer.buffer(bytes);
                }
                return this.encoded;
            }
        };
    }
}

