/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.InterceptionProxy;
import io.quarkus.arc.SyntheticCreationalContext;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.Default;
import jakarta.enterprise.util.TypeLiteral;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;

public final class SyntheticCreationalContextImpl<T>
implements SyntheticCreationalContext<T> {
    final CreationalContext<T> creationalContext;
    private final Map<TypeAndQualifiers, Object> injectedReferences;
    private final Map<String, Object> params;

    public SyntheticCreationalContextImpl(CreationalContext<T> creationalContext, Map<String, Object> params, Map<TypeAndQualifiers, Object> injectedReferences) {
        this.creationalContext = Objects.requireNonNull(creationalContext);
        this.params = Objects.requireNonNull(params);
        this.injectedReferences = Objects.requireNonNull(injectedReferences);
    }

    public CreationalContext<T> getDelegateCreationalContext() {
        return this.creationalContext;
    }

    @Override
    public void push(T incompleteInstance) {
        this.creationalContext.push(incompleteInstance);
    }

    @Override
    public void release() {
        this.creationalContext.release();
    }

    @Override
    public Map<String, Object> getParams() {
        return this.params;
    }

    @Override
    public <R> R getInjectedReference(Class<R> requiredType, Annotation ... qualifiers) {
        return this.getReference(requiredType, qualifiers);
    }

    @Override
    public <R> R getInjectedReference(TypeLiteral<R> requiredType, Annotation ... qualifiers) {
        return this.getReference(requiredType.getType(), qualifiers);
    }

    @Override
    public <R> InterceptionProxy<R> getInterceptionProxy() {
        for (Map.Entry<TypeAndQualifiers, Object> entry : this.injectedReferences.entrySet()) {
            if (!entry.getKey().requiredType.getTypeName().startsWith(InterceptionProxy.class.getName())) continue;
            return (InterceptionProxy)entry.getValue();
        }
        throw new IllegalArgumentException("No InterceptionProxy registered for this synthetic bean; call injectInterceptionProxy()");
    }

    private <R> R getReference(Type requiredType, Annotation ... qualifiers) {
        Object ref;
        if (qualifiers.length == 0) {
            qualifiers = new Annotation[]{Default.Literal.INSTANCE};
        }
        if ((ref = this.injectedReferences.get(new TypeAndQualifiers(requiredType, qualifiers))) == null) {
            throw new IllegalArgumentException("A synthetic injection point was not declared for required type [" + String.valueOf(requiredType) + " and qualifiers: " + Arrays.toString(qualifiers));
        }
        return (R)ref;
    }

    public static final class TypeAndQualifiers {
        private final Type requiredType;
        private final Annotation[] qualifiers;

        public TypeAndQualifiers(Type requiredType, Annotation[] qualifiers) {
            Annotation[] annotationArray;
            this.requiredType = Objects.requireNonNull(requiredType);
            if (qualifiers == null) {
                Annotation[] annotationArray2 = new Annotation[1];
                annotationArray = annotationArray2;
                annotationArray2[0] = Default.Literal.INSTANCE;
            } else {
                annotationArray = qualifiers;
            }
            this.qualifiers = annotationArray;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + Arrays.hashCode(this.qualifiers);
            result = 31 * result + this.requiredType.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            TypeAndQualifiers other = (TypeAndQualifiers)obj;
            return Objects.equals(this.requiredType, other.requiredType) && Arrays.equals(this.qualifiers, other.qualifiers);
        }
    }
}

