/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.CompositeException;
import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.infrastructure.Infrastructure;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import io.smallrye.mutiny.subscription.UniSubscription;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Predicate;

public class UniRetryAtMost<T>
extends UniOperator<T, T> {
    private final Predicate<? super Throwable> predicate;
    private final long maxAttempts;

    public UniRetryAtMost(Uni<T> upstream, Predicate<? super Throwable> predicate, long maxAttempts) {
        super(ParameterValidation.nonNull(upstream, "upstream"));
        this.predicate = ParameterValidation.nonNull(predicate, "predicate");
        this.maxAttempts = ParameterValidation.positive(maxAttempts, "maxAttempts");
    }

    @Override
    public void subscribe(UniSubscriber<? super T> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniRetryAtMostProcessor<T>(this, subscriber));
    }

    private static class UniRetryAtMostProcessor<T>
    extends UniOperatorProcessor<T, T> {
        private final UniRetryAtMost<T> uniRetryAtMost;
        private volatile int counter = 0;
        private static final AtomicIntegerFieldUpdater<UniRetryAtMostProcessor> counterUpdater = AtomicIntegerFieldUpdater.newUpdater(UniRetryAtMostProcessor.class, "counter");

        public UniRetryAtMostProcessor(UniRetryAtMost<T> uniRetryAtMost, UniSubscriber<? super T> downstream) {
            super(downstream);
            this.uniRetryAtMost = uniRetryAtMost;
        }

        @Override
        public void onSubscribe(UniSubscription subscription) {
            int count = counterUpdater.incrementAndGet(this);
            if (this.compareAndSetUpstreamSubscription(null, subscription)) {
                if (count == 1) {
                    this.downstream.onSubscribe(this);
                }
            } else {
                subscription.cancel();
            }
        }

        @Override
        public void onFailure(Throwable failure) {
            if (this.isCancelled()) {
                Infrastructure.handleDroppedException(failure);
                return;
            }
            if (!this.testPredicate(failure)) {
                return;
            }
            if ((long)this.counter > this.uniRetryAtMost.maxAttempts) {
                this.downstream.onFailure(failure);
                return;
            }
            UniSubscription previousSubscription = this.getAndSetUpstreamSubscription(null);
            if (previousSubscription != null) {
                previousSubscription.cancel();
            }
            AbstractUni.subscribe(this.uniRetryAtMost.upstream(), this);
        }

        private boolean testPredicate(Throwable failure) {
            boolean passes;
            try {
                passes = this.uniRetryAtMost.predicate.test(failure);
            }
            catch (Throwable e) {
                this.downstream.onFailure(new CompositeException(e, failure));
                return false;
            }
            if (!passes) {
                this.downstream.onFailure(failure);
                return false;
            }
            return true;
        }
    }
}

