/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.impl.CreationalContextImpl;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.annotation.Annotation;
import java.util.Objects;

class DependentContext
implements InjectableContext {
    DependentContext() {
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return Dependent.class;
    }

    @Override
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        if (creationalContext == null) {
            return null;
        }
        T instance = contextual.create(creationalContext);
        if (creationalContext instanceof CreationalContextImpl) {
            CreationalContextImpl ccimpl = (CreationalContextImpl)creationalContext;
            ccimpl.addDependentInstance((InjectableBean)contextual, instance, creationalContext);
        }
        return instance;
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        return this.get(contextual, null);
    }

    @Override
    public boolean isActive() {
        return true;
    }

    @Override
    public void destroy(Contextual<?> contextual) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InjectableContext.ContextState getState() {
        throw new UnsupportedOperationException();
    }
}

