/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.client;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.json.annotations.JsonGen;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.json.JsonObject;
import io.vertx.grpc.client.GrpcClientOptionsConverter;

@DataObject
@JsonGen(publicConverter=false)
public class GrpcClientOptions {
    public static final long DEFAULT_MAX_MESSAGE_SIZE = 262144L;
    private long maxMessageSize = 262144L;
    private HttpClientOptions transportOptions = new HttpClientOptions().setHttp2ClearTextUpgrade(false);

    public GrpcClientOptions() {
    }

    public GrpcClientOptions(GrpcClientOptions options) {
        this.maxMessageSize = options.maxMessageSize;
        this.transportOptions = options.transportOptions != null ? new HttpClientOptions(options.transportOptions) : null;
    }

    public GrpcClientOptions(JsonObject json) {
        GrpcClientOptionsConverter.fromJson(json, this);
    }

    public long getMaxMessageSize() {
        return this.maxMessageSize;
    }

    public GrpcClientOptions setMaxMessageSize(long maxMessageSize) {
        if (maxMessageSize <= 0L) {
            throw new IllegalArgumentException("Max message size must be > 0");
        }
        if (maxMessageSize > 0xFFFFFFFFL) {
            throw new IllegalArgumentException("Max message size must be <= 0xFFFFFFFF");
        }
        this.maxMessageSize = maxMessageSize;
        return this;
    }

    public HttpClientOptions getTransportOptions() {
        return this.transportOptions;
    }

    public GrpcClientOptions setTransportOptions(HttpClientOptions transportOptions) {
        this.transportOptions = transportOptions;
        return this;
    }
}

