/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.ManagedContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.SessionScoped;
import jakarta.inject.Singleton;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

class Contexts {
    final ManagedContext requestContext;
    final ManagedContext sessionContext;
    final InjectableContext applicationContext;
    final InjectableContext singletonContext;
    final InjectableContext dependentContext;
    private final List<InjectableContext> applicationContextSingleton;
    private final List<InjectableContext> singletonContextSingleton;
    private final List<InjectableContext> dependentContextSingleton;
    private final List<InjectableContext> requestContextSingleton;
    private final List<InjectableContext> sessionContextSingleton;
    private final ClassValue<List<InjectableContext>> unoptimizedContexts;
    final Set<Class<? extends Annotation>> scopes;

    Contexts(ManagedContext requestContext, ManagedContext sessionContext, InjectableContext applicationContext, InjectableContext singletonContext, InjectableContext dependentContext, Map<Class<? extends Annotation>, List<InjectableContext>> contexts) {
        this.requestContext = requestContext;
        this.sessionContext = sessionContext;
        this.applicationContext = applicationContext;
        this.singletonContext = singletonContext;
        this.dependentContext = dependentContext;
        this.applicationContextSingleton = List.of(applicationContext);
        this.singletonContextSingleton = List.of(singletonContext);
        this.dependentContextSingleton = List.of(dependentContext);
        List<InjectableContext> requestContexts = contexts.get(RequestScoped.class);
        this.requestContextSingleton = requestContexts != null ? requestContexts : List.of(requestContext);
        List<InjectableContext> sessionContexts = contexts.get(SessionScoped.class);
        List<InjectableContext> list = this.sessionContextSingleton = sessionContexts != null ? sessionContexts : List.of(sessionContext);
        if (!contexts.isEmpty()) {
            final int mapSize = contexts.size();
            final Class[] keys = new Class[mapSize];
            final List[] values = new List[mapSize];
            int index = 0;
            for (Map.Entry<Class<? extends Annotation>, List<InjectableContext>> entry : contexts.entrySet()) {
                keys[index] = entry.getKey();
                values[index] = entry.getValue();
                ++index;
            }
            this.unoptimizedContexts = new ClassValue<List<InjectableContext>>(){

                @Override
                protected List<InjectableContext> computeValue(Class<?> type) {
                    for (int i = 0; i < mapSize; ++i) {
                        if (!keys[i].equals(type)) continue;
                        return values[i];
                    }
                    return Collections.emptyList();
                }
            };
            HashSet<Class<? extends Annotation>> all = new HashSet<Class<? extends Annotation>>(contexts.keySet());
            all.add(ApplicationScoped.class);
            all.add(Singleton.class);
            all.add(Dependent.class);
            all.add(RequestScoped.class);
            all.add(SessionScoped.class);
            this.scopes = Set.copyOf(all);
        } else {
            this.unoptimizedContexts = null;
            this.scopes = Set.of(ApplicationScoped.class, Singleton.class, Dependent.class, RequestScoped.class, SessionScoped.class);
        }
    }

    InjectableContext getActiveContext(Class<? extends Annotation> scopeType) {
        if (ApplicationScoped.class.equals(scopeType)) {
            return this.applicationContext;
        }
        if (Singleton.class.equals(scopeType)) {
            return this.singletonContext;
        }
        if (Dependent.class.equals(scopeType)) {
            return this.dependentContext;
        }
        List<InjectableContext> contextsForScope = this.getContexts(scopeType);
        InjectableContext selected = null;
        for (InjectableContext context : contextsForScope) {
            if (!context.isActive()) continue;
            if (selected != null) {
                throw new IllegalArgumentException("More than one active context object for the given scope: " + String.valueOf(selected) + " " + String.valueOf(context));
            }
            selected = context;
        }
        return selected;
    }

    List<InjectableContext> getContexts(Class<? extends Annotation> scopeType) {
        if (ApplicationScoped.class.equals(scopeType)) {
            return this.applicationContextSingleton;
        }
        if (RequestScoped.class.equals(scopeType)) {
            return this.requestContextSingleton;
        }
        if (Singleton.class.equals(scopeType)) {
            return this.singletonContextSingleton;
        }
        if (Dependent.class.equals(scopeType)) {
            return this.dependentContextSingleton;
        }
        if (SessionScoped.class.equals(scopeType)) {
            return this.sessionContextSingleton;
        }
        return this.unoptimizedContexts != null ? this.unoptimizedContexts.get(scopeType) : Collections.emptyList();
    }

    static class Builder {
        private final ManagedContext requestContext;
        private final ManagedContext sessionContext;
        private final InjectableContext applicationContext;
        private final InjectableContext singletonContext;
        private final InjectableContext dependentContext;
        private final Map<Class<? extends Annotation>, List<InjectableContext>> contexts = new HashMap<Class<? extends Annotation>, List<InjectableContext>>();

        public Builder(ManagedContext requestContext, ManagedContext sessionContext, InjectableContext applicationContext, InjectableContext singletonContext, InjectableContext dependentContext) {
            this.requestContext = requestContext;
            this.sessionContext = sessionContext;
            this.applicationContext = applicationContext;
            this.singletonContext = singletonContext;
            this.dependentContext = dependentContext;
        }

        Builder putContext(InjectableContext context) {
            List<InjectableContext> values = this.contexts.get(context.getScope());
            if (values == null) {
                this.contexts.put(context.getScope(), Collections.singletonList(context));
            } else {
                ArrayList<InjectableContext> multi = new ArrayList<InjectableContext>(values.size() + 1);
                multi.addAll(values);
                multi.add(context);
                this.contexts.put(context.getScope(), List.copyOf(multi));
            }
            return this;
        }

        Contexts build() {
            if (this.contexts.containsKey(RequestScoped.class)) {
                this.putContext(this.requestContext);
            }
            return new Contexts(this.requestContext, this.sessionContext, this.applicationContext, this.singletonContext, this.dependentContext, this.contexts);
        }
    }
}

