/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.arc.impl;

import io.quarkus.arc.ContextInstanceHandle;
import io.quarkus.arc.CurrentContext;
import io.quarkus.arc.InjectableBean;
import io.quarkus.arc.InjectableContext;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.ManagedContext;
import io.quarkus.arc.impl.ContextInstanceHandleImpl;
import io.quarkus.arc.impl.ContextInstances;
import io.quarkus.arc.impl.CreationalContextImpl;
import io.quarkus.arc.impl.EventImpl;
import io.quarkus.arc.impl.Scopes;
import jakarta.enterprise.context.ContextNotActiveException;
import jakarta.enterprise.context.RequestScoped;
import jakarta.enterprise.context.spi.Contextual;
import jakarta.enterprise.context.spi.CreationalContext;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

class RequestContext
implements ManagedContext {
    private static final Logger LOG = Logger.getLogger("io.quarkus.arc.requestContext");
    private final CurrentContext<RequestContextState> currentContext;
    private final EventImpl.Notifier<Object> initializedNotifier;
    private final EventImpl.Notifier<Object> beforeDestroyedNotifier;
    private final EventImpl.Notifier<Object> destroyedNotifier;
    private final Supplier<ContextInstances> contextInstances;

    public RequestContext(CurrentContext<RequestContextState> currentContext, EventImpl.Notifier<Object> initializedNotifier, EventImpl.Notifier<Object> beforeDestroyedNotifier, EventImpl.Notifier<Object> destroyedNotifier, Supplier<ContextInstances> contextInstances) {
        this.currentContext = currentContext;
        this.initializedNotifier = initializedNotifier;
        this.beforeDestroyedNotifier = beforeDestroyedNotifier;
        this.destroyedNotifier = destroyedNotifier;
        this.contextInstances = contextInstances;
    }

    @Override
    public Class<? extends Annotation> getScope() {
        return RequestScoped.class;
    }

    @Override
    public <T> T getIfActive(final Contextual<T> contextual, Function<Contextual<T>, CreationalContext<T>> creationalContextFun) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        Objects.requireNonNull(creationalContextFun, "CreationalContext supplier must not be null");
        final InjectableBean bean = (InjectableBean)contextual;
        if (!Scopes.scopeMatches(this, bean)) {
            throw Scopes.scopeDoesNotMatchException(this, bean);
        }
        RequestContextState ctxState = this.currentContext.get();
        if (!this.isActive(ctxState)) {
            return null;
        }
        ContextInstances contextInstances = ctxState.contextInstances;
        ContextInstanceHandle<?> instance = contextInstances.getIfPresent(bean.getIdentifier());
        if (instance == null) {
            final CreationalContext<T> creationalContext = creationalContextFun.apply(contextual);
            return contextInstances.computeIfAbsent(bean.getIdentifier(), new Supplier<ContextInstanceHandle<?>>(){

                @Override
                public ContextInstanceHandle<?> get() {
                    return new ContextInstanceHandleImpl(bean, contextual.create(creationalContext), creationalContext);
                }
            }).get();
        }
        return instance.get();
    }

    @Override
    public <T> T get(Contextual<T> contextual, CreationalContext<T> creationalContext) {
        T result = this.getIfActive(contextual, CreationalContextImpl.unwrap(Objects.requireNonNull(creationalContext, "CreationalContext must not be null")));
        if (result == null) {
            throw this.notActive();
        }
        return result;
    }

    @Override
    public <T> T get(Contextual<T> contextual) {
        Objects.requireNonNull(contextual, "Contextual must not be null");
        InjectableBean bean = (InjectableBean)contextual;
        if (!Scopes.scopeMatches(this, bean)) {
            throw Scopes.scopeDoesNotMatchException(this, bean);
        }
        RequestContextState state = this.currentContext.get();
        if (!this.isActive(state)) {
            throw this.notActive();
        }
        ContextInstanceHandle<?> instance = state.contextInstances.getIfPresent(bean.getIdentifier());
        return instance == null ? null : (T)instance.get();
    }

    @Override
    public boolean isActive() {
        return this.isActive(this.currentContext.get());
    }

    private boolean isActive(RequestContextState state) {
        return state == null ? false : state.isValid();
    }

    @Override
    public void destroy(Contextual<?> contextual) {
        RequestContextState state = this.currentContext.get();
        if (!this.isActive(state)) {
            throw this.notActive();
        }
        InjectableBean bean = (InjectableBean)contextual;
        ContextInstanceHandle<?> instance = state.contextInstances.remove(bean.getIdentifier());
        if (instance != null) {
            instance.destroy();
        }
    }

    @Override
    public InjectableContext.ContextState activate(InjectableContext.ContextState initialState) {
        if (LOG.isTraceEnabled()) {
            this.traceActivate(initialState);
        }
        if (initialState == null) {
            RequestContextState state = new RequestContextState(this.contextInstances.get());
            this.currentContext.set(state);
            this.fireIfNotEmpty(this.initializedNotifier);
            return state;
        }
        if (initialState instanceof RequestContextState) {
            this.currentContext.set((RequestContextState)initialState);
            return initialState;
        }
        throw new IllegalArgumentException("Invalid initial state: " + initialState.getClass().getName());
    }

    private void traceActivate(InjectableContext.ContextState initialState) {
        String stack = Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(7L).map(se -> "\n\t" + se.toString()).collect(Collectors.joining());
        LOG.tracef("Activate %s %s\n\t...", (Object)(initialState != null ? Integer.toHexString(initialState.hashCode()) : "new"), (Object)stack);
    }

    @Override
    public InjectableContext.ContextState getState() {
        RequestContextState state = this.currentContext.get();
        if (!this.isActive(state)) {
            throw this.notActive();
        }
        return state;
    }

    @Override
    public InjectableContext.ContextState getStateIfActive() {
        RequestContextState state = this.currentContext.get();
        return state != null && state.isValid() ? state : null;
    }

    @Override
    public void deactivate() {
        if (LOG.isTraceEnabled()) {
            RequestContext.traceDeactivate();
        }
        this.currentContext.remove();
    }

    private static void traceDeactivate() {
        String stack = Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(7L).map(se -> "\n\t" + se.toString()).collect(Collectors.joining());
        LOG.tracef("Deactivate%s\n\t...", (Object)stack);
    }

    @Override
    public void destroy() {
        this.destroy(this.currentContext.get());
    }

    @Override
    public void destroy(InjectableContext.ContextState state) {
        if (LOG.isTraceEnabled()) {
            RequestContext.traceDestroy(state);
        }
        if (state == null) {
            return;
        }
        if (state instanceof RequestContextState) {
            RequestContextState reqState = (RequestContextState)state;
            if (reqState.invalidate()) {
                this.fireIfNotEmpty(this.beforeDestroyedNotifier);
                reqState.contextInstances.removeEach(ContextInstanceHandle::destroy);
                this.fireIfNotEmpty(this.destroyedNotifier);
            }
        } else {
            throw new IllegalArgumentException("Invalid state implementation: " + state.getClass().getName());
        }
    }

    private static void traceDestroy(InjectableContext.ContextState state) {
        String stack = Arrays.stream(Thread.currentThread().getStackTrace()).skip(2L).limit(7L).map(se -> "\n\t" + se.toString()).collect(Collectors.joining());
        LOG.tracef("Destroy %s%s\n\t...", (Object)(state != null ? Integer.toHexString(state.hashCode()) : ""), (Object)stack);
    }

    private void fireIfNotEmpty(EventImpl.Notifier<Object> notifier) {
        if (notifier != null && !notifier.isEmpty()) {
            try {
                notifier.notify(this.toString());
            }
            catch (Exception e) {
                LOG.warn((Object)("An error occurred during delivery of the container lifecycle event for qualifiers " + String.valueOf(notifier.eventMetadata.getQualifiers())), e);
            }
        }
    }

    private ContextNotActiveException notActive() {
        String msg = "Request context is not active - you can activate the request context for a specific method using the @ActivateRequestContext interceptor binding";
        return new ContextNotActiveException(msg);
    }

    static class RequestContextState
    implements InjectableContext.ContextState {
        private static final int VALID = 0;
        private static final int INVALID = 1;
        private static final VarHandle IS_VALID;
        private final ContextInstances contextInstances;
        private volatile int isValid;

        RequestContextState(ContextInstances contextInstances) {
            this.contextInstances = Objects.requireNonNull(contextInstances);
        }

        @Override
        public Map<InjectableBean<?>, Object> getContextualInstances() {
            return this.contextInstances.getAllPresent().stream().collect(Collectors.toUnmodifiableMap(InstanceHandle::getBean, InstanceHandle::get));
        }

        boolean invalidate() {
            return IS_VALID.compareAndSet(this, 0, 1);
        }

        @Override
        public boolean isValid() {
            return this.isValid == 0;
        }

        static {
            try {
                IS_VALID = MethodHandles.lookup().findVarHandle(RequestContextState.class, "isValid", Integer.TYPE);
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        }
    }
}

