/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.funqy.deployment.bindings.knative.events;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.quarkus.arc.deployment.BeanContainerBuildItem;
import io.quarkus.arc.deployment.UnremovableBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ExecutorBuildItem;
import io.quarkus.deployment.builditem.FeatureBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.funqy.deployment.FunctionBuildItem;
import io.quarkus.funqy.deployment.FunctionInitializedBuildItem;
import io.quarkus.funqy.runtime.bindings.knative.events.KnativeEventsBindingRecorder;
import io.quarkus.jackson.runtime.ObjectMapperProducer;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.vertx.core.deployment.CoreVertxBuildItem;
import io.quarkus.vertx.http.deployment.RequireBodyHandlerBuildItem;
import io.quarkus.vertx.http.deployment.RouteBuildItem;
import io.quarkus.vertx.http.runtime.VertxHttpBuildTimeConfig;
import io.vertx.core.Handler;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import org.jboss.logging.Logger;

public class FunqyKnativeEventsBuildStep {
    private static final Logger log = Logger.getLogger(FunqyKnativeEventsBuildStep.class);
    public static final String FUNQY_KNATIVE_FEATURE = "funqy-knative-events";

    @BuildStep
    public void markObjectMapper(BuildProducer<UnremovableBeanBuildItem> unremovable) {
        unremovable.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNameExclusion(ObjectMapper.class.getName())));
        unremovable.produce((BuildItem)new UnremovableBeanBuildItem(new UnremovableBeanBuildItem.BeanClassNameExclusion(ObjectMapperProducer.class.getName())));
    }

    @BuildStep
    public RequireBodyHandlerBuildItem requireBodyHandler(List<FunctionBuildItem> functions) {
        if (!functions.isEmpty()) {
            return new RequireBodyHandlerBuildItem();
        }
        return null;
    }

    @BuildStep
    @Record(value=ExecutionTime.STATIC_INIT)
    public void staticInit(KnativeEventsBindingRecorder binding, List<FunctionBuildItem> functions, Optional<FunctionInitializedBuildItem> hasFunctions, BeanContainerBuildItem beanContainer) throws Exception {
        if (!hasFunctions.isPresent() || hasFunctions.get() == null) {
            return;
        }
        binding.init();
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void boot(ShutdownContextBuildItem shutdown, KnativeEventsBindingRecorder binding, Optional<FunctionInitializedBuildItem> hasFunctions, List<FunctionBuildItem> functions, BuildProducer<FeatureBuildItem> feature, BuildProducer<RouteBuildItem> routes, CoreVertxBuildItem vertx, BeanContainerBuildItem beanContainer, VertxHttpBuildTimeConfig httpBuildTimeConfig, ExecutorBuildItem executorBuildItem) {
        if (!hasFunctions.isPresent() || hasFunctions.get() == null) {
            return;
        }
        feature.produce((BuildItem)new FeatureBuildItem(FUNQY_KNATIVE_FEATURE));
        Object rootPath = httpBuildTimeConfig.rootPath();
        if (rootPath == null) {
            rootPath = "/";
        } else if (!((String)rootPath).endsWith("/")) {
            rootPath = (String)rootPath + "/";
        }
        Handler handler = binding.start((String)rootPath, vertx.getVertx(), (ShutdownContext)shutdown, beanContainer.getValue(), (Executor)executorBuildItem.getExecutorProxy());
        routes.produce((BuildItem)RouteBuildItem.builder().route("/").handler(handler).build());
        for (FunctionBuildItem function : functions) {
            String name = function.getFunctionName() == null ? function.getMethodName() : function.getFunctionName();
            String path = "/" + name;
            routes.produce((BuildItem)RouteBuildItem.builder().route(path).handler(handler).build());
        }
    }
}

