/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.generate_doc;

import io.quarkus.annotation.processor.generate_doc.ConfigDocItem;
import io.quarkus.annotation.processor.generate_doc.ConfigRootInfo;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class ScannedConfigDocsItemHolder {
    private final Map<String, List<ConfigDocItem>> configGroupConfigItems;
    private final Map<ConfigRootInfo, List<ConfigDocItem>> configRootConfigItems;
    private final Map<String, ConfigRootInfo> configRootClassToConfigRootInfo = new HashMap<String, ConfigRootInfo>();

    public ScannedConfigDocsItemHolder() {
        this(new HashMap<ConfigRootInfo, List<ConfigDocItem>>(), new HashMap<String, List<ConfigDocItem>>());
    }

    public ScannedConfigDocsItemHolder(Map<ConfigRootInfo, List<ConfigDocItem>> configRootConfigItems, Map<String, List<ConfigDocItem>> configGroupConfigItems) {
        this.configRootConfigItems = configRootConfigItems;
        this.configGroupConfigItems = configGroupConfigItems;
    }

    public Map<String, List<ConfigDocItem>> getConfigGroupConfigItems() {
        return this.configGroupConfigItems;
    }

    public Map<ConfigRootInfo, List<ConfigDocItem>> getConfigRootConfigItems() {
        return this.configRootConfigItems;
    }

    public void addConfigGroupItems(String configGroupName, List<ConfigDocItem> configDocItems) {
        this.configGroupConfigItems.put(configGroupName, configDocItems);
    }

    public void addConfigRootItems(ConfigRootInfo configRoot, List<ConfigDocItem> configDocItems) {
        this.configRootConfigItems.put(configRoot, configDocItems);
        this.configRootClassToConfigRootInfo.put(configRoot.getClazz().getQualifiedName().toString(), configRoot);
    }

    public List<ConfigDocItem> getConfigItemsByRootClassName(String configRootClassName) {
        ConfigRootInfo configRootInfo = this.configRootClassToConfigRootInfo.get(configRootClassName);
        if (configRootInfo == null) {
            return null;
        }
        return this.configRootConfigItems.get(configRootInfo);
    }

    public boolean isEmpty() {
        return this.configRootConfigItems.isEmpty();
    }

    public String toString() {
        return "ScannedConfigDocsItemHolder{, configRootConfigItems=" + String.valueOf(this.configRootConfigItems) + ", configGroupConfigItems=" + String.valueOf(this.configGroupConfigItems) + "}";
    }
}

