/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor;

import io.quarkus.annotation.processor.Constants;
import io.quarkus.annotation.processor.generate_doc.ConfigDocGeneratedOutput;
import io.quarkus.annotation.processor.generate_doc.ConfigDocItemScanner;
import io.quarkus.annotation.processor.generate_doc.ConfigDocWriter;
import io.quarkus.annotation.processor.generate_doc.DocGeneratorUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Completion;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.jboss.jdeparser.FormatPreferences;
import org.jboss.jdeparser.JAssignableExpr;
import org.jboss.jdeparser.JCall;
import org.jboss.jdeparser.JClassDef;
import org.jboss.jdeparser.JDeparser;
import org.jboss.jdeparser.JExpr;
import org.jboss.jdeparser.JExprs;
import org.jboss.jdeparser.JFiler;
import org.jboss.jdeparser.JMethodDef;
import org.jboss.jdeparser.JSourceFile;
import org.jboss.jdeparser.JSources;
import org.jboss.jdeparser.JType;
import org.jboss.jdeparser.JTypes;

public class ExtensionAnnotationProcessor
extends AbstractProcessor {
    private static final Pattern REMOVE_LEADING_SPACE = Pattern.compile("^ ", 8);
    private static final String QUARKUS_GENERATED = "io.quarkus.Generated";
    private final ConfigDocWriter configDocWriter = new ConfigDocWriter();
    private final ConfigDocItemScanner configDocItemScanner = new ConfigDocItemScanner();
    private final Set<String> generatedAccessors = new ConcurrentHashMap().keySet(Boolean.TRUE);
    private final Set<String> generatedJavaDocs = new ConcurrentHashMap().keySet(Boolean.TRUE);
    private final boolean generateDocs = !Boolean.getBoolean("skipDocs") && !Boolean.getBoolean("quickly");
    private final Map<String, Boolean> ANNOTATION_USAGE_TRACKER = new ConcurrentHashMap<String, Boolean>();

    @Override
    public Set<String> getSupportedOptions() {
        return Collections.emptySet();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Constants.SUPPORTED_ANNOTATIONS_TYPES;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.doProcess(annotations, roundEnv);
            if (roundEnv.processingOver()) {
                this.doFinish();
            }
            boolean bl = true;
            return bl;
        }
        finally {
            JDeparser.dropCaches();
        }
    }

    @Override
    public Iterable<? extends Completion> getCompletions(Element element, AnnotationMirror annotation, ExecutableElement member, String userText) {
        return Collections.emptySet();
    }

    public void doProcess(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement typeElement : annotations) {
            switch (typeElement.getQualifiedName().toString()) {
                case "io.quarkus.deployment.annotations.BuildStep": {
                    this.trackAnnotationUsed("io.quarkus.deployment.annotations.BuildStep");
                    this.processBuildStep(roundEnv, typeElement);
                    break;
                }
                case "io.quarkus.runtime.annotations.ConfigGroup": {
                    this.trackAnnotationUsed("io.quarkus.runtime.annotations.ConfigGroup");
                    this.processConfigGroup(roundEnv, typeElement);
                    break;
                }
                case "io.quarkus.runtime.annotations.ConfigRoot": {
                    this.trackAnnotationUsed("io.quarkus.runtime.annotations.ConfigRoot");
                    this.processConfigRoot(roundEnv, typeElement);
                    break;
                }
                case "io.quarkus.runtime.annotations.Recorder": {
                    this.trackAnnotationUsed("io.quarkus.runtime.annotations.Recorder");
                    this.processRecorder(roundEnv, typeElement);
                    break;
                }
                case "io.smallrye.config.ConfigMapping": {
                    this.trackAnnotationUsed("io.smallrye.config.ConfigMapping");
                }
            }
        }
    }

    void doFinish() {
        FileObject listResource;
        Path path;
        FileObject tempResource;
        this.validateAnnotationUsage();
        Filer filer = this.processingEnv.getFiler();
        try {
            tempResource = filer.createResource(StandardLocation.SOURCE_OUTPUT, "", "ignore.tmp", new Element[0]);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to create temp output file: " + e);
            return;
        }
        URI uri = tempResource.toUri();
        try {
            path = Paths.get(uri).getParent();
        }
        catch (RuntimeException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Resource path URI is invalid: " + uri);
            return;
        }
        final TreeSet<String> bscListClasses = new TreeSet<String>();
        final TreeSet<String> crListClasses = new TreeSet<String>();
        final Properties javaDocProperties = new Properties();
        try {
            Files.walkFileTree(path, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    String nameStr = file.getFileName().toString();
                    if (nameStr.endsWith(".bsc")) {
                        ExtensionAnnotationProcessor.this.readFile(file, bscListClasses);
                    } else if (nameStr.endsWith(".cr")) {
                        ExtensionAnnotationProcessor.this.readFile(file, crListClasses);
                    } else if (nameStr.endsWith(".jdp")) {
                        Properties p = new Properties();
                        try (BufferedReader br = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
                            p.load(br);
                        }
                        catch (IOException e) {
                            ExtensionAnnotationProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to read file " + file + ": " + e);
                        }
                        Set<String> names = p.stringPropertyNames();
                        for (String name : names) {
                            javaDocProperties.setProperty(name, p.getProperty(name));
                        }
                    }
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    ExtensionAnnotationProcessor.this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to visit file " + file + ": " + exc);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) {
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "File walk failed: " + e);
        }
        if (!bscListClasses.isEmpty()) {
            try {
                listResource = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/quarkus-build-steps.list", new Element[0]);
                this.writeListResourceFile(bscListClasses, listResource);
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write build steps listing: " + e);
                return;
            }
        }
        if (!crListClasses.isEmpty()) {
            try {
                listResource = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/quarkus-config-roots.list", new Element[0]);
                this.writeListResourceFile(crListClasses, listResource);
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write config roots listing: " + e);
                return;
            }
        }
        try {
            listResource = filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/quarkus-javadoc.properties", new Element[0]);
            try (OutputStream os = listResource.openOutputStream();
                 BufferedOutputStream bos = new BufferedOutputStream(os);
                 OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);
                 BufferedWriter bw = new BufferedWriter(osw);){
                javaDocProperties.store(bw, "");
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to write javadoc properties: " + e);
            return;
        }
        try {
            if (this.generateDocs) {
                Set<ConfigDocGeneratedOutput> outputs = this.configDocItemScanner.scanExtensionsConfigurationItems(javaDocProperties, this.isAnnotationUsed("io.smallrye.config.ConfigMapping"));
                for (ConfigDocGeneratedOutput output : outputs) {
                    DocGeneratorUtil.sort(output.getConfigDocItems());
                    this.configDocWriter.writeAllExtensionConfigDocumentation(output);
                }
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to generate extension doc: " + e);
            return;
        }
    }

    private void validateAnnotationUsage() {
        if (this.isAnnotationUsed("io.quarkus.deployment.annotations.BuildStep") && this.isAnnotationUsed("io.quarkus.runtime.annotations.Recorder")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Detected use of @Recorder annotation in 'deployment' module. Classes annotated with @Recorder must be part of the extension's 'runtime' module");
        }
    }

    private boolean isAnnotationUsed(String annotation) {
        return this.ANNOTATION_USAGE_TRACKER.getOrDefault(annotation, false);
    }

    private void trackAnnotationUsed(String annotation) {
        this.ANNOTATION_USAGE_TRACKER.put(annotation, true);
    }

    private void writeListResourceFile(Collection<String> crListClasses, FileObject listResource) throws IOException {
        try (OutputStream os = listResource.openOutputStream();
             BufferedOutputStream bos = new BufferedOutputStream(os);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);
             BufferedWriter bw = new BufferedWriter(osw);){
            for (String item : crListClasses) {
                bw.write(item);
                bw.newLine();
            }
        }
    }

    private void readFile(Path file, Collection<String> bscListClasses) {
        try (BufferedReader br = Files.newBufferedReader(file, StandardCharsets.UTF_8);){
            String line;
            while ((line = br.readLine()) != null) {
                if ((line = line.trim()).isEmpty()) continue;
                bscListClasses.add(line);
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to read file " + file + ": " + e);
        }
    }

    private void processBuildStep(RoundEnvironment roundEnv, TypeElement annotation) {
        HashSet<String> processorClassNames = new HashSet<String>();
        for (ExecutableElement i : ElementFilter.methodsIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            TypeElement clazz = this.getClassOf(i);
            if (clazz == null) continue;
            PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(clazz);
            if (pkg == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Element " + clazz + " has no enclosing package");
                continue;
            }
            String binaryName = this.processingEnv.getElementUtils().getBinaryName(clazz).toString();
            if (!processorClassNames.add(binaryName)) continue;
            this.validateRecordBuildSteps(clazz);
            this.recordConfigJavadoc(clazz);
            this.generateAccessor(clazz);
            StringBuilder rbn = this.getRelativeBinaryName(clazz, new StringBuilder());
            try {
                FileObject itemResource = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, pkg.getQualifiedName().toString(), rbn.toString() + ".bsc", clazz);
                this.writeResourceFile(binaryName, itemResource);
            }
            catch (IOException e1) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to create " + rbn + " in " + pkg + ": " + e1, clazz);
            }
        }
    }

    private void validateRecordBuildSteps(TypeElement clazz) {
        for (Element element : clazz.getEnclosedElements()) {
            ExecutableElement ex;
            if (element.getKind() != ElementKind.METHOD || !ExtensionAnnotationProcessor.isAnnotationPresent(ex = (ExecutableElement)element, "io.quarkus.deployment.annotations.BuildStep") || !ExtensionAnnotationProcessor.isAnnotationPresent(ex, "io.quarkus.deployment.annotations.Record")) continue;
            boolean hasRecorder = false;
            boolean allTypesResolvable = true;
            for (VariableElement variableElement : ex.getParameters()) {
                String parameterClassName = variableElement.asType().toString();
                TypeElement parameterTypeElement = this.processingEnv.getElementUtils().getTypeElement(parameterClassName);
                if (parameterTypeElement == null) {
                    allTypesResolvable = false;
                    continue;
                }
                if (!ExtensionAnnotationProcessor.isAnnotationPresent(parameterTypeElement, "io.quarkus.runtime.annotations.Recorder")) continue;
                if (parameterTypeElement.getModifiers().contains((Object)Modifier.FINAL)) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Class '" + parameterTypeElement.getQualifiedName() + "' is annotated with @Recorder and therefore cannot be made as a final class.");
                } else if (this.getPackageName(clazz).equals(this.getPackageName(parameterTypeElement))) {
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "Build step class '" + clazz.getQualifiedName() + "' and recorder '" + parameterTypeElement + "' share the same package. This is highly discouraged as it can lead to unexpected results.");
                }
                hasRecorder = true;
                break;
            }
            if (hasRecorder || !allTypesResolvable) continue;
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Build Step '" + clazz.getQualifiedName() + "#" + ex.getSimpleName() + "' which is annotated with '@Record' does not contain a method parameter whose type is annotated with '@Recorder'.");
        }
    }

    private Name getPackageName(TypeElement clazz) {
        return this.processingEnv.getElementUtils().getPackageOf(clazz).getQualifiedName();
    }

    private StringBuilder getRelativeBinaryName(TypeElement te, StringBuilder b) {
        Element enclosing = te.getEnclosingElement();
        if (enclosing instanceof TypeElement) {
            this.getRelativeBinaryName((TypeElement)enclosing, b);
            b.append('$');
        }
        b.append(te.getSimpleName());
        return b;
    }

    private TypeElement getClassOf(Element e) {
        Element t = e;
        while (!(t instanceof TypeElement)) {
            if (t == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Element " + e + " has no enclosing class");
                return null;
            }
            t = t.getEnclosingElement();
        }
        return (TypeElement)t;
    }

    private void recordConfigJavadoc(TypeElement clazz) {
        String className = clazz.getQualifiedName().toString();
        if (!this.generatedJavaDocs.add(className)) {
            return;
        }
        Properties javadocProps = new Properties();
        for (Element element : clazz.getEnclosedElements()) {
            switch (element.getKind()) {
                case FIELD: {
                    if (!ExtensionAnnotationProcessor.isDocumentedConfigItem(element)) break;
                    this.processFieldConfigItem((VariableElement)element, javadocProps, className);
                    break;
                }
                case CONSTRUCTOR: {
                    ExecutableElement ex = (ExecutableElement)element;
                    if (!ExtensionAnnotationProcessor.hasParameterDocumentedConfigItem(ex)) break;
                    this.processCtorConfigItem(ex, javadocProps, className);
                    break;
                }
                case METHOD: {
                    ExecutableElement ex = (ExecutableElement)element;
                    if (!ExtensionAnnotationProcessor.hasParameterDocumentedConfigItem(ex)) break;
                    this.processMethodConfigItem(ex, javadocProps, className);
                    break;
                }
                case ENUM: {
                    element.getEnclosedElements().stream().filter(e1 -> e1.getKind() == ElementKind.ENUM_CONSTANT).forEach(ec -> this.processEnumConstant((Element)ec, javadocProps, className));
                    break;
                }
            }
        }
        this.writeJavadocProperties(clazz, javadocProps);
    }

    private void recordMappingJavadoc(TypeElement clazz) {
        String className = clazz.getQualifiedName().toString();
        if (!this.generatedJavaDocs.add(className)) {
            return;
        }
        if (!ExtensionAnnotationProcessor.isAnnotationPresent(clazz, "io.smallrye.config.ConfigMapping") && this.generateDocs) {
            this.configDocItemScanner.addConfigGroups(clazz);
        }
        Properties javadocProps = new Properties();
        this.recordMappingJavadoc(clazz, javadocProps);
        this.writeJavadocProperties(clazz, javadocProps);
    }

    private void recordMappingJavadoc(TypeElement clazz, Properties javadocProps) {
        String className = clazz.getQualifiedName().toString();
        for (Element element : clazz.getEnclosedElements()) {
            switch (element.getKind()) {
                case INTERFACE: {
                    this.recordMappingJavadoc((TypeElement)element);
                    break;
                }
                case METHOD: {
                    if (ExtensionAnnotationProcessor.isConfigMappingMethodIgnored(element)) break;
                    this.processMethodConfigMapping((ExecutableElement)element, javadocProps, className);
                    break;
                }
            }
        }
    }

    private boolean isEnclosedByMapping(Element clazz) {
        Element enclosingElement;
        if (clazz.getKind().equals((Object)ElementKind.INTERFACE) && (enclosingElement = clazz.getEnclosingElement()).getKind().equals((Object)ElementKind.INTERFACE)) {
            if (ExtensionAnnotationProcessor.isAnnotationPresent(enclosingElement, "io.smallrye.config.ConfigMapping")) {
                return true;
            }
            this.isEnclosedByMapping(enclosingElement);
        }
        return false;
    }

    private void writeJavadocProperties(TypeElement clazz, Properties javadocProps) {
        if (javadocProps.isEmpty()) {
            return;
        }
        PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(clazz);
        String rbn = this.getRelativeBinaryName(clazz, new StringBuilder()).append(".jdp").toString();
        try {
            FileObject file = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, pkg.getQualifiedName().toString(), rbn, clazz);
            try (Writer writer = file.openWriter();){
                javadocProps.store(writer, "");
            }
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to persist resource " + rbn + ": " + e);
        }
    }

    private void processFieldConfigItem(VariableElement field, Properties javadocProps, String className) {
        javadocProps.put(className + "." + field.getSimpleName().toString(), this.getRequiredJavadoc(field));
    }

    private void processEnumConstant(Element field, Properties javadocProps, String className) {
        String javaDoc = this.getJavadoc(field);
        if (javaDoc != null && !javaDoc.isBlank()) {
            javadocProps.put(className + "." + field.getSimpleName().toString(), javaDoc);
        }
    }

    private void processCtorConfigItem(ExecutableElement ctor, Properties javadocProps, String className) {
        String docComment = this.getRequiredJavadoc(ctor);
        StringBuilder buf = new StringBuilder();
        this.appendParamTypes(ctor, buf);
        javadocProps.put(className + "." + buf, docComment);
    }

    private void processMethodConfigItem(ExecutableElement method, Properties javadocProps, String className) {
        String docComment = this.getRequiredJavadoc(method);
        StringBuilder buf = new StringBuilder();
        buf.append(method.getSimpleName().toString());
        this.appendParamTypes(method, buf);
        javadocProps.put(className + "." + buf, docComment);
    }

    private void processMethodConfigMapping(ExecutableElement method, Properties javadocProps, String className) {
        if (method.getModifiers().contains((Object)Modifier.ABSTRACT)) {
            TypeElement type;
            DeclaredType declaredType;
            if (method.getSimpleName().contentEquals("toString") && method.getParameters().size() == 0) {
                return;
            }
            String docComment = this.getRequiredJavadoc(method);
            javadocProps.put(className + "." + method.getSimpleName().toString(), docComment);
            TypeMirror returnType = method.getReturnType();
            if (TypeKind.DECLARED.equals((Object)returnType.getKind()) && !ExtensionAnnotationProcessor.isAnnotationPresent((declaredType = (DeclaredType)returnType).asElement(), "io.quarkus.runtime.annotations.ConfigGroup") && (type = this.unwrapConfigGroup(returnType)) != null && ElementKind.INTERFACE.equals((Object)type.getKind())) {
                this.recordMappingJavadoc(type);
                this.configDocItemScanner.addConfigGroups(type);
            }
        }
    }

    private TypeElement unwrapConfigGroup(TypeMirror typeMirror) {
        if (typeMirror == null) {
            return null;
        }
        DeclaredType declaredType = (DeclaredType)typeMirror;
        String name = declaredType.asElement().toString();
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.size() == 0) {
            if (!name.startsWith("java.")) {
                return (TypeElement)declaredType.asElement();
            }
        } else if (typeArguments.size() == 1) {
            if (name.equals(Optional.class.getName()) || name.equals(List.class.getName()) || name.equals(Set.class.getName())) {
                return this.unwrapConfigGroup(typeArguments.get(0));
            }
        } else if (typeArguments.size() == 2 && name.equals(Map.class.getName())) {
            return this.unwrapConfigGroup(typeArguments.get(1));
        }
        return null;
    }

    private void processConfigGroup(RoundEnvironment roundEnv, TypeElement annotation) {
        HashSet<String> groupClassNames = new HashSet<String>();
        for (TypeElement i : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            if (!groupClassNames.add(i.getQualifiedName().toString())) continue;
            this.generateAccessor(i);
            if (this.isEnclosedByMapping(i) || i.getKind().equals((Object)ElementKind.INTERFACE)) {
                this.recordMappingJavadoc(i);
            } else {
                this.recordConfigJavadoc(i);
            }
            if (!this.generateDocs) continue;
            this.configDocItemScanner.addConfigGroups(i);
        }
    }

    private void processConfigRoot(RoundEnvironment roundEnv, TypeElement annotation) {
        HashSet<String> rootClassNames = new HashSet<String>();
        for (TypeElement clazz : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            String binaryName;
            PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(clazz);
            if (pkg == null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Element " + clazz + " has no enclosing package");
                continue;
            }
            if (this.generateDocs) {
                this.configDocItemScanner.addConfigRoot(pkg, clazz);
            }
            if (!rootClassNames.add(binaryName = this.processingEnv.getElementUtils().getBinaryName(clazz).toString())) continue;
            if (ExtensionAnnotationProcessor.isAnnotationPresent(clazz, "io.smallrye.config.ConfigMapping")) {
                this.recordMappingJavadoc(clazz);
            } else if (ExtensionAnnotationProcessor.isAnnotationPresent(clazz, "io.quarkus.runtime.annotations.ConfigRoot")) {
                this.recordConfigJavadoc(clazz);
                this.generateAccessor(clazz);
            }
            StringBuilder rbn = this.getRelativeBinaryName(clazz, new StringBuilder());
            try {
                FileObject itemResource = this.processingEnv.getFiler().createResource(StandardLocation.SOURCE_OUTPUT, pkg.getQualifiedName().toString(), rbn + ".cr", clazz);
                this.writeResourceFile(binaryName, itemResource);
            }
            catch (IOException e1) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to create " + rbn + " in " + pkg + ": " + e1, clazz);
            }
        }
    }

    private void writeResourceFile(String binaryName, FileObject itemResource) throws IOException {
        try (OutputStream os = itemResource.openOutputStream();
             BufferedOutputStream bos = new BufferedOutputStream(os);
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)bos, StandardCharsets.UTF_8);
             BufferedWriter bw = new BufferedWriter(osw);){
            bw.write(binaryName);
            bw.newLine();
        }
    }

    private void processRecorder(RoundEnvironment roundEnv, TypeElement annotation) {
        HashSet<String> groupClassNames = new HashSet<String>();
        for (TypeElement i : ElementFilter.typesIn(roundEnv.getElementsAnnotatedWith(annotation))) {
            if (!groupClassNames.add(i.getQualifiedName().toString())) continue;
            this.generateAccessor(i);
            this.recordConfigJavadoc(i);
        }
    }

    private void generateAccessor(TypeElement clazz) {
        DeclaredType declaredType;
        TypeMirror enclosingType;
        if (!this.generatedAccessors.add(clazz.getQualifiedName().toString())) {
            return;
        }
        FormatPreferences fp = new FormatPreferences();
        JSources sources = JDeparser.createSources((JFiler)JFiler.newInstance((Filer)this.processingEnv.getFiler()), (FormatPreferences)fp);
        PackageElement packageElement = this.processingEnv.getElementUtils().getPackageOf(clazz);
        String className = this.getRelativeBinaryName(clazz, new StringBuilder()).append("$$accessor").toString();
        JSourceFile sourceFile = sources.createSourceFile(packageElement.getQualifiedName().toString(), className);
        JType clazzType = JTypes.typeOf((TypeMirror)clazz.asType());
        if (clazz.asType() instanceof DeclaredType && (enclosingType = (declaredType = (DeclaredType)clazz.asType()).getEnclosingType()) != null && enclosingType.getKind() == TypeKind.DECLARED && clazz.getModifiers().contains((Object)Modifier.STATIC)) {
            clazzType = this.unnestStaticNestedType(declaredType);
        }
        JClassDef classDef = sourceFile._class(34, className);
        classDef.constructor(8);
        classDef.annotate(QUARKUS_GENERATED).value("Quarkus annotation processor");
        JAssignableExpr instanceName = JExprs.name((String)"__instance");
        boolean isEnclosingClassPublic = clazz.getModifiers().contains((Object)Modifier.PUBLIC);
        boolean generationNeeded = false;
        for (VariableElement field : ElementFilter.fieldsIn(clazz.getEnclosedElements())) {
            DeclaredType declaredType2;
            TypeElement typeElement;
            Set<Modifier> mods = field.getModifiers();
            if (mods.contains((Object)Modifier.PRIVATE) || mods.contains((Object)Modifier.STATIC) || mods.contains((Object)Modifier.FINAL)) continue;
            TypeMirror fieldType = field.asType();
            if (mods.contains((Object)Modifier.PUBLIC) && isEnclosingClassPublic && (!(fieldType instanceof DeclaredType) || (typeElement = (TypeElement)(declaredType2 = (DeclaredType)fieldType).asElement()).getModifiers().contains((Object)Modifier.PUBLIC))) continue;
            generationNeeded = true;
            JType jType = JTypes.typeOf((TypeMirror)fieldType);
            JType publicType = fieldType instanceof PrimitiveType ? jType : JType.OBJECT;
            String fieldName = field.getSimpleName().toString();
            JMethodDef jMethodDef = classDef.method(96, publicType, "get_" + fieldName);
            jMethodDef.annotate(SuppressWarnings.class).value("unchecked");
            jMethodDef.param(JType.OBJECT, "__instance");
            jMethodDef.body()._return((JExpr)instanceName.cast(clazzType).field(fieldName));
            JMethodDef setter = classDef.method(96, JType.VOID, "set_" + fieldName);
            setter.annotate(SuppressWarnings.class).value("unchecked");
            setter.param(JType.OBJECT, "__instance");
            setter.param(publicType, fieldName);
            JAssignableExpr fieldExpr = JExprs.name((String)fieldName);
            setter.body().assign(instanceName.cast(clazzType).field(fieldName), (JExpr)(publicType.equals(jType) ? fieldExpr : fieldExpr.cast(jType)));
        }
        if (!isEnclosingClassPublic) {
            for (ExecutableElement ctor : ElementFilter.constructorsIn(clazz.getEnclosedElements())) {
                if (ctor.getModifiers().contains((Object)Modifier.PRIVATE)) continue;
                generationNeeded = true;
                StringBuilder b = new StringBuilder();
                for (VariableElement variableElement : ctor.getParameters()) {
                    b.append('_');
                    b.append(variableElement.asType().toString().replace('.', '_'));
                }
                String codedName = b.toString();
                JMethodDef jMethodDef = classDef.method(96, JType.OBJECT, "construct" + codedName);
                JCall ctorCall = clazzType._new();
                for (VariableElement variableElement : ctor.getParameters()) {
                    TypeMirror paramType = variableElement.asType();
                    JType realType = JTypes.typeOf((TypeMirror)paramType);
                    JType publicType = paramType instanceof PrimitiveType ? realType : JType.OBJECT;
                    String name = variableElement.getSimpleName().toString();
                    jMethodDef.param(publicType, name);
                    JAssignableExpr nameExpr = JExprs.name((String)name);
                    ctorCall.arg((JExpr)(publicType.equals(realType) ? nameExpr : nameExpr.cast(realType)));
                }
                jMethodDef.body()._return((JExpr)ctorCall);
            }
        }
        if (generationNeeded) {
            try {
                sources.writeSources();
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Failed to generate source file: " + e, clazz);
            }
        }
    }

    private JType unnestStaticNestedType(DeclaredType declaredType) {
        TypeElement typeElement = (TypeElement)declaredType.asElement();
        String name = typeElement.getQualifiedName().toString();
        JType rawType = JTypes.typeNamed((String)name);
        List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
        if (typeArguments.isEmpty()) {
            return rawType;
        }
        JType[] args = new JType[typeArguments.size()];
        for (int i = 0; i < typeArguments.size(); ++i) {
            TypeMirror argument = typeArguments.get(i);
            args[i] = JTypes.typeOf((TypeMirror)argument);
        }
        return rawType.typeArg(args);
    }

    private void appendParamTypes(ExecutableElement ex, StringBuilder buf) {
        List<? extends VariableElement> params = ex.getParameters();
        if (params.isEmpty()) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Expected at least one parameter", ex);
            return;
        }
        VariableElement param = params.get(0);
        DeclaredType dt = (DeclaredType)param.asType();
        String typeName = this.processingEnv.getElementUtils().getBinaryName((TypeElement)dt.asElement()).toString();
        buf.append('(').append(typeName);
        for (int i = 1; i < params.size(); ++i) {
            param = params.get(i);
            dt = (DeclaredType)param.asType();
            typeName = this.processingEnv.getElementUtils().getBinaryName((TypeElement)dt.asElement()).toString();
            buf.append(',').append(typeName);
        }
        buf.append(')');
    }

    private String getRequiredJavadoc(Element e) {
        String javaDoc = this.getJavadoc(e);
        if (javaDoc == null) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Unable to find javadoc for config item " + e.getEnclosingElement() + " " + e, e);
            return "";
        }
        return javaDoc;
    }

    private String getJavadoc(Element e) {
        String docComment = this.processingEnv.getElementUtils().getDocComment(e);
        if (docComment == null) {
            return null;
        }
        return REMOVE_LEADING_SPACE.matcher(docComment).replaceAll("").trim();
    }

    private static boolean isDocumentedConfigItem(Element element) {
        boolean hasAnnotation = false;
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String annotationName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if ("io.quarkus.runtime.annotations.ConfigItem".equals(annotationName)) {
                hasAnnotation = true;
                Object generateDocumentation = ExtensionAnnotationProcessor.getAnnotationAttribute(annotationMirror, "generateDocumentation()");
                if (generateDocumentation == null || ((Boolean)generateDocumentation).booleanValue()) continue;
                return false;
            }
            if (!"io.quarkus.runtime.annotations.ConfigDocSection".equals(annotationName)) continue;
            hasAnnotation = true;
        }
        return hasAnnotation;
    }

    private static boolean isConfigMappingMethodIgnored(Element element) {
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String annotationName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (!"io.quarkus.runtime.annotations.ConfigDocIgnore".equals(annotationName)) continue;
            return true;
        }
        return false;
    }

    private static Object getAnnotationAttribute(AnnotationMirror annotationMirror, String attributeName) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
            String key = entry.getKey().toString();
            Object value = entry.getValue().getValue();
            if (!attributeName.equals(key)) continue;
            return value;
        }
        return null;
    }

    private static boolean hasParameterDocumentedConfigItem(ExecutableElement ex) {
        for (VariableElement variableElement : ex.getParameters()) {
            if (!ExtensionAnnotationProcessor.isDocumentedConfigItem(variableElement)) continue;
            return true;
        }
        return false;
    }

    private static boolean isAnnotationPresent(Element element, String ... annotationNames) {
        HashSet<String> annotations = new HashSet<String>(Arrays.asList(annotationNames));
        for (AnnotationMirror annotationMirror : element.getAnnotationMirrors()) {
            String annotationName = ((TypeElement)annotationMirror.getAnnotationType().asElement()).getQualifiedName().toString();
            if (!annotations.contains(annotationName)) continue;
            return true;
        }
        return false;
    }
}

