/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.scanner;

import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigGroup;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigProperty;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryConfigRoot;
import io.quarkus.annotation.processor.documentation.config.discovery.DiscoveryRootElement;
import io.quarkus.annotation.processor.documentation.config.discovery.EnumDefinition;
import io.quarkus.annotation.processor.documentation.config.discovery.ResolvedType;
import io.quarkus.annotation.processor.documentation.config.model.ConfigPhase;
import io.quarkus.annotation.processor.documentation.config.model.ExtensionModule;
import io.quarkus.annotation.processor.documentation.config.model.SourceElementType;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigAnnotationListener;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigCollector;
import io.quarkus.annotation.processor.documentation.config.util.ConfigNamingUtil;
import io.quarkus.annotation.processor.util.Config;
import io.quarkus.annotation.processor.util.Utils;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;

public class ConfigMappingListener
implements ConfigAnnotationListener {
    private final Config config;
    private final Utils utils;
    private final ConfigCollector configCollector;

    ConfigMappingListener(Config config, Utils utils, ConfigCollector configCollector) {
        this.config = config;
        this.utils = utils;
        this.configCollector = configCollector;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Optional<DiscoveryConfigRoot> onConfigRoot(TypeElement configRoot) {
        void var9_14;
        String prefix = "quarkus";
        ConfigPhase configPhase = ConfigPhase.BUILD_TIME;
        AnnotationMirror configRootAnnotation = null;
        AnnotationMirror configMappingAnnotion = null;
        AnnotationMirror configDocPrefixAnnotation = null;
        AnnotationMirror configDocFileNameAnnotation = null;
        for (AnnotationMirror annotationMirror : configRoot.getAnnotationMirrors()) {
            String annotationName = this.utils.element().getQualifiedName(annotationMirror.getAnnotationType());
            if (annotationName.equals("io.quarkus.runtime.annotations.ConfigRoot")) {
                configRootAnnotation = annotationMirror;
                continue;
            }
            if (annotationName.equals("io.smallrye.config.ConfigMapping")) {
                configMappingAnnotion = annotationMirror;
                continue;
            }
            if (annotationName.equals("io.quarkus.runtime.annotations.ConfigDocPrefix")) {
                configDocPrefixAnnotation = annotationMirror;
                continue;
            }
            if (!annotationName.equals("io.quarkus.runtime.annotations.ConfigDocFilename")) continue;
            configDocFileNameAnnotation = annotationMirror;
        }
        if (configRootAnnotation == null || configMappingAnnotion == null) {
            throw new IllegalStateException("Either @ConfigRoot or @ConfigMapping is missing on " + String.valueOf(configRoot));
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = configRootAnnotation.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            if (!"phase()".equals(entry.getKey().toString())) continue;
            configPhase = ConfigPhase.valueOf(entry.getValue().getValue().toString());
        }
        this.validateRuntimeConfigOnDeploymentModules(configPhase, configRoot);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : configMappingAnnotion.getElementValues().entrySet()) {
            if (!"prefix()".equals(entry.getKey().toString())) continue;
            prefix = ((AnnotationValue)entry.getValue()).getValue().toString();
        }
        Object var9_12 = null;
        if (configDocPrefixAnnotation != null) {
            for (Map.Entry entry : configDocPrefixAnnotation.getElementValues().entrySet()) {
                if (!"value()".equals(((ExecutableElement)entry.getKey()).toString())) continue;
                String string = ((AnnotationValue)entry.getValue()).getValue().toString();
                break;
            }
        }
        String overriddenDocFileName = null;
        if (configDocFileNameAnnotation != null) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : configDocFileNameAnnotation.getElementValues().entrySet()) {
                if (!"value()".equals(entry.getKey().toString())) continue;
                overriddenDocFileName = entry.getValue().getValue().toString();
                break;
            }
        }
        String string = ConfigNamingUtil.getRootPrefix(prefix, "", configRoot.getSimpleName().toString(), configPhase);
        String string2 = this.utils.element().getBinaryName(configRoot);
        DiscoveryConfigRoot discoveryConfigRoot = new DiscoveryConfigRoot(this.config.getExtension(), string, (String)var9_14, string2, configRoot.getQualifiedName().toString(), configPhase, overriddenDocFileName, true);
        this.configCollector.addConfigRoot(discoveryConfigRoot);
        return Optional.of(discoveryConfigRoot);
    }

    @Override
    public void onEnclosedMethod(DiscoveryRootElement discoveryRootElement, TypeElement clazz, ExecutableElement method, ResolvedType resolvedType) {
        AnnotationMirror configDocDefaultAnnotation;
        Map<String, AnnotationMirror> methodAnnotations = this.utils.element().getAnnotations(method);
        String sourceElementName = method.getSimpleName().toString();
        DiscoveryConfigProperty.Builder builder = DiscoveryConfigProperty.builder(clazz.getQualifiedName().toString(), sourceElementName, SourceElementType.METHOD, resolvedType);
        String name = ConfigNamingUtil.hyphenate(sourceElementName);
        AnnotationMirror withNameAnnotation = methodAnnotations.get("io.smallrye.config.WithName");
        if (withNameAnnotation != null) {
            name = withNameAnnotation.getElementValues().values().iterator().next().getValue().toString();
        }
        if (methodAnnotations.containsKey("io.smallrye.config.WithParentName")) {
            name = "<<parent>>";
        }
        builder.name(name);
        AnnotationMirror withDefaultAnnotation = methodAnnotations.get("io.smallrye.config.WithDefault");
        if (withDefaultAnnotation != null) {
            builder.defaultValue(withDefaultAnnotation.getElementValues().values().isEmpty() ? null : withDefaultAnnotation.getElementValues().values().iterator().next().getValue().toString());
        }
        if ((configDocDefaultAnnotation = methodAnnotations.get("io.quarkus.runtime.annotations.ConfigDocDefault")) != null) {
            builder.defaultValueForDoc(configDocDefaultAnnotation.getElementValues().values().iterator().next().getValue().toString());
        }
        if (resolvedType.isMap()) {
            String mapKey = ConfigNamingUtil.hyphenate(sourceElementName);
            AnnotationMirror configDocMapKeyAnnotation = methodAnnotations.get("io.quarkus.runtime.annotations.ConfigDocMapKey");
            if (configDocMapKeyAnnotation != null) {
                mapKey = configDocMapKeyAnnotation.getElementValues().values().iterator().next().getValue().toString();
            }
            builder.mapKey(mapKey);
            AnnotationMirror unnamedMapKeyAnnotation = methodAnnotations.get("io.smallrye.config.WithUnnamedKey");
            if (unnamedMapKeyAnnotation != null) {
                builder.unnamedMapKey();
            }
        }
        if (methodAnnotations.containsKey("io.smallrye.config.WithConverter")) {
            builder.converted();
        }
        this.handleCommonPropertyAnnotations(builder, methodAnnotations, resolvedType, sourceElementName);
        discoveryRootElement.addProperty(builder.build());
    }

    @Override
    public Optional<DiscoveryConfigGroup> onConfigGroup(TypeElement configGroup) {
        DiscoveryConfigGroup discoveryConfigGroup = new DiscoveryConfigGroup(this.config.getExtension(), this.utils.element().getBinaryName(configGroup), configGroup.getQualifiedName().toString(), configGroup.getKind() == ElementKind.INTERFACE);
        this.configCollector.addResolvedConfigGroup(discoveryConfigGroup);
        return Optional.of(discoveryConfigGroup);
    }

    @Override
    public void onResolvedEnum(TypeElement enumTypeElement) {
        LinkedHashMap<String, EnumDefinition.EnumConstant> enumConstants = new LinkedHashMap<String, EnumDefinition.EnumConstant>();
        for (Element element : enumTypeElement.getEnclosedElements()) {
            if (element.getKind() != ElementKind.ENUM_CONSTANT) continue;
            String explicitValue = null;
            Map<String, AnnotationMirror> annotations = this.utils.element().getAnnotations(element);
            AnnotationMirror configDocEnumValue = annotations.get("io.quarkus.runtime.annotations.ConfigDocEnumValue");
            if (configDocEnumValue != null) {
                Map<String, Object> enumValueValues = this.utils.element().getAnnotationValues(configDocEnumValue);
                explicitValue = (String)enumValueValues.get("value");
            }
            enumConstants.put(element.getSimpleName().toString(), new EnumDefinition.EnumConstant(explicitValue));
        }
        EnumDefinition enumDefinition = new EnumDefinition(enumTypeElement.getQualifiedName().toString(), enumConstants);
        this.configCollector.addResolvedEnum(enumDefinition);
    }

    private void validateRuntimeConfigOnDeploymentModules(ConfigPhase configPhase, TypeElement configRoot) {
        ExtensionModule.ExtensionModuleType type;
        if ((configPhase.equals(ConfigPhase.RUN_TIME) || configPhase.equals(ConfigPhase.BUILD_AND_RUN_TIME_FIXED)) && (type = this.config.getExtensionModule().type()).equals((Object)ExtensionModule.ExtensionModuleType.DEPLOYMENT)) {
            throw new IllegalStateException(String.format("Error on %s: Configuration classes with ConfigPhase.RUN_TIME or ConfigPhase.BUILD_AND_RUNTIME_FIXED phases, must reside in the respective module.", configRoot.getSimpleName().toString()));
        }
    }

    private void handleCommonPropertyAnnotations(DiscoveryConfigProperty.Builder builder, Map<String, AnnotationMirror> propertyAnnotations, ResolvedType resolvedType, String sourceElementName) {
        Boolean enforceHyphenateValues;
        AnnotationMirror configDocEnum;
        AnnotationMirror configDocSectionAnnotation;
        AnnotationMirror deprecatedAnnotation = propertyAnnotations.get(Deprecated.class.getName());
        if (deprecatedAnnotation != null) {
            String since = (String)this.utils.element().getAnnotationValues(deprecatedAnnotation).get("since");
            builder.deprecated(since, null, null);
        }
        if ((configDocSectionAnnotation = propertyAnnotations.get("io.quarkus.runtime.annotations.ConfigDocSection")) != null) {
            Boolean sectionGenerated = (Boolean)this.utils.element().getAnnotationValues(configDocSectionAnnotation).get("generated");
            if (sectionGenerated != null && sectionGenerated.booleanValue()) {
                builder.section(true);
            } else {
                builder.section(false);
            }
        }
        if ((configDocEnum = propertyAnnotations.get("io.quarkus.runtime.annotations.ConfigDocEnum")) != null && (enforceHyphenateValues = (Boolean)this.utils.element().getAnnotationValues(configDocEnum).get("enforceHyphenateValues")) != null && enforceHyphenateValues.booleanValue()) {
            builder.enforceHyphenateEnumValues();
        }
    }
}

