/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.formatter;

import com.github.javaparser.StaticJavaParser;
import com.github.javaparser.javadoc.Javadoc;
import com.github.javaparser.javadoc.description.JavadocDescriptionElement;
import com.github.javaparser.javadoc.description.JavadocInlineTag;
import io.quarkus.annotation.processor.documentation.config.model.JavadocFormat;
import io.quarkus.annotation.processor.documentation.config.util.ConfigNamingUtil;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;

public final class JavadocToAsciidocTransformer {
    private static final Pattern START_OF_LINE = Pattern.compile("^", 8);
    private static final Pattern STARTING_SPACE = Pattern.compile("^ +");
    private static final String BACKTICK = "`";
    private static final String HASH = "#";
    private static final String STAR = "*";
    private static final String S_NODE = "s";
    private static final String UNDERSCORE = "_";
    private static final String NEW_LINE = "\n";
    private static final String LINK_NODE = "a";
    private static final String BOLD_NODE = "b";
    private static final String STRONG_NODE = "strong";
    private static final String BIG_NODE = "big";
    private static final String CODE_NODE = "code";
    private static final String DEL_NODE = "del";
    private static final String ITALICS_NODE = "i";
    private static final String EMPHASIS_NODE = "em";
    private static final String TEXT_NODE = "#text";
    private static final String UNDERLINE_NODE = "u";
    private static final String NEW_LINE_NODE = "br";
    private static final String PARAGRAPH_NODE = "p";
    private static final String SMALL_NODE = "small";
    private static final String LIST_ITEM_NODE = "li";
    private static final String HREF_ATTRIBUTE = "href";
    private static final String STRIKE_NODE = "strike";
    private static final String SUB_SCRIPT_NODE = "sub";
    private static final String ORDERED_LIST_NODE = "ol";
    private static final String SUPER_SCRIPT_NODE = "sup";
    private static final String UN_ORDERED_LIST_NODE = "ul";
    private static final String PREFORMATED_NODE = "pre";
    private static final String BLOCKQUOTE_NODE = "blockquote";
    private static final String TABLE_NODE = "table";
    private static final String THEAD_NODE = "thead";
    private static final String TBODY_NODE = "tbody";
    private static final String TR_NODE = "tr";
    private static final String TH_NODE = "th";
    private static final String TD_NODE = "td";
    private static final String BIG_ASCIDOC_STYLE = "[.big]";
    private static final String LINK_ATTRIBUTE_FORMAT = "[%s]";
    private static final String SUB_SCRIPT_ASCIDOC_STYLE = "~";
    private static final String SUPER_SCRIPT_ASCIDOC_STYLE = "^";
    private static final String SMALL_ASCIDOC_STYLE = "[.small]";
    private static final String ORDERED_LIST_ITEM_ASCIDOC_STYLE = " . ";
    private static final String UNORDERED_LIST_ITEM_ASCIDOC_STYLE = " - ";
    private static final String UNDERLINE_ASCIDOC_STYLE = "[.underline]";
    private static final String LINE_THROUGH_ASCIDOC_STYLE = "[.line-through]";
    private static final String HARD_LINE_BREAK_ASCIDOC_STYLE = " +\n";
    private static final String CODE_BLOCK_ASCIDOC_STYLE = "```";
    private static final String BLOCKQUOTE_BLOCK_ASCIDOC_STYLE = "[quote]\n____";
    private static final String BLOCKQUOTE_BLOCK_ASCIDOC_STYLE_END = "____";
    private static final String TABLE_MARKER = "!===";
    private static final String COLUMN_HEADER_MARKER = "h!";
    private static final String COLUMN_MARKER = "!";
    private static final Pattern INLINE_TAG_MARKER_PATTERN = Pattern.compile("\u00a7\u00a7([0-9]+)\u00a7\u00a7");

    private JavadocToAsciidocTransformer() {
    }

    public static String toAsciidoc(String javadoc, JavadocFormat format) {
        return JavadocToAsciidocTransformer.toAsciidoc(javadoc, format, false);
    }

    public static String toAsciidoc(String javadoc, JavadocFormat format, boolean inlineMacroMode) {
        if (javadoc == null || javadoc.isBlank()) {
            return null;
        }
        if (format == JavadocFormat.ASCIIDOC) {
            return javadoc;
        }
        if (format == JavadocFormat.MARKDOWN) {
            throw new IllegalArgumentException("Conversion from Markdown to Asciidoc is not supported");
        }
        Javadoc parsedJavadoc = StaticJavaParser.parseJavadoc((String)START_OF_LINE.matcher(javadoc).replaceAll("* "));
        StringBuilder htmlJavadoc = new StringBuilder(javadoc.length());
        int markerCounter = 0;
        StringBuilder sb = new StringBuilder();
        TreeMap<Integer, String> inlineTagsReplacements = new TreeMap<Integer, String>();
        for (JavadocDescriptionElement javadocDescriptionElement : parsedJavadoc.getDescription().getElements()) {
            if (javadocDescriptionElement instanceof JavadocInlineTag) {
                JavadocInlineTag inlineTag = (JavadocInlineTag)javadocDescriptionElement;
                String content = inlineTag.getContent().trim();
                switch (inlineTag.getType()) {
                    case CODE: 
                    case VALUE: 
                    case LITERAL: 
                    case SYSTEM_PROPERTY: {
                        sb.setLength(0);
                        sb.append('`');
                        JavadocToAsciidocTransformer.appendEscapedAsciiDoc(sb, content, inlineMacroMode, new Context());
                        sb.append('`');
                        htmlJavadoc.append("\u00a7\u00a7" + markerCounter + "\u00a7\u00a7");
                        inlineTagsReplacements.put(markerCounter, sb.toString());
                        ++markerCounter;
                        break;
                    }
                    case LINK: 
                    case LINKPLAIN: {
                        if (content.startsWith(HASH)) {
                            content = ConfigNamingUtil.hyphenate(content.substring(1));
                        }
                        sb.setLength(0);
                        sb.append('`');
                        JavadocToAsciidocTransformer.appendEscapedAsciiDoc(sb, content, inlineMacroMode, new Context());
                        sb.append('`');
                        htmlJavadoc.append("\u00a7\u00a7" + markerCounter + "\u00a7\u00a7");
                        inlineTagsReplacements.put(markerCounter, sb.toString());
                        ++markerCounter;
                        break;
                    }
                    default: {
                        htmlJavadoc.append(content);
                        break;
                    }
                }
                continue;
            }
            htmlJavadoc.append(javadocDescriptionElement.toText());
        }
        StringBuilder asciidocSb = new StringBuilder();
        JavadocToAsciidocTransformer.htmlToAsciidoc(asciidocSb, (Node)Jsoup.parseBodyFragment((String)htmlJavadoc.toString()), inlineMacroMode, new Context());
        String asciidoc = JavadocToAsciidocTransformer.trim(asciidocSb);
        if (!inlineTagsReplacements.isEmpty()) {
            asciidoc = INLINE_TAG_MARKER_PATTERN.matcher(asciidoc).replaceAll(mr -> Matcher.quoteReplacement((String)inlineTagsReplacements.get(Integer.valueOf(mr.group(1)))));
        }
        return asciidoc.isBlank() ? null : asciidoc;
    }

    private static void htmlToAsciidoc(StringBuilder sb, Node node, boolean inlineMacroMode, Context context) {
        block55: for (Node childNode : node.childNodes()) {
            switch (childNode.nodeName()) {
                case "p": {
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    break;
                }
                case "pre": {
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.newLine(sb);
                    sb.append(CODE_BLOCK_ASCIDOC_STYLE);
                    JavadocToAsciidocTransformer.newLine(sb);
                    for (Node grandChildNode : childNode.childNodes()) {
                        JavadocToAsciidocTransformer.unescapeHtmlEntities(sb, grandChildNode.toString());
                    }
                    JavadocToAsciidocTransformer.newLineIfNeeded(sb);
                    sb.append(CODE_BLOCK_ASCIDOC_STYLE);
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.newLine(sb);
                    break;
                }
                case "blockquote": {
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.newLine(sb);
                    sb.append(BLOCKQUOTE_BLOCK_ASCIDOC_STYLE);
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    JavadocToAsciidocTransformer.newLineIfNeeded(sb);
                    sb.append(BLOCKQUOTE_BLOCK_ASCIDOC_STYLE_END);
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.newLine(sb);
                    break;
                }
                case "ol": 
                case "ul": {
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.newLine(sb);
                    break;
                }
                case "li": {
                    String marker = childNode.parentNode().nodeName().equals(ORDERED_LIST_NODE) ? ORDERED_LIST_ITEM_ASCIDOC_STYLE : UNORDERED_LIST_ITEM_ASCIDOC_STYLE;
                    JavadocToAsciidocTransformer.newLine(sb);
                    sb.append(marker);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    break;
                }
                case "a": {
                    String link = childNode.attr(HREF_ATTRIBUTE);
                    sb.append("link:");
                    sb.append(link);
                    StringBuilder caption = new StringBuilder();
                    JavadocToAsciidocTransformer.htmlToAsciidoc(caption, childNode, inlineMacroMode, context);
                    sb.append(String.format(LINK_ATTRIBUTE_FORMAT, JavadocToAsciidocTransformer.trim(caption)));
                    break;
                }
                case "code": {
                    sb.append(BACKTICK);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    sb.append(BACKTICK);
                    break;
                }
                case "b": 
                case "strong": {
                    sb.append(STAR);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    sb.append(STAR);
                    break;
                }
                case "em": 
                case "i": {
                    sb.append(UNDERSCORE);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    sb.append(UNDERSCORE);
                    break;
                }
                case "u": {
                    sb.append(UNDERLINE_ASCIDOC_STYLE);
                    sb.append(HASH);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    sb.append(HASH);
                    break;
                }
                case "small": {
                    sb.append(SMALL_ASCIDOC_STYLE);
                    sb.append(HASH);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    sb.append(HASH);
                    break;
                }
                case "big": {
                    sb.append(BIG_ASCIDOC_STYLE);
                    sb.append(HASH);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    sb.append(HASH);
                    break;
                }
                case "sub": {
                    sb.append(SUB_SCRIPT_ASCIDOC_STYLE);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    sb.append(SUB_SCRIPT_ASCIDOC_STYLE);
                    break;
                }
                case "sup": {
                    sb.append(SUPER_SCRIPT_ASCIDOC_STYLE);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    sb.append(SUPER_SCRIPT_ASCIDOC_STYLE);
                    break;
                }
                case "del": 
                case "s": 
                case "strike": {
                    sb.append(LINE_THROUGH_ASCIDOC_STYLE);
                    sb.append(HASH);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    sb.append(HASH);
                    break;
                }
                case "br": {
                    sb.append(HARD_LINE_BREAK_ASCIDOC_STYLE);
                    break;
                }
                case "#text": {
                    String text = ((TextNode)childNode).text();
                    if (text.isEmpty()) break;
                    Matcher startingSpaceMatcher = STARTING_SPACE.matcher(text);
                    if (sb.length() > 0 && '\n' == sb.charAt(sb.length() - 1) && startingSpaceMatcher.find()) {
                        text = startingSpaceMatcher.replaceFirst("");
                    }
                    JavadocToAsciidocTransformer.appendEscapedAsciiDoc(sb, text, inlineMacroMode, context);
                    break;
                }
                case "table": {
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.newLine(sb);
                    sb.append(TABLE_MARKER);
                    JavadocToAsciidocTransformer.newLine(sb);
                    context.inTable = true;
                    context.firstTableRow = true;
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    context.inTable = false;
                    context.firstTableRow = false;
                    sb.append(TABLE_MARKER);
                    JavadocToAsciidocTransformer.newLine(sb);
                    break;
                }
                case "thead": {
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    break;
                }
                case "tbody": {
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    break;
                }
                case "tr": {
                    JavadocToAsciidocTransformer.trimTrailingWhitespaces(sb);
                    if (!context.firstTableRow) {
                        JavadocToAsciidocTransformer.newLine(sb);
                    }
                    JavadocToAsciidocTransformer.newLine(sb);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    context.firstTableRow = false;
                    break;
                }
                case "th": {
                    if (!context.firstTableRow) {
                        sb.append(COLUMN_HEADER_MARKER);
                    } else {
                        sb.append(COLUMN_MARKER);
                    }
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    JavadocToAsciidocTransformer.trimTrailingWhitespaces(sb);
                    if (context.firstTableRow) continue block55;
                    JavadocToAsciidocTransformer.newLine(sb);
                    break;
                }
                case "td": {
                    sb.append(COLUMN_MARKER);
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                    JavadocToAsciidocTransformer.trimTrailingWhitespaces(sb);
                    if (context.firstTableRow) continue block55;
                    JavadocToAsciidocTransformer.newLine(sb);
                    break;
                }
                default: {
                    JavadocToAsciidocTransformer.htmlToAsciidoc(sb, childNode, inlineMacroMode, context);
                }
            }
        }
    }

    static String trim(StringBuilder sb) {
        char ch;
        int length = sb.length();
        int offset = 0;
        while (offset < length) {
            ch = sb.charAt(offset);
            if (ch == ' ' && offset + 2 < length && sb.charAt(offset + 1) == '+' && sb.charAt(offset + 2) == '\n') {
                offset += 3;
                continue;
            }
            if (ch > ' ') break;
            ++offset;
        }
        if (offset > 0) {
            sb.delete(0, offset);
        }
        if (sb.length() > 0) {
            offset = sb.length() - 1;
            while (offset >= 0) {
                ch = sb.charAt(offset);
                if (ch == '\n' && offset - 2 >= 0 && sb.charAt(offset - 1) == '+' && sb.charAt(offset - 2) == ' ') {
                    offset -= 3;
                    continue;
                }
                if (ch > ' ') break;
                --offset;
            }
            if (offset < sb.length() - 1) {
                sb.setLength(offset + 1);
            }
        }
        return sb.toString();
    }

    private static StringBuilder newLineIfNeeded(StringBuilder sb) {
        JavadocToAsciidocTransformer.trimText(sb, " \t\r\n");
        return sb.append(NEW_LINE);
    }

    private static StringBuilder newLine(StringBuilder sb) {
        JavadocToAsciidocTransformer.trimText(sb, " \t");
        return sb.append(NEW_LINE);
    }

    private static StringBuilder trimText(StringBuilder sb, String charsToTrim) {
        while (sb.length() > 0 && charsToTrim.indexOf(sb.charAt(sb.length() - 1)) >= 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb;
    }

    private static void trimTrailingWhitespaces(StringBuilder sb) {
        int j = -1;
        int i = sb.length() - 1;
        while (i >= 0 && Character.isWhitespace(sb.charAt(i))) {
            j = i--;
        }
        if (j >= 0) {
            sb.setLength(j);
        }
    }

    private static StringBuilder unescapeHtmlEntities(StringBuilder sb, String text) {
        int i = 0;
        block21: while (i < text.length()) {
            switch (text.charAt(i++)) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block21;
                }
            }
            --i;
            break;
        }
        while (i < text.length()) {
            char ch = text.charAt(i);
            block4 : switch (ch) {
                case '&': {
                    String abbrev;
                    int start = ++i;
                    while (i < text.length() && text.charAt(i) != ';') {
                        ++i;
                    }
                    if (i <= start) break;
                    switch (abbrev = text.substring(start, i)) {
                        case "lt": {
                            sb.append('<');
                            break block4;
                        }
                        case "gt": {
                            sb.append('>');
                            break block4;
                        }
                        case "nbsp": {
                            sb.append("{nbsp}");
                            break block4;
                        }
                        case "amp": {
                            sb.append('&');
                            break block4;
                        }
                    }
                    try {
                        int code = Integer.parseInt(abbrev);
                        sb.append((char)code);
                        break;
                    }
                    catch (NumberFormatException e) {
                        throw new RuntimeException("Could not parse HTML entity &" + abbrev + "; in\n\n" + text + "\n\n");
                    }
                }
                case '\r': {
                    if (i + 1 < text.length() && text.charAt(i + 1) == '\n') break;
                    sb.append('\n');
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb;
    }

    private static StringBuilder appendEscapedAsciiDoc(StringBuilder sb, String text, boolean inlineMacroMode, Context context) {
        boolean escaping = false;
        block6: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case ']': {
                    if (inlineMacroMode) {
                        if (escaping) {
                            sb.append("++");
                            escaping = false;
                        }
                        sb.append("&#93;");
                        continue block6;
                    }
                }
                case '#': 
                case '*': 
                case '[': 
                case '\\': 
                case '{': 
                case '|': 
                case '}': {
                    if (!escaping) {
                        sb.append("++");
                        escaping = true;
                    }
                    sb.append(ch);
                    continue block6;
                }
                case '+': {
                    if (escaping) {
                        sb.append("++");
                        escaping = false;
                    }
                    sb.append("{plus}");
                    continue block6;
                }
                case '!': {
                    if (escaping) {
                        sb.append("++");
                        escaping = false;
                    }
                    if (context.inTable) {
                        sb.append('\\');
                    }
                    sb.append(ch);
                    continue block6;
                }
                default: {
                    if (escaping) {
                        sb.append("++");
                        escaping = false;
                    }
                    sb.append(ch);
                }
            }
        }
        if (escaping) {
            sb.append("++");
        }
        return sb;
    }

    private static class Context {
        boolean inTable;
        boolean firstTableRow;

        private Context() {
        }
    }
}

