/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.annotation.processor.documentation.config.scanner;

import io.quarkus.annotation.processor.documentation.config.discovery.ParsedJavadoc;
import io.quarkus.annotation.processor.documentation.config.formatter.JavadocToAsciidocTransformer;
import io.quarkus.annotation.processor.documentation.config.model.JavadocElements;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigAnnotationListener;
import io.quarkus.annotation.processor.documentation.config.scanner.ConfigCollector;
import io.quarkus.annotation.processor.util.Config;
import io.quarkus.annotation.processor.util.Utils;
import java.util.Optional;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;

public class AbstractJavadocConfigListener
implements ConfigAnnotationListener {
    protected final Config config;
    protected final Utils utils;
    protected final ConfigCollector configCollector;

    protected AbstractJavadocConfigListener(Config config, Utils utils, ConfigCollector configCollector) {
        this.config = config;
        this.utils = utils;
        this.configCollector = configCollector;
    }

    @Override
    public void onResolvedEnum(TypeElement enumTypeElement) {
        if (!this.utils.element().isLocalClass(enumTypeElement)) {
            return;
        }
        for (Element element : enumTypeElement.getEnclosedElements()) {
            Optional<String> rawJavadoc;
            if (element.getKind() != ElementKind.ENUM_CONSTANT || (rawJavadoc = this.utils.element().getJavadoc(element)).isEmpty()) continue;
            ParsedJavadoc parsedJavadoc = JavadocToAsciidocTransformer.INSTANCE.parseConfigItemJavadoc(rawJavadoc.get());
            this.configCollector.addJavadocElement(enumTypeElement.getQualifiedName().toString() + "." + element.getSimpleName().toString(), new JavadocElements.JavadocElement(parsedJavadoc.description(), parsedJavadoc.since(), rawJavadoc.get()));
        }
    }
}

