/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.maven;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.core.util.DefaultIndenter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.devtools.project.extensions.ScmInfoProvider;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.BootstrapWorkspaceProvider;
import io.quarkus.maven.capabilities.CapabilitiesConfig;
import io.quarkus.maven.capabilities.CapabilityConfig;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.GACTV;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Scm;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.impl.RemoteRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResult;

@Mojo(name="extension-descriptor", defaultPhase=LifecyclePhase.PROCESS_RESOURCES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, threadSafe=true)
public class ExtensionDescriptorMojo
extends AbstractMojo {
    private static final String GROUP_ID = "group-id";
    private static final String ARTIFACT_ID = "artifact-id";
    private static final String METADATA = "metadata";
    @Component
    RepositorySystem repoSystem;
    @Component
    RemoteRepositoryManager remoteRepoManager;
    @Component
    BootstrapWorkspaceProvider workspaceProvider;
    @Parameter(defaultValue="${session}", readonly=true)
    MavenSession session;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    RepositorySystemSession repoSession;
    @Parameter(defaultValue="${project.remoteProjectRepositories}", readonly=true, required=true)
    private List<RemoteRepository> repos;
    @Parameter(readonly=true, required=true, defaultValue="${project.build.outputDirectory}")
    private File outputDirectory;
    @Parameter(required=true, defaultValue="${project.groupId}:${project.artifactId}-deployment:${project.version}")
    private String deployment;
    @Parameter(required=false)
    CapabilitiesConfig capabilities = new CapabilitiesConfig();
    @Parameter(required=true, defaultValue="${project.build.outputDirectory}/META-INF/quarkus-extension.yaml")
    private File extensionFile;
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter
    List<String> excludedArtifacts;
    @Parameter
    List<RemovedResources> removedResources = List.of();
    @Parameter
    List<String> parentFirstArtifacts;
    @Parameter
    List<String> runnerParentFirstArtifacts;
    @Parameter
    List<String> lesserPriorityArtifacts;
    @Parameter(required=false, defaultValue="${skipExtensionValidation}")
    private boolean skipExtensionValidation;
    @Parameter(required=false, defaultValue="${ignoreNotDetectedQuarkusCoreVersion}")
    boolean ignoreNotDetectedQuarkusCoreVersion;
    @Parameter
    private List<String> conditionalDependencies = new ArrayList<String>(0);
    @Parameter
    private List<String> dependencyCondition = new ArrayList<String>(0);
    @Parameter(property="skipCodestartValidation")
    boolean skipCodestartValidation;
    @Parameter(defaultValue="${maven.compiler.release}", readonly=true)
    String minimumJavaVersion;
    ArtifactCoords deploymentCoords;
    CollectResult collectedDeploymentDeps;
    DependencyResult runtimeDeps;
    MavenArtifactResolver resolver;

    public void execute() throws MojoExecutionException {
        ObjectNode extObject;
        Object val;
        StringBuilder buf;
        if (!this.skipExtensionValidation) {
            this.validateExtensionDeps();
        }
        if (this.conditionalDependencies.isEmpty()) {
            StringBuilder buf2 = null;
            for (Dependency d : this.project.getDependencies()) {
                Properties props;
                if (!d.isOptional() || !d.getScope().isEmpty() && !d.getScope().equals("compile") && !d.getScope().equals("runtime") || (props = this.getExtensionDescriptor((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getType(), d.getVersion()), false)) == null || !props.containsKey("dependency-condition")) continue;
                if (buf2 == null) {
                    buf2 = new StringBuilder();
                } else {
                    buf2.setLength(0);
                }
                buf2.append(d.getGroupId()).append(':').append(d.getArtifactId()).append(':');
                if (d.getClassifier() != null) {
                    buf2.append(d.getClassifier());
                }
                buf2.append(':').append(d.getType()).append(':').append(d.getVersion());
                this.conditionalDependencies.add(buf2.toString());
            }
        }
        Properties props = new Properties();
        props.setProperty("deployment-artifact", this.deployment);
        if (!this.conditionalDependencies.isEmpty()) {
            buf = new StringBuilder();
            int i = 0;
            buf.append(ArtifactCoords.fromString((String)this.conditionalDependencies.get(i++)).toString());
            while (i < this.conditionalDependencies.size()) {
                buf.append(' ').append(ArtifactCoords.fromString((String)this.conditionalDependencies.get(i++)).toString());
            }
            props.setProperty("conditional-dependencies", buf.toString());
        }
        if (!this.dependencyCondition.isEmpty()) {
            buf = new StringBuilder();
            int i = 0;
            buf.append(ArtifactKey.fromString((String)this.dependencyCondition.get(i++)).toGacString());
            while (i < this.dependencyCondition.size()) {
                buf.append(' ').append(ArtifactKey.fromString((String)this.dependencyCondition.get(i++)).toGacString());
            }
            props.setProperty("dependency-condition", buf.toString());
        }
        if (!this.capabilities.getProvides().isEmpty()) {
            buf = new StringBuilder();
            Iterator<CapabilityConfig> i = this.capabilities.getProvides().iterator();
            ExtensionDescriptorMojo.appendCapability(i.next(), buf);
            while (i.hasNext()) {
                ExtensionDescriptorMojo.appendCapability(i.next(), buf.append(','));
            }
            props.setProperty("provides-capabilities", buf.toString());
        }
        if (!this.capabilities.getRequires().isEmpty()) {
            buf = new StringBuilder();
            Iterator<CapabilityConfig> i = this.capabilities.getRequires().iterator();
            ExtensionDescriptorMojo.appendCapability(i.next(), buf);
            while (i.hasNext()) {
                ExtensionDescriptorMojo.appendCapability(i.next(), buf.append(','));
            }
            props.setProperty("requires-capabilities", buf.toString());
        }
        if (this.parentFirstArtifacts != null && !this.parentFirstArtifacts.isEmpty()) {
            val = String.join((CharSequence)",", this.parentFirstArtifacts);
            props.put("parent-first-artifacts", val);
        }
        if (this.runnerParentFirstArtifacts != null && !this.runnerParentFirstArtifacts.isEmpty()) {
            val = String.join((CharSequence)",", this.runnerParentFirstArtifacts);
            props.put("runner-parent-first-artifacts", val);
        }
        if (this.excludedArtifacts != null && !this.excludedArtifacts.isEmpty()) {
            val = String.join((CharSequence)",", this.excludedArtifacts);
            props.put("excluded-artifacts", val);
        }
        if (!this.removedResources.isEmpty()) {
            for (RemovedResources entry : this.removedResources) {
                String value;
                String[] resources;
                ArtifactKey key;
                try {
                    key = ArtifactKey.fromString((String)entry.key);
                }
                catch (IllegalArgumentException e) {
                    throw new MojoExecutionException("Failed to parse removed resource '" + entry.key + "=" + entry.resources + "'", (Exception)e);
                }
                if (entry.resources == null || entry.resources.isBlank() || (resources = entry.resources.split(",")).length == 0) continue;
                if (resources.length == 1) {
                    value = resources[0];
                } else {
                    StringBuilder sb = new StringBuilder();
                    sb.append(resources[0]);
                    for (int i = 1; i < resources.length; ++i) {
                        String resource = resources[i];
                        if (resource.isBlank()) continue;
                        sb.append(',').append(resource);
                    }
                    value = sb.toString();
                }
                props.setProperty("removed-resources." + key.toString(), value);
            }
        }
        if (this.lesserPriorityArtifacts != null && !this.lesserPriorityArtifacts.isEmpty()) {
            val = String.join((CharSequence)",", this.lesserPriorityArtifacts);
            props.put("lesser-priority-artifacts", val);
        }
        Path output = this.outputDirectory.toPath().resolve("META-INF");
        try {
            Files.createDirectories(output, new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(output.resolve("quarkus-extension.properties"), new OpenOption[0]);){
                props.store(writer, "Generated by extension-descriptor");
            }
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist extension descriptor " + output.resolve("quarkus-extension.properties"), (Exception)e);
        }
        if (this.extensionFile == null) {
            this.extensionFile = output.resolve("quarkus-extension.yaml").toFile();
        }
        if (!this.extensionFile.exists()) {
            this.extensionFile = new File(this.extensionFile.getParent(), "quarkus-extension.json");
        }
        ObjectMapper mapper = null;
        if (this.extensionFile.exists()) {
            mapper = this.getMapper(this.extensionFile.toString().endsWith(".yaml"));
            extObject = this.readExtensionDescriptorFile(this.extensionFile.toPath(), mapper);
        } else {
            mapper = this.getMapper(true);
            extObject = this.getMapper(true).createObjectNode();
        }
        this.transformLegacyToNew(extObject, mapper);
        this.ensureArtifactCoords(extObject);
        if (extObject.get("name") == null) {
            if (this.project.getName() != null) {
                extObject.put("name", this.project.getName());
            } else {
                JsonNode node = extObject.get(ARTIFACT_ID);
                String defaultName = node.asText();
                int i = 0;
                if (defaultName.startsWith("quarkus-")) {
                    i = "quarkus-".length();
                }
                StringBuilder buf3 = new StringBuilder();
                boolean startWord = true;
                while (i < defaultName.length()) {
                    char c;
                    if ((c = defaultName.charAt(i++)) == '-') {
                        if (startWord) continue;
                        buf3.append(' ');
                        startWord = true;
                        continue;
                    }
                    if (startWord) {
                        buf3.append(Character.toUpperCase(c));
                        startWord = false;
                        continue;
                    }
                    buf3.append(c);
                }
                defaultName = buf3.toString();
                this.getLog().warn((CharSequence)("Extension name has not been provided for " + extObject.get(GROUP_ID).asText("") + ":" + extObject.get(ARTIFACT_ID).asText("") + "! Using '" + defaultName + "' as the default one."));
                extObject.put("name", defaultName);
            }
        }
        if (!extObject.has("description") && this.project.getDescription() != null) {
            extObject.put("description", this.project.getDescription());
        }
        this.setBuiltWithQuarkusCoreVersion(extObject);
        this.addJavaVersion(extObject);
        this.addCapabilities(extObject);
        this.addSource(extObject);
        this.addExtensionDependencies(extObject);
        this.completeCodestartArtifact(mapper, extObject);
        DefaultPrettyPrinter prettyPrinter = new DefaultPrettyPrinter();
        prettyPrinter.indentArraysWith((DefaultPrettyPrinter.Indenter)DefaultIndenter.SYSTEM_LINEFEED_INSTANCE);
        try (BufferedWriter bw = Files.newBufferedWriter(output.resolve("quarkus-extension.yaml"), new OpenOption[0]);){
            bw.write(this.getMapper(true).writer((PrettyPrinter)prettyPrinter).writeValueAsString((Object)extObject));
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to persist " + output.resolve("quarkus-extension.yaml"), (Exception)e);
        }
    }

    private void ensureArtifactCoords(ObjectNode extObject) {
        String groupId = null;
        String artifactId = null;
        String version = null;
        JsonNode artifactNode = extObject.get("artifact");
        if (artifactNode == null) {
            groupId = ExtensionDescriptorMojo.getRealValueOrNull(extObject.has("groupId") ? extObject.get("groupId").asText() : null, "${project.groupId");
            artifactId = ExtensionDescriptorMojo.getRealValueOrNull(extObject.has("artifactId") ? extObject.get("artifactId").asText() : null, "${project.artifactId");
            version = ExtensionDescriptorMojo.getRealValueOrNull(extObject.has("version") ? extObject.get("version").asText() : null, "${project.version");
        } else {
            String[] coordsArr = artifactNode.asText().split(":");
            if (coordsArr.length > 0) {
                groupId = ExtensionDescriptorMojo.getRealValueOrNull(coordsArr[0], "${project.groupId}");
                if (coordsArr.length > 1) {
                    artifactId = ExtensionDescriptorMojo.getRealValueOrNull(coordsArr[1], "${project.artifactId}");
                    if (coordsArr.length > 2) {
                        version = ExtensionDescriptorMojo.getRealValueOrNull(coordsArr[2], "${project.version}");
                    }
                }
            }
        }
        if (artifactNode == null || groupId == null || artifactId == null || version == null) {
            ArtifactCoords coords = ArtifactCoords.jar((String)(groupId == null ? this.project.getGroupId() : groupId), (String)(artifactId == null ? this.project.getArtifactId() : artifactId), version == null ? this.project.getVersion() : version);
            extObject.put("artifact", coords.toString());
        }
    }

    private static String getRealValueOrNull(String s, String propertyExpr) {
        return s != null && !s.isBlank() && !s.equals(propertyExpr) ? s : null;
    }

    private ObjectNode readExtensionDescriptorFile(Path extensionFile, ObjectMapper mapper) throws MojoExecutionException {
        ObjectNode objectNode;
        block8: {
            InputStream is = Files.newInputStream(extensionFile, new OpenOption[0]);
            try {
                objectNode = (ObjectNode)mapper.readValue(is, ObjectNode.class);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException io) {
                    throw new MojoExecutionException("Failed to parse " + extensionFile, (Exception)io);
                }
            }
            is.close();
        }
        return objectNode;
    }

    private void completeCodestartArtifact(ObjectMapper mapper, ObjectNode extObject) throws MojoExecutionException {
        JsonNode mvalue = ExtensionDescriptorMojo.getJsonElement(extObject, METADATA, "codestart");
        if (mvalue == null || !mvalue.isObject()) {
            return;
        }
        ObjectNode codestartObject = (ObjectNode)mvalue;
        if ((mvalue = mvalue.get("artifact")) == null) {
            if (!this.skipCodestartValidation) {
                throw new MojoExecutionException("Codestart artifact is missing from the " + this.extensionFile);
            }
            return;
        }
        String codestartArtifact = ExtensionDescriptorMojo.getCodestartArtifact(mvalue.asText(), this.project.getVersion());
        GACTV codestartArtifactCoords = GACTV.fromString((String)codestartArtifact);
        codestartObject.put("artifact", codestartArtifactCoords.toString());
        if (!this.skipCodestartValidation) {
            if (this.workspaceProvider.getProject(codestartArtifactCoords.getGroupId(), codestartArtifactCoords.getArtifactId()) != null) {
                return;
            }
            for (Artifact attached : this.project.getAttachedArtifacts()) {
                if (!codestartArtifactCoords.getArtifactId().equals(attached.getArtifactId()) || !codestartArtifactCoords.getClassifier().equals(attached.getClassifier()) || !codestartArtifactCoords.getType().equals(attached.getType()) || !codestartArtifactCoords.getVersion().equals(attached.getVersion()) || !codestartArtifactCoords.getGroupId().equals(attached.getGroupId())) continue;
                return;
            }
            try {
                this.resolve((org.eclipse.aether.artifact.Artifact)new DefaultArtifact(codestartArtifact));
            }
            catch (MojoExecutionException e) {
                throw new MojoExecutionException("Failed to resolve codestart artifact " + (ArtifactCoords)codestartArtifactCoords, (Exception)((Object)e));
            }
        }
    }

    static String getCodestartArtifact(String originalArtifact, String projectVersion) {
        if (originalArtifact.matches("^[^:]+:[^:]+$")) {
            return originalArtifact + ":" + projectVersion;
        }
        return originalArtifact.replace("${project.version}", projectVersion);
    }

    private static JsonNode getJsonElement(ObjectNode extObject, String ... elements) {
        JsonNode mvalue = extObject.get(elements[0]);
        int i = 1;
        while (i < elements.length) {
            if (mvalue == null || !mvalue.isObject()) {
                return null;
            }
            String element = elements[i++];
            extObject = (ObjectNode)mvalue;
            mvalue = extObject.get(element);
        }
        return mvalue;
    }

    private static void appendCapability(CapabilityConfig capability, StringBuilder buf) {
        buf.append(capability.getName());
        if (!capability.getOnlyIf().isEmpty()) {
            for (String onlyIf : capability.getOnlyIf()) {
                buf.append('?').append(onlyIf);
            }
        }
        if (!capability.getOnlyIfNot().isEmpty()) {
            for (String onlyIfNot : capability.getOnlyIfNot()) {
                buf.append("?!").append(onlyIfNot);
            }
        }
    }

    private void setBuiltWithQuarkusCoreVersion(ObjectNode extObject) throws MojoExecutionException {
        DependencyNode root;
        QuarkusCoreDeploymentVersionLocator coreVersionLocator = new QuarkusCoreDeploymentVersionLocator();
        try {
            root = this.repoSystem.collectDependencies(this.repoSession, this.newCollectRuntimeDepsRequest()).getRoot();
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to collect runtime dependencies of " + this.project.getArtifact(), e);
        }
        root.accept((DependencyVisitor)coreVersionLocator);
        if (coreVersionLocator.coreVersion != null) {
            ObjectNode metadata = ExtensionDescriptorMojo.getMetadataNode(extObject);
            metadata.put("built-with-quarkus-core", coreVersionLocator.coreVersion);
        } else if (!this.ignoreNotDetectedQuarkusCoreVersion) {
            throw new MojoExecutionException("Failed to determine the Quarkus core version used to build the extension");
        }
    }

    private void addExtensionDependencies(final ObjectNode extObject) throws MojoExecutionException {
        final AtomicReference extensionDeps = new AtomicReference();
        DependencyVisitor capabilityCollector = new DependencyVisitor(){

            public boolean visitEnter(DependencyNode node) {
                org.eclipse.aether.artifact.Artifact a = node.getArtifact();
                if (a != null && a.getFile() != null && a.getExtension().equals("jar")) {
                    Path p = a.getFile().toPath();
                    boolean isExtension = false;
                    if (Files.isDirectory(p, new LinkOption[0])) {
                        isExtension = ExtensionDescriptorMojo.this.getExtensionDescriptorOrNull(p) != null;
                    } else {
                        if (!Files.exists(p, new LinkOption[0])) {
                            Path workspaceJar = p.getParent().resolve(LocalWorkspace.getFileName((org.eclipse.aether.artifact.Artifact)a));
                            if (!Files.exists(workspaceJar, new LinkOption[0])) {
                                ExtensionDescriptorMojo.this.getLog().warn((CharSequence)("Failed to resolve " + a + ", " + p + " does not exist"));
                                return true;
                            }
                            p = workspaceJar;
                        }
                        try (FileSystem fs = ZipUtils.newFileSystem((Path)p);){
                            isExtension = ExtensionDescriptorMojo.this.getExtensionDescriptorOrNull(fs.getPath("", new String[0])) != null;
                        }
                        catch (IOException e) {
                            throw new RuntimeException("Failed to read " + p, e);
                        }
                    }
                    if (isExtension) {
                        ArrayNode deps = (ArrayNode)extensionDeps.get();
                        if (deps == null) {
                            deps = ExtensionDescriptorMojo.getMetadataNode(extObject).putArray("extension-dependencies");
                            extensionDeps.set(deps);
                        }
                        deps.add(ArtifactKey.of((String)a.getGroupId(), (String)a.getArtifactId(), (String)a.getClassifier(), (String)a.getExtension()).toGacString());
                    }
                }
                return true;
            }

            public boolean visitLeave(DependencyNode node) {
                return true;
            }
        };
        DependencyNode rootNode = this.resolveRuntimeDeps().getRoot();
        rootNode.accept(capabilityCollector);
    }

    private void addSource(ObjectNode extObject) throws MojoExecutionException {
        Scm scm = this.getScm();
        String scmUrl = scm != null ? scm.getUrl() : null;
        ScmInfoProvider scmInfoProvider = new ScmInfoProvider(scmUrl);
        Map repo = scmInfoProvider.getSourceRepo();
        ObjectNode metadata = ExtensionDescriptorMojo.getMetadataNode(extObject);
        if (repo != null) {
            for (Map.Entry e : repo.entrySet()) {
                String value = (String)e.getValue();
                String fieldName = "scm-" + (String)e.getKey();
                if (metadata.has(fieldName) || value == null) continue;
                metadata.put(fieldName, value);
            }
            String warning = scmInfoProvider.getInconsistencyWarning();
            if (warning != null) {
                this.getLog().warn((CharSequence)warning);
            }
        } else if (!metadata.has("scm-url")) {
            this.getLog().debug((CharSequence)"Could not work out a source control repository from the build environment or build file. Consider adding an scm-url entry in quarkus-extension.yaml");
        }
    }

    private Scm getScm() {
        Scm scm = null;
        Artifact artifact = this.project.getArtifact();
        LocalProject localProject = this.workspaceProvider.getProject(artifact.getGroupId(), artifact.getArtifactId());
        if (localProject == null) {
            Log log = this.getLog();
            log.debug((CharSequence)("Workspace provider could not resolve local project for " + artifact.getGroupId() + ":" + artifact.getArtifactId()));
        }
        while (scm == null && localProject != null) {
            scm = localProject.getRawModel().getScm();
            localProject = localProject.getLocalParent();
        }
        return scm;
    }

    public void addJavaVersion(ObjectNode extObject) {
        ObjectNode metadataNode = ExtensionDescriptorMojo.getMetadataNode(extObject);
        if (!metadataNode.has("minimum-java-version") && this.minimumJavaVersion != null) {
            metadataNode.put("minimum-java-version", this.minimumJavaVersion);
        }
    }

    private void addCapabilities(ObjectNode extObject) throws MojoExecutionException {
        ObjectNode capsNode = null;
        if (!this.capabilities.getProvides().isEmpty()) {
            capsNode = ExtensionDescriptorMojo.getMetadataNode(extObject).putObject("capabilities");
            ArrayNode provides = capsNode.putArray("provides");
            for (CapabilityConfig cap : this.capabilities.getProvides()) {
                provides.add(cap.getName());
            }
        }
        if (!this.capabilities.getRequires().isEmpty()) {
            if (capsNode == null) {
                capsNode = ExtensionDescriptorMojo.getMetadataNode(extObject).putObject("capabilities");
            }
            ArrayNode requires = capsNode.putArray("requires");
            for (CapabilityConfig cap : this.capabilities.getRequires()) {
                requires.add(cap.getName());
            }
        }
    }

    private static ObjectNode getMetadataNode(ObjectNode extObject) {
        JsonNode mvalue = extObject.get(METADATA);
        ObjectNode metadata = mvalue != null && mvalue.isObject() ? (ObjectNode)mvalue : extObject.putObject(METADATA);
        return metadata;
    }

    private void validateExtensionDeps() throws MojoExecutionException {
        ArtifactKey rootDeploymentGact = this.getDeploymentCoords().getKey();
        RootNode rootDeployment = new RootNode(rootDeploymentGact, 2);
        Artifact artifact = this.project.getArtifact();
        Node rootRuntime = rootDeployment.newChild(ArtifactKey.of((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getClassifier(), (String)artifact.getType()), 1);
        rootDeployment.expectedDeploymentNodes.put(rootDeployment.gact, rootDeployment);
        rootDeployment.expectedDeploymentNodes.put(rootRuntime.gact, rootRuntime);
        DependencyResult resolvedDeps = this.resolveRuntimeDeps();
        for (DependencyNode node : resolvedDeps.getRoot().getChildren()) {
            rootDeployment.directRuntimeDeps.add(ExtensionDescriptorMojo.toKey(node.getArtifact()));
        }
        this.visitRuntimeDeps(rootDeployment, rootDeployment, rootDeployment.id, resolvedDeps.getRoot());
        DependencyNode deploymentNode = this.collectDeploymentDeps().getRoot();
        this.visitDeploymentDeps(rootDeployment, deploymentNode);
        if (rootDeployment.hasErrors()) {
            Log log = this.getLog();
            log.error((CharSequence)"Quarkus Extension Dependency Verification Error");
            StringBuilder buf = new StringBuilder();
            if (rootDeployment.deploymentDepsTotal != 0) {
                log.error((CharSequence)("Deployment artifact " + this.getDeploymentCoords() + " was found to be missing dependencies on the Quarkus extension artifacts marked with '-' below:"));
                List<ArtifactKey> missing = rootDeployment.collectMissingDeploymentDeps(log);
                buf.append("Deployment artifact ");
                buf.append(this.getDeploymentCoords());
                buf.append(" is missing the following dependencies from its configuration: ");
                Iterator<ArtifactKey> i = missing.iterator();
                buf.append(i.next());
                while (i.hasNext()) {
                    buf.append(", ").append(i.next());
                }
            }
            if (!rootDeployment.deploymentsOnRtCp.isEmpty()) {
                if (rootDeployment.runtimeCp > 0) {
                    log.error((CharSequence)"The following deployment artifact(s) appear on the runtime classpath: ");
                    rootDeployment.collectDeploymentsOnRtCp(log);
                }
                if (buf.length() > 0) {
                    buf.append(System.lineSeparator());
                }
                buf.append("The following deployment artifact(s) appear on the runtime classpath: ");
                Iterator<ArtifactKey> i = rootDeployment.deploymentsOnRtCp.iterator();
                buf.append(i.next());
                while (i.hasNext()) {
                    buf.append(", ").append(i.next());
                }
            }
            if (!rootDeployment.unexpectedDeploymentDeps.isEmpty()) {
                ArrayList<ArtifactKey> unexpectedRtDeps = new ArrayList<ArtifactKey>(0);
                ArrayList<ArtifactKey> unexpectedDeploymentDeps = new ArrayList<ArtifactKey>(0);
                for (Map.Entry<ArtifactKey, org.eclipse.aether.artifact.Artifact> e : rootDeployment.unexpectedDeploymentDeps.entrySet()) {
                    if (rootDeployment.allDeploymentDeps.contains(e.getKey())) {
                        unexpectedDeploymentDeps.add(e.getKey());
                        continue;
                    }
                    unexpectedRtDeps.add(ExtensionDescriptorMojo.toKey(e.getValue()));
                }
                if (!unexpectedRtDeps.isEmpty()) {
                    if (buf.length() > 0) {
                        buf.append(System.lineSeparator());
                    }
                    buf.append("The deployment artifact " + rootDeploymentGact + " depends on the following Quarkus extension runtime artifacts that weren't found among the dependencies of " + this.project.getArtifact() + ":");
                    for (ArtifactKey a : unexpectedRtDeps) {
                        buf.append(' ').append(a);
                    }
                    log.error((CharSequence)("The deployment artifact " + rootDeploymentGact + " depends on the following Quarkus extension runtime artifacts that weren't found among the dependencies of " + this.project.getArtifact() + ":"));
                    this.highlightInTree(deploymentNode, unexpectedRtDeps);
                }
                if (!unexpectedDeploymentDeps.isEmpty()) {
                    if (buf.length() > 0) {
                        buf.append(System.lineSeparator());
                    }
                    buf.append("The deployment artifact " + rootDeploymentGact + " depends on the following Quarkus extension deployment artifacts whose corresponding runtime artifacts were not found among the dependencies of " + this.project.getArtifact() + ":");
                    for (ArtifactKey a : unexpectedDeploymentDeps) {
                        buf.append(' ').append(a);
                    }
                    log.error((CharSequence)("The deployment artifact " + rootDeploymentGact + " depends on the following Quarkus extension deployment artifacts whose corresponding runtime artifacts were not found among the dependencies of " + this.project.getArtifact() + ":"));
                    this.highlightInTree(deploymentNode, unexpectedDeploymentDeps);
                }
            }
            throw new MojoExecutionException(buf.toString());
        }
    }

    private DependencyResult resolveRuntimeDeps() throws MojoExecutionException {
        if (this.runtimeDeps == null) {
            try {
                this.runtimeDeps = this.repoSystem.resolveDependencies(this.repoSession, new DependencyRequest().setCollectRequest(this.newCollectRuntimeDepsRequest()));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to resolve dependencies of " + this.project.getArtifact(), e);
            }
        }
        return this.runtimeDeps;
    }

    private void highlightInTree(DependencyNode node, Collection<ArtifactKey> keys) {
        this.highlightInTree(0, node, keys, new HashSet<ArtifactKey>(), new StringBuilder(), new ArrayList<String>());
    }

    private void highlightInTree(int depth, DependencyNode node, Collection<ArtifactKey> keysToHighlight, Set<ArtifactKey> visited, StringBuilder buf, List<String> branch) {
        ArtifactKey key = ExtensionDescriptorMojo.toKey(node.getArtifact());
        if (!visited.add(key)) {
            return;
        }
        buf.setLength(0);
        boolean highlighted = keysToHighlight.contains(key);
        if (highlighted) {
            buf.append('*');
        } else {
            buf.append(' ');
        }
        for (int i = 0; i < depth; ++i) {
            buf.append("  ");
        }
        buf.append(node.getArtifact());
        branch.add(buf.toString());
        if (!highlighted) {
            for (DependencyNode child : node.getChildren()) {
                this.highlightInTree(depth + 1, child, keysToHighlight, visited, buf, branch);
            }
        } else {
            for (String line : branch) {
                this.getLog().error((CharSequence)line);
            }
        }
        branch.remove(branch.size() - 1);
    }

    private void visitDeploymentDeps(RootNode rootDeployment, DependencyNode dep) throws MojoExecutionException {
        for (DependencyNode child : dep.getChildren()) {
            this.visitDeploymentDep(rootDeployment, child);
        }
    }

    private void visitDeploymentDep(RootNode rootDeployment, DependencyNode dep) throws MojoExecutionException {
        ArtifactKey deployment;
        org.eclipse.aether.artifact.Artifact artifact = dep.getArtifact();
        if (artifact == null) {
            return;
        }
        ArtifactKey key = ExtensionDescriptorMojo.toKey(artifact);
        if (!rootDeployment.allDeploymentDeps.add(key)) {
            return;
        }
        Node node = rootDeployment.expectedDeploymentNodes.get(key);
        if (node != null) {
            if (!node.present) {
                node.present = true;
                --rootDeployment.deploymentDepsTotal;
                if (rootDeployment.allRtDeps.contains(key)) {
                    rootDeployment.deploymentsOnRtCp.add(key);
                }
            }
        } else if (!rootDeployment.allRtDeps.contains(key) && (deployment = this.getDeploymentKey(artifact)) != null) {
            rootDeployment.unexpectedDeploymentDeps.put(deployment, artifact);
        }
        this.visitDeploymentDeps(rootDeployment, dep);
    }

    private void visitRuntimeDep(RootNode root, Node currentNode, int currentId, DependencyNode node) throws MojoExecutionException {
        org.eclipse.aether.artifact.Artifact a = node.getArtifact();
        root.allRtDeps.add(ExtensionDescriptorMojo.toKey(a));
        ArtifactKey deployment = this.getDeploymentKey(a);
        if (deployment != null) {
            currentNode = currentNode.newChild(deployment, ++currentId);
            root.expectedDeploymentNodes.put(currentNode.gact, currentNode);
            ++root.deploymentDepsTotal;
            if (root.allRtDeps.contains(deployment)) {
                root.deploymentsOnRtCp.add(deployment);
                if (root.directRuntimeDeps.contains(deployment)) {
                    currentNode.runtimeCp = 2;
                    Node n = currentNode.parent;
                    while (n != null && n.runtimeCp == 0) {
                        n.runtimeCp = 1;
                        n = n.parent;
                    }
                }
            }
        }
        this.visitRuntimeDeps(root, currentNode, currentId, node);
    }

    private void visitRuntimeDeps(RootNode root, Node currentNode, int currentId, DependencyNode node) throws MojoExecutionException {
        for (DependencyNode child : node.getChildren()) {
            this.visitRuntimeDep(root, currentNode, currentId, child);
        }
    }

    private ArtifactKey getDeploymentKey(org.eclipse.aether.artifact.Artifact a) throws MojoExecutionException {
        org.eclipse.aether.artifact.Artifact deployment = this.getDeploymentArtifact(a);
        return deployment == null ? null : ExtensionDescriptorMojo.toKey(deployment);
    }

    private org.eclipse.aether.artifact.Artifact getDeploymentArtifact(org.eclipse.aether.artifact.Artifact a) throws MojoExecutionException {
        Properties props = this.getExtensionDescriptor(a, false);
        if (props == null) {
            return null;
        }
        String deploymentStr = props.getProperty("deployment-artifact");
        if (deploymentStr == null) {
            throw new IllegalStateException("Quarkus extension runtime artifact " + a + " is missing deployment-artifact property in its META-INF/quarkus-extension.properties");
        }
        return DependencyUtils.toArtifact((String)deploymentStr);
    }

    private Properties getExtensionDescriptor(org.eclipse.aether.artifact.Artifact a, boolean packaged) {
        Properties properties;
        block14: {
            File f;
            try {
                f = this.resolve(a);
            }
            catch (Exception e) {
                this.getLog().warn((CharSequence)("Failed to resolve " + a));
                return null;
            }
            if (!a.getExtension().equals("jar") || packaged && !this.isJarFile(f)) {
                return null;
            }
            if (f.isDirectory()) {
                return this.readExtensionDescriptorIfExists(f.toPath());
            }
            if (this.session.isParallel()) {
                Path classesDir;
                LocalProject localProject = this.workspaceProvider.getProject(a.getGroupId(), a.getArtifactId());
                Path path = classesDir = localProject == null ? null : localProject.getClassesDir();
                if (classesDir != null && Files.exists(classesDir, new LinkOption[0])) {
                    return this.readExtensionDescriptorIfExists(classesDir);
                }
            }
            FileSystem fs = ZipUtils.newFileSystem((Path)f.toPath());
            try {
                properties = this.readExtensionDescriptorIfExists(fs.getPath("", new String[0]));
                if (fs == null) break block14;
            }
            catch (Throwable throwable) {
                try {
                    if (fs != null) {
                        try {
                            fs.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    throw new IllegalStateException("Failed to read " + f, e);
                }
            }
            fs.close();
        }
        return properties;
    }

    private Properties readExtensionDescriptorIfExists(Path classesDir) throws IOException {
        Path p = this.getExtensionDescriptorOrNull(classesDir);
        return p == null ? null : this.readExtensionDescriptor(p);
    }

    private Path getExtensionDescriptorOrNull(Path runtimeExtRootDir) {
        Path p = runtimeExtRootDir.resolve("META-INF/quarkus-extension.properties");
        return Files.exists(p, new LinkOption[0]) ? p : null;
    }

    private Properties readExtensionDescriptor(Path extDescr) throws IOException {
        Properties props = new Properties();
        try (BufferedReader reader = Files.newBufferedReader(extDescr);){
            props.load(reader);
        }
        return props;
    }

    private static ArtifactKey toKey(org.eclipse.aether.artifact.Artifact a) {
        return DependencyUtils.getKey((org.eclipse.aether.artifact.Artifact)a);
    }

    private CollectResult collectDeploymentDeps() throws MojoExecutionException {
        if (this.collectedDeploymentDeps == null) {
            ArtifactCoords deploymentCoords = this.getDeploymentCoords();
            try {
                this.collectedDeploymentDeps = this.repoSystem.collectDependencies(this.repoSession, this.newCollectRequest(new DefaultArtifact(deploymentCoords.getGroupId(), deploymentCoords.getArtifactId(), deploymentCoords.getClassifier(), deploymentCoords.getType(), deploymentCoords.getVersion())));
            }
            catch (Exception e) {
                throw new MojoExecutionException("Failed to collect dependencies of deployment artifact " + deploymentCoords, e);
            }
        }
        return this.collectedDeploymentDeps;
    }

    private ArtifactCoords getDeploymentCoords() {
        return this.deploymentCoords == null ? (this.deploymentCoords = ArtifactCoords.fromString((String)this.deployment)) : this.deploymentCoords;
    }

    private CollectRequest newCollectRuntimeDepsRequest() throws MojoExecutionException {
        return this.newCollectRequest(new DefaultArtifact(this.project.getArtifact().getGroupId(), this.project.getArtifact().getArtifactId(), this.project.getArtifact().getClassifier(), this.project.getArtifact().getArtifactHandler().getExtension(), this.project.getArtifact().getVersion()));
    }

    private CollectRequest newCollectRequest(DefaultArtifact projectArtifact) throws MojoExecutionException {
        ArtifactDescriptorResult projectDescr;
        try {
            projectDescr = this.repoSystem.readArtifactDescriptor(this.repoSession, new ArtifactDescriptorRequest().setArtifact((org.eclipse.aether.artifact.Artifact)projectArtifact).setRepositories(this.repos));
        }
        catch (ArtifactDescriptorException e) {
            throw new MojoExecutionException("Failed to read descriptor of " + projectArtifact, (Exception)((Object)e));
        }
        CollectRequest request = new CollectRequest().setRootArtifact((org.eclipse.aether.artifact.Artifact)projectArtifact).setRepositories(this.repos).setManagedDependencies(projectDescr.getManagedDependencies());
        for (org.eclipse.aether.graph.Dependency dep : projectDescr.getDependencies()) {
            if ("test".equals(dep.getScope()) || "provided".equals(dep.getScope()) || dep.isOptional()) continue;
            request.addDependency(dep);
        }
        return request;
    }

    private boolean isJarFile(File f) {
        return f != null && f.getName().endsWith(".jar") && f.exists() && !f.isDirectory();
    }

    private void transformLegacyToNew(ObjectNode extObject, ObjectMapper mapper) {
        ObjectNode metadata = ExtensionDescriptorMojo.getMetadataNode(extObject);
        if (extObject.get("groupId") != null) {
            extObject.set(GROUP_ID, extObject.get("groupId"));
            extObject.remove("groupId");
        }
        if (extObject.get("artifactId") != null) {
            extObject.set(ARTIFACT_ID, extObject.get("artifactId"));
            extObject.remove("artifactId");
        }
        if (extObject.get("labels") != null) {
            metadata.set("keywords", extObject.get("labels"));
            extObject.remove("labels");
        }
        if (extObject.get("guide") != null) {
            metadata.set("guide", extObject.get("guide"));
            extObject.remove("guide");
        }
        if (extObject.get("shortName") != null) {
            metadata.set("short-name", extObject.get("shortName"));
            extObject.remove("shortName");
        }
        extObject.set(METADATA, (JsonNode)metadata);
    }

    private ObjectMapper getMapper(boolean yaml) {
        if (yaml) {
            YAMLFactory yf = new YAMLFactory();
            return new ObjectMapper((JsonFactory)yf).setPropertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE);
        }
        return ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().enable(new SerializationFeature[]{SerializationFeature.INDENT_OUTPUT})).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_JAVA_COMMENTS}).enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_LEADING_ZEROS_FOR_NUMBERS}).propertyNamingStrategy(PropertyNamingStrategies.KEBAB_CASE)).build();
    }

    private MavenArtifactResolver resolver() throws MojoExecutionException {
        if (this.resolver == null) {
            DefaultRepositorySystemSession session = new DefaultRepositorySystemSession(this.repoSession);
            session.setWorkspaceReader((WorkspaceReader)this.workspaceProvider.workspace());
            try {
                BootstrapMavenContext ctx = new BootstrapMavenContext(BootstrapMavenContext.config().setRepositorySystem(this.repoSystem).setRemoteRepositoryManager(this.remoteRepoManager).setRepositorySystemSession((RepositorySystemSession)session).setRemoteRepositories(this.repos).setPreferPomsFromWorkspace(true).setCurrentProject(this.workspaceProvider.origin()));
                this.resolver = new MavenArtifactResolver(ctx);
            }
            catch (BootstrapMavenException e) {
                throw new MojoExecutionException("Failed to initialize Maven artifact resolver", (Exception)((Object)e));
            }
        }
        return this.resolver;
    }

    private File resolve(org.eclipse.aether.artifact.Artifact a) throws MojoExecutionException {
        try {
            return this.resolver().resolve(a).getArtifact().getFile();
        }
        catch (MojoExecutionException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to resolve " + a, e);
        }
    }

    private static interface NodeHandler {
        public void handle(Log var1, int var2, Node var3, List<ArtifactKey> var4);
    }

    private static class Node {
        final Node parent;
        final ArtifactKey gact;
        final int id;
        boolean present;
        int runtimeCp;
        List<Node> children = new ArrayList<Node>(0);

        Node(Node parent, ArtifactKey gact, int id) {
            this.parent = parent;
            this.gact = gact;
            this.id = id;
        }

        Node newChild(ArtifactKey gact, int id) {
            Node child = new Node(this, gact, id);
            this.children.add(child);
            return child;
        }

        List<ArtifactKey> collectMissingDeploymentDeps(Log log) {
            ArrayList<ArtifactKey> missing = new ArrayList<ArtifactKey>();
            this.handleChildren(log, 0, missing, (log1, depth, n, collected) -> {
                StringBuilder buf = new StringBuilder();
                if (n.present) {
                    buf.append('+');
                } else {
                    buf.append('-');
                    collected.add(n.gact);
                }
                buf.append(' ');
                for (int i = 0; i < depth; ++i) {
                    buf.append("    ");
                }
                buf.append(n.gact);
                log1.error((CharSequence)buf.toString());
            });
            return missing;
        }

        List<ArtifactKey> collectDeploymentsOnRtCp(Log log) {
            ArrayList<ArtifactKey> missing = new ArrayList<ArtifactKey>();
            this.handleChildren(log, 0, missing, (log1, depth, n, collected) -> {
                if (n.runtimeCp == 0) {
                    return;
                }
                StringBuilder buf = new StringBuilder();
                if (n.runtimeCp == 1) {
                    buf.append(' ');
                } else {
                    buf.append('*');
                    collected.add(n.gact);
                }
                buf.append(' ');
                for (int i = 0; i < depth; ++i) {
                    buf.append("    ");
                }
                buf.append(n.gact);
                log1.error((CharSequence)buf.toString());
            });
            return missing;
        }

        private void handle(Log log, int depth, List<ArtifactKey> collected, NodeHandler handler) {
            handler.handle(log, depth, this, collected);
            this.handleChildren(log, depth, collected, handler);
        }

        private void handleChildren(Log log, int depth, List<ArtifactKey> collected, NodeHandler handler) {
            for (Node child : this.children) {
                child.handle(log, depth + 1, collected, handler);
            }
        }
    }

    private static class RootNode
    extends Node {
        final Map<ArtifactKey, Node> expectedDeploymentNodes = new HashMap<ArtifactKey, Node>();
        final Set<ArtifactKey> directRuntimeDeps = new HashSet<ArtifactKey>();
        final Set<ArtifactKey> allRtDeps = new HashSet<ArtifactKey>();
        final Set<ArtifactKey> allDeploymentDeps = new HashSet<ArtifactKey>();
        final Map<ArtifactKey, org.eclipse.aether.artifact.Artifact> unexpectedDeploymentDeps = new HashMap<ArtifactKey, org.eclipse.aether.artifact.Artifact>(0);
        int deploymentDepsTotal = 1;
        List<ArtifactKey> deploymentsOnRtCp = new ArrayList<ArtifactKey>(0);

        RootNode(ArtifactKey gact, int id) {
            super(null, gact, id);
        }

        boolean hasErrors() {
            return this.deploymentDepsTotal != 0 || this.runtimeCp != 0 || !this.unexpectedDeploymentDeps.isEmpty() || !this.deploymentsOnRtCp.isEmpty();
        }
    }

    private static final class QuarkusCoreDeploymentVersionLocator
    implements DependencyVisitor {
        String coreVersion;
        private boolean skipTheRest;

        private QuarkusCoreDeploymentVersionLocator() {
        }

        public boolean visitEnter(DependencyNode dep) {
            if (this.skipTheRest) {
                return false;
            }
            org.eclipse.aether.artifact.Artifact artifact = dep.getArtifact();
            if (artifact != null && artifact.getArtifactId().equals("quarkus-core")) {
                this.coreVersion = artifact.getVersion();
                if ("io.quarkus".equals(artifact.getGroupId())) {
                    this.skipTheRest = true;
                }
            }
            return !this.skipTheRest;
        }

        public boolean visitLeave(DependencyNode node) {
            return !this.skipTheRest;
        }
    }

    public static class RemovedResources {
        String key;
        String resources;
    }
}

