/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elytron.security.oauth2.runtime.auth;

import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.security.credential.TokenCredential;
import io.quarkus.security.identity.IdentityProviderManager;
import io.quarkus.security.identity.SecurityIdentity;
import io.quarkus.security.identity.request.AuthenticationRequest;
import io.quarkus.security.identity.request.TokenAuthenticationRequest;
import io.quarkus.vertx.http.runtime.security.ChallengeData;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticationMechanism;
import io.quarkus.vertx.http.runtime.security.HttpCredentialTransport;
import io.smallrye.mutiny.Uni;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.util.Collections;
import java.util.Set;
import org.jboss.logging.Logger;

@ApplicationScoped
public class OAuth2AuthMechanism
implements HttpAuthenticationMechanism {
    private static final Logger LOG = Logger.getLogger(OAuth2AuthMechanism.class);
    private static final String BEARER_PREFIX = "Bearer ";
    protected static final ChallengeData CHALLENGE_DATA = new ChallengeData(HttpResponseStatus.UNAUTHORIZED.code(), (CharSequence)HttpHeaderNames.WWW_AUTHENTICATE, "Bearer {token}");

    public Uni<SecurityIdentity> authenticate(RoutingContext context, IdentityProviderManager identityProviderManager) {
        String authHeader = context.request().headers().get("Authorization");
        if (authHeader == null || !authHeader.startsWith(BEARER_PREFIX)) {
            LOG.debug((Object)"Bearer access token is not available");
            return Uni.createFrom().nullItem();
        }
        String bearerToken = authHeader.substring(BEARER_PREFIX.length());
        return identityProviderManager.authenticate((AuthenticationRequest)new TokenAuthenticationRequest(new TokenCredential(bearerToken, "bearer")));
    }

    public Uni<ChallengeData> getChallenge(RoutingContext context) {
        return Uni.createFrom().item((Object)CHALLENGE_DATA);
    }

    public Set<Class<? extends AuthenticationRequest>> getCredentialTypes() {
        return Collections.singleton(TokenAuthenticationRequest.class);
    }

    public HttpCredentialTransport getCredentialTransport() {
        return new HttpCredentialTransport(HttpCredentialTransport.Type.AUTHORIZATION, "bearer");
    }
}

