/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elasticsearch.restclient.common.deployment;

import io.quarkus.builder.BuildException;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.GlobalDevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.elasticsearch.restclient.common.deployment.DevservicesElasticsearchBuildItem;
import io.quarkus.elasticsearch.restclient.common.deployment.ElasticsearchDevServicesBuildTimeConfig;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.opensearch.testcontainers.OpensearchContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.elasticsearch.ElasticsearchContainer;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIfNot={IsNormal.class}, onlyIf={GlobalDevServicesConfig.Enabled.class})
public class DevServicesElasticsearchProcessor {
    private static final Logger log = Logger.getLogger(DevServicesElasticsearchProcessor.class);
    static final String DEV_SERVICE_LABEL = "quarkus-dev-service-elasticsearch";
    static final int ELASTICSEARCH_PORT = 9200;
    private static final ContainerLocator elasticsearchContainerLocator = new ContainerLocator("quarkus-dev-service-elasticsearch", 9200);
    private static final ElasticsearchDevServicesBuildTimeConfig.Distribution DEFAULT_DISTRIBUTION = ElasticsearchDevServicesBuildTimeConfig.Distribution.ELASTIC;
    private static final String DEV_SERVICE_ELASTICSEARCH = "elasticsearch";
    private static final String DEV_SERVICE_OPENSEARCH = "opensearch";
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile ElasticsearchDevServicesBuildTimeConfig cfg;
    static volatile boolean first;

    @BuildStep
    public DevServicesResultBuildItem startElasticsearchDevService(DockerStatusBuildItem dockerStatusBuildItem, LaunchModeBuildItem launchMode, ElasticsearchDevServicesBuildTimeConfig configuration, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, GlobalDevServicesConfig devServicesConfig, List<DevservicesElasticsearchBuildItem> devservicesElasticsearchBuildItems) throws BuildException {
        if (devservicesElasticsearchBuildItems.isEmpty()) {
            return null;
        }
        DevservicesElasticsearchBuildItemsConfiguration buildItemsConfig = new DevservicesElasticsearchBuildItemsConfiguration(devservicesElasticsearchBuildItems);
        if (devService != null) {
            boolean shouldShutdownTheServer;
            boolean bl = shouldShutdownTheServer = !configuration.equals(cfg);
            if (!shouldShutdownTheServer) {
                return devService.toBuildItem();
            }
            this.shutdownElasticsearch();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Dev Services for Elasticsearch starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            devService = this.startElasticsearch(dockerStatusBuildItem, configuration, buildItemsConfig, launchMode, !devServicesSharedNetworkBuildItem.isEmpty(), devServicesConfig.timeout);
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.shutdownElasticsearch();
                }
                first = true;
                devService = null;
                cfg = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        if (devService.isOwner()) {
            log.infof("Dev Services for Elasticsearch started. Other Quarkus applications in dev mode will find the server automatically. For Quarkus applications in production mode, you can connect to this by configuring your application to use %s", (Object)DevServicesElasticsearchProcessor.getElasticsearchHosts(buildItemsConfig));
        }
        return devService.toBuildItem();
    }

    public static String getElasticsearchHosts(DevservicesElasticsearchBuildItemsConfiguration buildItemsConfiguration) {
        String hostsConfigProperty = (String)buildItemsConfiguration.hostsConfigProperties.stream().findAny().get();
        return (String)devService.getConfig().get(hostsConfigProperty);
    }

    private void shutdownElasticsearch() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Elasticsearch server", e);
            }
            finally {
                devService = null;
            }
        }
    }

    private DevServicesResultBuildItem.RunningDevService startElasticsearch(DockerStatusBuildItem dockerStatusBuildItem, ElasticsearchDevServicesBuildTimeConfig config, DevservicesElasticsearchBuildItemsConfiguration buildItemConfig, LaunchModeBuildItem launchMode, boolean useSharedNetwork, Optional<Duration> timeout) throws BuildException {
        String containerTag;
        if (!config.enabled.orElse(true).booleanValue()) {
            log.debug((Object)"Not starting Dev Services for Elasticsearch, as it has been disabled in the config.");
            return null;
        }
        for (String hostsConfigProperty : buildItemConfig.hostsConfigProperties) {
            if (!ConfigUtils.isPropertyPresent((String)hostsConfigProperty)) continue;
            log.debugf("Not starting Dev Services for Elasticsearch, the %s property is configured.", (Object)hostsConfigProperty);
            return null;
        }
        if (!dockerStatusBuildItem.isDockerAvailable()) {
            log.warnf("Docker isn't working, please configure the Elasticsearch hosts property (%s).", (Object)this.displayProperties(buildItemConfig.hostsConfigProperties));
            return null;
        }
        ElasticsearchDevServicesBuildTimeConfig.Distribution resolvedDistribution = this.resolveDistribution(config, buildItemConfig);
        DockerImageName resolvedImageName = this.resolveImageName(config, resolvedDistribution);
        if (buildItemConfig.version != null && !(containerTag = resolvedImageName.getVersionPart()).startsWith(buildItemConfig.version)) {
            throw new BuildException("Dev Services for Elasticsearch detected a version mismatch. Consuming extensions are configured to use version " + String.valueOf(config.imageName) + " but Dev Services are configured to use version " + buildItemConfig.version + ". Either configure the same version or disable Dev Services for Elasticsearch.", Collections.emptyList());
        }
        if (buildItemConfig.distribution != null && !buildItemConfig.distribution.equals((Object)resolvedDistribution)) {
            throw new BuildException("Dev Services for Elasticsearch detected a distribution mismatch. Consuming extensions are configured to use distribution " + String.valueOf(config.distribution) + " but Dev Services are configured to use distribution " + String.valueOf((Object)buildItemConfig.distribution) + ". Either configure the same distribution or disable Dev Services for Elasticsearch.", Collections.emptyList());
        }
        Optional maybeContainerAddress = elasticsearchContainerLocator.locateContainer(config.serviceName, config.shared, launchMode.getLaunchMode());
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultElasticsearchSupplier = () -> {
            GenericContainer<?> container;
            GenericContainer<?> genericContainer = container = resolvedDistribution.equals((Object)ElasticsearchDevServicesBuildTimeConfig.Distribution.ELASTIC) ? this.createElasticsearchContainer(config, resolvedImageName, useSharedNetwork) : this.createOpensearchContainer(config, resolvedImageName, useSharedNetwork);
            if (config.serviceName != null) {
                container.withLabel(DEV_SERVICE_LABEL, config.serviceName);
            }
            if (config.port.isPresent()) {
                container.setPortBindings(List.of(String.valueOf(config.port.get()) + ":9200"));
            }
            timeout.ifPresent(arg_0 -> container.withStartupTimeout(arg_0));
            container.withEnv(config.containerEnv);
            container.withReuse(config.reuse);
            container.start();
            return new DevServicesResultBuildItem.RunningDevService(Feature.ELASTICSEARCH_REST_CLIENT_COMMON.getName(), container.getContainerId(), (Closeable)new ContainerShutdownCloseable(container, "Elasticsearch"), this.buildPropertiesMap(buildItemConfig, container.getHost() + ":" + container.getMappedPort(9200)));
        };
        return maybeContainerAddress.map(containerAddress -> new DevServicesResultBuildItem.RunningDevService(Feature.ELASTICSEARCH_REST_CLIENT_COMMON.getName(), containerAddress.getId(), null, this.buildPropertiesMap(buildItemConfig, containerAddress.getUrl()))).orElseGet(defaultElasticsearchSupplier);
    }

    private GenericContainer<?> createElasticsearchContainer(ElasticsearchDevServicesBuildTimeConfig config, DockerImageName resolvedImageName, boolean useSharedNetwork) {
        ElasticsearchContainer container = new ElasticsearchContainer(resolvedImageName.asCompatibleSubstituteFor("docker.elastic.co/elasticsearch/elasticsearch"));
        if (useSharedNetwork) {
            ConfigureUtil.configureSharedNetwork((GenericContainer)container, (String)DEV_SERVICE_ELASTICSEARCH);
        }
        container.addEnv("xpack.security.enabled", "false");
        container.addEnv("cluster.routing.allocation.disk.threshold_enabled", "false");
        container.addEnv("ES_JAVA_OPTS", config.javaOpts);
        return container;
    }

    private GenericContainer<?> createOpensearchContainer(ElasticsearchDevServicesBuildTimeConfig config, DockerImageName resolvedImageName, boolean useSharedNetwork) {
        OpensearchContainer container = new OpensearchContainer(resolvedImageName.asCompatibleSubstituteFor("opensearchproject/opensearch"));
        if (useSharedNetwork) {
            ConfigureUtil.configureSharedNetwork((GenericContainer)container, (String)DEV_SERVICE_OPENSEARCH);
        }
        container.addEnv("bootstrap.memory_lock", "true");
        container.addEnv("plugins.index_state_management.enabled", "false");
        container.addEnv("cluster.routing.allocation.disk.threshold_enabled", "false");
        container.addEnv("OPENSEARCH_JAVA_OPTS", config.javaOpts);
        return container;
    }

    private DockerImageName resolveImageName(ElasticsearchDevServicesBuildTimeConfig config, ElasticsearchDevServicesBuildTimeConfig.Distribution resolvedDistribution) {
        return DockerImageName.parse((String)config.imageName.orElseGet(() -> ConfigureUtil.getDefaultImageNameFor((String)(ElasticsearchDevServicesBuildTimeConfig.Distribution.ELASTIC.equals((Object)resolvedDistribution) ? DEV_SERVICE_ELASTICSEARCH : DEV_SERVICE_OPENSEARCH))));
    }

    private ElasticsearchDevServicesBuildTimeConfig.Distribution resolveDistribution(ElasticsearchDevServicesBuildTimeConfig config, DevservicesElasticsearchBuildItemsConfiguration buildItemConfig) throws BuildException {
        if (config.distribution.isPresent()) {
            return config.distribution.get();
        }
        if (config.imageName.isPresent()) {
            String imageNameRepository = DockerImageName.parse((String)config.imageName.get()).getRepository().toLowerCase(Locale.ROOT);
            if (imageNameRepository.contains(DEV_SERVICE_OPENSEARCH)) {
                return ElasticsearchDevServicesBuildTimeConfig.Distribution.OPENSEARCH;
            }
            if (imageNameRepository.contains(DEV_SERVICE_ELASTICSEARCH)) {
                return ElasticsearchDevServicesBuildTimeConfig.Distribution.ELASTIC;
            }
            throw new BuildException("Wasn't able to determine the distribution of the search service based on the provided image name [" + config.imageName.get() + "]. Please specify the distribution explicitly.", Collections.emptyList());
        }
        if (buildItemConfig.distribution != null) {
            return buildItemConfig.distribution;
        }
        return DEFAULT_DISTRIBUTION;
    }

    private Map<String, String> buildPropertiesMap(DevservicesElasticsearchBuildItemsConfiguration buildItemConfig, String httpHosts) {
        HashMap<String, String> propertiesToSet = new HashMap<String, String>();
        for (String property : buildItemConfig.hostsConfigProperties) {
            propertiesToSet.put(property, httpHosts);
        }
        return propertiesToSet;
    }

    private String displayProperties(Set<String> hostsConfigProperties) {
        return String.join((CharSequence)" and ", hostsConfigProperties);
    }

    static {
        first = true;
    }

    private static class DevservicesElasticsearchBuildItemsConfiguration {
        private Set<String> hostsConfigProperties;
        private String version;
        private ElasticsearchDevServicesBuildTimeConfig.Distribution distribution;

        private DevservicesElasticsearchBuildItemsConfiguration(List<DevservicesElasticsearchBuildItem> buildItems) throws BuildException {
            this.hostsConfigProperties = new HashSet<String>(buildItems.size());
            for (DevservicesElasticsearchBuildItem buildItem : buildItems) {
                if (this.version == null) {
                    this.version = buildItem.getVersion();
                } else if (!this.version.equals(buildItem.getVersion())) {
                    throw new BuildException("Multiple extensions request different versions of Elasticsearch for Dev Services.", Collections.emptyList());
                }
                if (this.distribution == null) {
                    this.distribution = buildItem.getDistribution();
                } else if (!this.distribution.equals((Object)buildItem.getDistribution())) {
                    throw new BuildException("Multiple extensions request different distributions of Elasticsearch for Dev Services.", Collections.emptyList());
                }
                this.hostsConfigProperties.add(buildItem.getHostsConfigProperty());
            }
        }
    }
}

