/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.elasticsearch.restclient.common.deployment;

import io.quarkus.builder.BuildException;
import io.quarkus.deployment.Feature;
import io.quarkus.deployment.IsDevServicesSupportedByLaunchMode;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.DevServicesComposeProjectBuildItem;
import io.quarkus.deployment.builditem.DevServicesResultBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.builditem.DockerStatusBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.console.ConsoleInstalledBuildItem;
import io.quarkus.deployment.console.StartupLogCompressor;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.devservices.common.ComposeLocator;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.ContainerLocator;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.elasticsearch.restclient.common.deployment.DevservicesElasticsearchBuildItem;
import io.quarkus.elasticsearch.restclient.common.deployment.ElasticsearchCommonBuildTimeConfig;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.io.Closeable;
import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.opensearch.testcontainers.OpensearchContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.elasticsearch.ElasticsearchContainer;
import org.testcontainers.utility.DockerImageName;

@BuildSteps(onlyIf={IsDevServicesSupportedByLaunchMode.class, DevServicesConfig.Enabled.class})
public class DevServicesElasticsearchProcessor {
    private static final Logger log = Logger.getLogger(DevServicesElasticsearchProcessor.class);
    static final String DEV_SERVICE_LABEL = "quarkus-dev-service-elasticsearch";
    static final String NEW_DEV_SERVICE_LABEL = "io.quarkus.devservice.elasticsearch";
    static final int ELASTICSEARCH_PORT = 9200;
    private static final ContainerLocator elasticsearchContainerLocator = ContainerLocator.locateContainerWithLabels((int)9200, (String[])new String[]{"quarkus-dev-service-elasticsearch", "io.quarkus.devservice.elasticsearch"});
    private static final ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig.Distribution DEFAULT_DISTRIBUTION = ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig.Distribution.ELASTIC;
    private static final String DEV_SERVICE_ELASTICSEARCH = "elasticsearch";
    private static final String DEV_SERVICE_OPENSEARCH = "opensearch";
    static volatile DevServicesResultBuildItem.RunningDevService devService;
    static volatile ElasticsearchCommonBuildTimeConfig cfg;
    static volatile boolean first;

    @BuildStep
    public DevServicesResultBuildItem startElasticsearchDevService(DockerStatusBuildItem dockerStatusBuildItem, DevServicesComposeProjectBuildItem composeProjectBuildItem, LaunchModeBuildItem launchMode, ElasticsearchCommonBuildTimeConfig configuration, List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, Optional<ConsoleInstalledBuildItem> consoleInstalledBuildItem, CuratedApplicationShutdownBuildItem closeBuildItem, LoggingSetupBuildItem loggingSetupBuildItem, DevServicesConfig devServicesConfig, List<DevservicesElasticsearchBuildItem> devservicesElasticsearchBuildItems) throws BuildException {
        if (devservicesElasticsearchBuildItems.isEmpty()) {
            return null;
        }
        DevservicesElasticsearchBuildItemsConfiguration buildItemsConfig = new DevservicesElasticsearchBuildItemsConfiguration(devservicesElasticsearchBuildItems);
        if (devService != null) {
            boolean shouldShutdownTheServer;
            boolean bl = shouldShutdownTheServer = !configuration.equals(cfg);
            if (!shouldShutdownTheServer) {
                return devService.toBuildItem();
            }
            this.shutdownElasticsearch();
            cfg = null;
        }
        StartupLogCompressor compressor = new StartupLogCompressor((launchMode.isTest() ? "(test) " : "") + "Dev Services for Elasticsearch starting:", consoleInstalledBuildItem, loggingSetupBuildItem);
        try {
            boolean useSharedNetwork = DevServicesSharedNetworkBuildItem.isSharedNetworkRequired((DevServicesConfig)devServicesConfig, devServicesSharedNetworkBuildItem);
            devService = this.startElasticsearchDevServices(dockerStatusBuildItem, composeProjectBuildItem, configuration.devservices(), buildItemsConfig, launchMode, useSharedNetwork, devServicesConfig.timeout());
            if (devService == null) {
                compressor.closeAndDumpCaptured();
            } else {
                compressor.close();
            }
        }
        catch (Throwable t) {
            compressor.closeAndDumpCaptured();
            throw new RuntimeException(t);
        }
        if (devService == null) {
            return null;
        }
        if (first) {
            first = false;
            Runnable closeTask = () -> {
                if (devService != null) {
                    this.shutdownElasticsearch();
                }
                first = true;
                devService = null;
                cfg = null;
            };
            closeBuildItem.addCloseTask(closeTask, true);
        }
        cfg = configuration;
        if (devService.isOwner()) {
            log.infof("Dev Services for Elasticsearch started. Other Quarkus applications in dev mode will find the server automatically. For Quarkus applications in production mode, you can connect to this by configuring your application to use %s", (Object)DevServicesElasticsearchProcessor.getElasticsearchHosts(buildItemsConfig));
        }
        return devService.toBuildItem();
    }

    public static String getElasticsearchHosts(DevservicesElasticsearchBuildItemsConfiguration buildItemsConfiguration) {
        String hostsConfigProperty = (String)buildItemsConfiguration.hostsConfigProperties.stream().findAny().get();
        return (String)devService.getConfig().get(hostsConfigProperty);
    }

    private void shutdownElasticsearch() {
        if (devService != null) {
            try {
                devService.close();
            }
            catch (Throwable e) {
                log.error((Object)"Failed to stop the Elasticsearch server", e);
            }
            finally {
                devService = null;
            }
        }
    }

    private DevServicesResultBuildItem.RunningDevService startElasticsearchDevServices(DockerStatusBuildItem dockerStatusBuildItem, DevServicesComposeProjectBuildItem composeProjectBuildItem, ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig config, DevservicesElasticsearchBuildItemsConfiguration buildItemConfig, LaunchModeBuildItem launchMode, boolean useSharedNetwork, Optional<Duration> timeout) throws BuildException {
        if (!config.enabled().orElse(true).booleanValue()) {
            log.debug((Object)"Not starting Dev Services for Elasticsearch, as it has been disabled in the config.");
            return null;
        }
        for (String hostsConfigProperty : buildItemConfig.hostsConfigProperties) {
            if (!ConfigUtils.isPropertyNonEmpty((String)hostsConfigProperty)) continue;
            log.debugf("Not starting Dev Services for Elasticsearch, the %s property is configured.", (Object)hostsConfigProperty);
            return null;
        }
        if (!dockerStatusBuildItem.isContainerRuntimeAvailable()) {
            log.warnf("Docker isn't working, please configure the Elasticsearch hosts property (%s).", (Object)this.displayProperties(buildItemConfig.hostsConfigProperties));
            return null;
        }
        ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig.Distribution resolvedDistribution = this.resolveDistribution(config, buildItemConfig);
        DockerImageName resolvedImageName = this.resolveImageName(config, resolvedDistribution);
        Optional<ContainerAddress> maybeContainerAddress = elasticsearchContainerLocator.locateContainer(config.serviceName(), config.shared(), launchMode.getLaunchMode()).or(() -> ComposeLocator.locateContainer((DevServicesComposeProjectBuildItem)composeProjectBuildItem, List.of(resolvedImageName.getUnversionedPart(), DEV_SERVICE_ELASTICSEARCH, DEV_SERVICE_OPENSEARCH), (int)9200, (LaunchMode)launchMode.getLaunchMode(), (boolean)useSharedNetwork));
        Supplier<DevServicesResultBuildItem.RunningDevService> defaultElasticsearchSupplier = () -> {
            String defaultNetworkId = composeProjectBuildItem.getDefaultNetworkId();
            CreatedContainer createdContainer = resolvedDistribution.equals((Object)ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig.Distribution.ELASTIC) ? this.createElasticsearchContainer(config, resolvedImageName, defaultNetworkId, useSharedNetwork) : this.createOpensearchContainer(config, resolvedImageName, defaultNetworkId, useSharedNetwork);
            GenericContainer<?> container = createdContainer.genericContainer();
            if (config.serviceName() != null) {
                container.withLabel(DEV_SERVICE_LABEL, config.serviceName());
                container.withLabel("io.quarkus.devservice", config.serviceName());
            }
            if (config.port().isPresent()) {
                container.setPortBindings(List.of(String.valueOf(config.port().get()) + ":9200"));
            }
            timeout.ifPresent(arg_0 -> container.withStartupTimeout(arg_0));
            container.withEnv(config.containerEnv());
            container.withReuse(config.reuse());
            container.start();
            String httpHost = createdContainer.hostName + ":" + (useSharedNetwork ? 9200 : container.getMappedPort(9200));
            return new DevServicesResultBuildItem.RunningDevService(Feature.ELASTICSEARCH_REST_CLIENT_COMMON.getName(), container.getContainerId(), (Closeable)new ContainerShutdownCloseable(container, "Elasticsearch"), this.buildPropertiesMap(buildItemConfig, httpHost));
        };
        return maybeContainerAddress.map(containerAddress -> new DevServicesResultBuildItem.RunningDevService(Feature.ELASTICSEARCH_REST_CLIENT_COMMON.getName(), containerAddress.getId(), null, this.buildPropertiesMap(buildItemConfig, containerAddress.getUrl()))).orElseGet(defaultElasticsearchSupplier);
    }

    private CreatedContainer createElasticsearchContainer(ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig config, DockerImageName resolvedImageName, String defaultNetworkId, boolean useSharedNetwork) {
        ElasticsearchContainer container = new ElasticsearchContainer(resolvedImageName.asCompatibleSubstituteFor("docker.elastic.co/elasticsearch/elasticsearch"));
        String hostName = ConfigureUtil.configureNetwork((GenericContainer)container, (String)defaultNetworkId, (boolean)useSharedNetwork, (String)DEV_SERVICE_ELASTICSEARCH);
        container.addEnv("xpack.security.enabled", "false");
        container.addEnv("cluster.routing.allocation.disk.threshold_enabled", "false");
        container.addEnv("ES_JAVA_OPTS", config.javaOpts());
        return new CreatedContainer((GenericContainer<?>)container, hostName);
    }

    private CreatedContainer createOpensearchContainer(ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig config, DockerImageName resolvedImageName, String defaultNetworkId, boolean useSharedNetwork) {
        OpensearchContainer container = new OpensearchContainer(resolvedImageName.asCompatibleSubstituteFor("opensearchproject/opensearch"));
        String hostName = ConfigureUtil.configureNetwork((GenericContainer)container, (String)defaultNetworkId, (boolean)useSharedNetwork, (String)DEV_SERVICE_OPENSEARCH);
        container.addEnv("bootstrap.memory_lock", "true");
        container.addEnv("plugins.index_state_management.enabled", "false");
        container.addEnv("cluster.routing.allocation.disk.threshold_enabled", "false");
        container.addEnv("OPENSEARCH_JAVA_OPTS", config.javaOpts());
        container.addEnv("OPENSEARCH_INITIAL_ADMIN_PASSWORD", "NotActua11y$trongPa$$word");
        return new CreatedContainer((GenericContainer<?>)container, hostName);
    }

    private DockerImageName resolveImageName(ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig config, ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig.Distribution resolvedDistribution) {
        return DockerImageName.parse((String)config.imageName().orElseGet(() -> ConfigureUtil.getDefaultImageNameFor((String)(ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig.Distribution.ELASTIC.equals((Object)resolvedDistribution) ? DEV_SERVICE_ELASTICSEARCH : DEV_SERVICE_OPENSEARCH))));
    }

    private ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig.Distribution resolveDistribution(ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig config, DevservicesElasticsearchBuildItemsConfiguration buildItemConfig) throws BuildException {
        if (config.distribution().isPresent()) {
            return config.distribution().get();
        }
        if (config.imageName().isPresent()) {
            String imageNameRepository = DockerImageName.parse((String)config.imageName().get()).getRepository().toLowerCase(Locale.ROOT);
            if (imageNameRepository.contains(DEV_SERVICE_OPENSEARCH)) {
                return ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig.Distribution.OPENSEARCH;
            }
            if (imageNameRepository.contains(DEV_SERVICE_ELASTICSEARCH)) {
                return ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig.Distribution.ELASTIC;
            }
            throw new BuildException("Wasn't able to determine the distribution of the search service based on the provided image name [" + config.imageName().get() + "]. Please specify the distribution explicitly.", Collections.emptyList());
        }
        if (buildItemConfig.distribution != null) {
            return buildItemConfig.distribution;
        }
        return DEFAULT_DISTRIBUTION;
    }

    private Map<String, String> buildPropertiesMap(DevservicesElasticsearchBuildItemsConfiguration buildItemConfig, String httpHosts) {
        HashMap<String, String> propertiesToSet = new HashMap<String, String>();
        for (String property : buildItemConfig.hostsConfigProperties) {
            propertiesToSet.put(property, httpHosts);
        }
        return propertiesToSet;
    }

    private String displayProperties(Set<String> hostsConfigProperties) {
        return String.join((CharSequence)" and ", hostsConfigProperties);
    }

    static {
        first = true;
    }

    private static class DevservicesElasticsearchBuildItemsConfiguration {
        private Set<String> hostsConfigProperties;
        private String version;
        private ElasticsearchCommonBuildTimeConfig.ElasticsearchDevServicesBuildTimeConfig.Distribution distribution;

        private DevservicesElasticsearchBuildItemsConfiguration(List<DevservicesElasticsearchBuildItem> buildItems) throws BuildException {
            this.hostsConfigProperties = new HashSet<String>(buildItems.size());
            for (DevservicesElasticsearchBuildItem buildItem : buildItems) {
                if (this.version == null) {
                    this.version = buildItem.getVersion();
                } else if (buildItem.getVersion() != null && !this.version.equals(buildItem.getVersion())) {
                    throw new BuildException("Multiple extensions request different versions of Elasticsearch for Dev Services.", Collections.emptyList());
                }
                if (this.distribution == null) {
                    this.distribution = buildItem.getDistribution();
                } else if (buildItem.getDistribution() != null && !this.distribution.equals((Object)buildItem.getDistribution())) {
                    throw new BuildException("Multiple extensions request different distributions of Elasticsearch for Dev Services.", Collections.emptyList());
                }
                this.hostsConfigProperties.add(buildItem.getHostsConfigProperty());
            }
        }
    }

    private record CreatedContainer(GenericContainer<?> genericContainer, String hostName) {
    }
}

