/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.docs.generation;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.quarkus.docs.generation.ReferenceIndexGenerator;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class AssembleDownstreamDocumentation {
    private static final Logger LOG = Logger.getLogger(AssembleDownstreamDocumentation.class);
    private static final Path SOURCE_DOC_PATH = Path.of("src", "main", "asciidoc");
    private static final Path DOC_PATH = Path.of("target", "asciidoc", "sources");
    private static final Path INCLUDES_PATH = DOC_PATH.resolve("_includes");
    private static final Path GENERATED_DOC_FILES_PATH = Path.of("target", "quarkus-generated-doc");
    private static final Path IMAGES_PATH = DOC_PATH.resolve("images");
    private static final Path TARGET_ROOT_DIRECTORY = Path.of("target", "downstream-tree");
    private static final Path TARGET_IMAGES_DIRECTORY = TARGET_ROOT_DIRECTORY.resolve("images");
    private static final Path TARGET_INCLUDES_DIRECTORY = TARGET_ROOT_DIRECTORY.resolve("_includes");
    private static final Path TARGET_GENERATED_DIRECTORY = TARGET_ROOT_DIRECTORY.resolve("_generated");
    private static final Path TARGET_LISTING = Path.of("target", "downstream-files.txt");
    private static final Set<Path> EXCLUDED_FILES = Set.of(DOC_PATH.resolve("_attributes-local.adoc"));
    private static final String ADOC_SUFFIX = ".adoc";
    private static final Pattern XREF_GUIDE_PATTERN = Pattern.compile("xref:([^\\.#\\[ ]+)\\.adoc");
    private static final Pattern XREF_PATTERN = Pattern.compile("xref:([^\\[]+)\\[]");
    private static final Pattern ANGLE_BRACKETS_WITHOUT_DESCRIPTION_PATTERN = Pattern.compile("<<([a-z0-9_\\-#\\.]+?)>>", 2);
    private static final Pattern ANGLE_BRACKETS_WITH_DESCRIPTION_PATTERN = Pattern.compile("<<([a-z0-9_\\-#\\.]+?),([^>]+?)>>", 2);
    private static final Pattern ANCHOR_PATTERN = Pattern.compile("^\\[#([a-z0-9_-]+)]$", 10);
    private static final String SOURCE_BLOCK_PREFIX = "[source";
    private static final String SOURCE_BLOCK_DELIMITER = "--";
    private static final Pattern FOOTNOTE_PATTERN = Pattern.compile("footnote:([a-z0-9_-]+)\\[(\\])?");
    private static final Pattern TOOLTIP_PATTERN = Pattern.compile("tooltip:([a-z0-9_-]+)\\[(.*?)\\](, ?)?");
    private static final Pattern TOOLTIP_PATTERN_DEFAULT_COLUMN = Pattern.compile("^\\|tooltip:([a-z0-9_-]+)\\[(.*?)\\](, ?)?", 8);
    private static final String PROJECT_NAME_ATTRIBUTE = "{project-name}";
    private static final String RED_HAT_BUILD_OF_QUARKUS = "Red Hat build of Quarkus";
    private static final String QUARKUS_IO_GUIDES_ATTRIBUTE = "{quarkusio-guides}";
    private static final Map<Pattern, String> TABS_REPLACEMENTS = Map.of(Pattern.compile("((\\*) [^\n]+\n\\+)?\n\\[source,\\s?xml,\\s?role=\"primary asciidoc-tabs-target-sync-cli asciidoc-tabs-target-sync-maven\"\\]\n\\.pom.xml\n----\n((([^-]+\\-?)+\n)+?)----\n(\\+?)\n\\[source,\\s?gradle,\\s?role=\"secondary asciidoc-tabs-target-sync-gradle\"\\]\n\\.build.gradle\n----\n((([^-]+\\-?)+\n)+?)----", 10), "$1\n$2* Using Maven:\n+\n--\n[source,xml]\n----\n$3----\n--\n+\n$2* Using Gradle:\n+\n--\n[source,gradle]\n----\n$7----\n--", Pattern.compile("\\[source,\\s?bash,\\s?subs=attributes\\+,\\s?role=\"primary asciidoc-tabs-sync-cli\"\\]\n\\.CLI\n(----)\n((([^-]+\\-?\\-?)+\n)+?)(----)", 10), "* Using the Quarkus CLI:\n+\n--\n[source, bash, subs=attributes+]\n----\n$2----\n--", Pattern.compile("\\[source,\\s?bash,\\s?subs=attributes\\+,\\s?role=\"secondary asciidoc-tabs-sync-maven\"\\]\n\\.Maven\n(----)\n((([^-]+\\-?\\-?)+\n)+?)(----)", 10), "* Using Maven:\n+\n--\n[source, bash, subs=attributes+]\n----\n$2----\n--", Pattern.compile("\\[source,\\s?bash,\\s?subs=attributes\\+,\\s?role=\"secondary asciidoc-tabs-sync-gradle\"\\]\n\\.Gradle\n(----)\n((([^-]+\\-?\\-?)+\n)+?)(----)", 10), "* Using Gradle:\n+\n--\n[source, bash, subs=attributes+]\n----\n$2----\n--", Pattern.compile("\\[role=\"primary\\s?asciidoc-tabs-sync-cli\"\\]\n\\.CLI\n\\*\\*\\*\\*\n\\[source,\\s?bash,\\s?subs=attributes\\+\\]\n----\n((([^-]+\\-?\\-?)+\n)+?)----\n((([^*]+\\*?\\*?)+\n)+?)\\*\\*\\*\\*", 10), "* Using the Quarkus CLI:\n+\n--\n[source, bash, subs=attributes+]\n----\n$1----\n$4--", Pattern.compile("\\[role=\"secondary\\s?asciidoc-tabs-sync-maven\"\\]\n\\.Maven\n\\*\\*\\*\\*\n\\[source,\\s?bash,\\s?subs=attributes\\+\\]\n----\n((([^-]+\\-?\\-?)+\n)+?)----\n((([^*]+\\*?\\*?)+\n)+?)\\*\\*\\*\\*", 10), "* Using Maven:\n+\n--\n[source, bash, subs=attributes+]\n----\n$1----\n$4--");

    public static void main(String[] args) throws Exception {
        if (!Files.isDirectory(DOC_PATH, new LinkOption[0])) {
            throw new IllegalStateException("Transformed AsciiDoc sources directory does not exist. Have you built the documentation?");
        }
        if (!Files.isDirectory(GENERATED_DOC_FILES_PATH, new LinkOption[0])) {
            throw new IllegalStateException("Generated files directory `" + String.valueOf(GENERATED_DOC_FILES_PATH) + "` does not exist. Have you built the documentation?");
        }
        Path referenceIndexPath = Path.of(args[0], new String[0]);
        if (!Files.isReadable(Path.of(args[0], new String[0]))) {
            throw new IllegalStateException("Reference index does not exist? Have you built the documentation?");
        }
        ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES));
        ReferenceIndexGenerator.Index referenceIndex = (ReferenceIndexGenerator.Index)om.readValue(referenceIndexPath.toFile(), ReferenceIndexGenerator.Index.class);
        LinkedHashMap<String, List<String>> linkRewritingErrors = new LinkedHashMap<String, List<String>>();
        Map<String, String> titlesByReference = referenceIndex.getReferences().stream().collect(Collectors.toMap(s -> s.getReference(), s -> s.getTitle()));
        try {
            Path targetFile;
            Path sourceFile;
            String excludes;
            AssembleDownstreamDocumentation.deleteDirectory(TARGET_ROOT_DIRECTORY);
            Files.deleteIfExists(TARGET_LISTING);
            ObjectMapper yamlObjectMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
            yamlObjectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
            String configFilePath = System.getenv("DOWNSTREAM_CONFIG_FILE");
            if (configFilePath == null) {
                configFilePath = "downstreamdoc.yaml";
            }
            ConfigFile configFile = (ConfigFile)yamlObjectMapper.readValue(new File(configFilePath), ConfigFile.class);
            String additionals = System.getenv("DOWNSTREAM_ADDITIONALS");
            if (additionals != null) {
                Object[] additional_files = additionals.split(",");
                LOG.info((Object)("Additional files: " + Arrays.toString(additional_files)));
                for (Object file : additional_files) {
                    configFile.guides.add((String)file);
                }
            }
            if ((excludes = System.getenv("DOWNSTREAM_EXCLUDES")) != null) {
                Object[] excludePatterns = excludes.split(",");
                LOG.info((Object)("Excluding patterns: " + Arrays.toString(excludePatterns)));
                for (Object pattern : excludePatterns) {
                    Pattern regexPattern = Pattern.compile((String)pattern);
                    configFile.guides.removeIf(guide -> regexPattern.matcher((CharSequence)guide).find());
                }
            }
            TreeSet<Path> guides = new TreeSet<Path>();
            TreeSet<Path> simpleIncludes = new TreeSet<Path>();
            TreeSet<Path> includes = new TreeSet<Path>();
            TreeSet<Path> generatedDocFiles = new TreeSet<Path>();
            TreeSet<Path> images = new TreeSet<Path>();
            TreeSet<Path> allResolvedPaths = new TreeSet<Path>();
            TreeSet<String> downstreamGuides = new TreeSet<String>();
            for (String string : new TreeSet<String>(configFile.guides)) {
                Path guidePath = DOC_PATH.resolve(SOURCE_DOC_PATH.relativize(Path.of(string, new String[0])));
                if (!Files.isReadable(guidePath)) {
                    LOG.error((Object)("Unable to read file " + String.valueOf(guidePath)));
                    continue;
                }
                downstreamGuides.add(guidePath.getFileName().toString());
                allResolvedPaths.add(guidePath);
                GuideContent guideContent = new GuideContent(guidePath);
                AssembleDownstreamDocumentation.getFiles(guideContent, guidePath);
                guides.add(guidePath);
                simpleIncludes.addAll(guideContent.simpleIncludes);
                includes.addAll(guideContent.includes);
                generatedDocFiles.addAll(guideContent.generatedDocFiles);
                images.addAll(guideContent.images);
            }
            Files.createDirectories(TARGET_ROOT_DIRECTORY, new FileAttribute[0]);
            for (Path path : guides) {
                System.out.println("[INFO] Processing guide " + String.valueOf(path.getFileName()));
                AssembleDownstreamDocumentation.copyAsciidoc(path, TARGET_ROOT_DIRECTORY.resolve(path.getFileName()), downstreamGuides, titlesByReference, linkRewritingErrors);
            }
            for (Path path : simpleIncludes) {
                sourceFile = DOC_PATH.resolve(path);
                if (EXCLUDED_FILES.contains(sourceFile)) continue;
                if (!Files.isReadable(sourceFile)) {
                    LOG.error((Object)("Unable to read include " + String.valueOf(sourceFile)));
                }
                allResolvedPaths.add(sourceFile);
                targetFile = TARGET_ROOT_DIRECTORY.resolve(path);
                Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                AssembleDownstreamDocumentation.copyAsciidoc(sourceFile, targetFile, downstreamGuides, titlesByReference, linkRewritingErrors);
            }
            for (Path path : includes) {
                sourceFile = INCLUDES_PATH.resolve(path);
                if (EXCLUDED_FILES.contains(sourceFile)) continue;
                if (!Files.isReadable(sourceFile)) {
                    LOG.error((Object)("Unable to read include " + String.valueOf(sourceFile)));
                }
                allResolvedPaths.add(sourceFile);
                targetFile = TARGET_INCLUDES_DIRECTORY.resolve(path);
                Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                AssembleDownstreamDocumentation.copyAsciidoc(sourceFile, targetFile, downstreamGuides, titlesByReference, linkRewritingErrors);
            }
            AssembleDownstreamDocumentation.copyGeneratedFiles(linkRewritingErrors, titlesByReference, allResolvedPaths, downstreamGuides, GENERATED_DOC_FILES_PATH, generatedDocFiles);
            for (Path path : images) {
                sourceFile = IMAGES_PATH.resolve(path);
                if (EXCLUDED_FILES.contains(sourceFile)) continue;
                if (!Files.isReadable(sourceFile)) {
                    LOG.error((Object)("Unable to read image " + String.valueOf(sourceFile)));
                }
                allResolvedPaths.add(sourceFile);
                targetFile = TARGET_IMAGES_DIRECTORY.resolve(path);
                Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
                Files.copy(sourceFile, targetFile, StandardCopyOption.REPLACE_EXISTING);
            }
            Files.writeString(TARGET_LISTING, (CharSequence)allResolvedPaths.stream().map(p -> p.toString()).collect(Collectors.joining("\n")), new OpenOption[0]);
            if (!linkRewritingErrors.isEmpty()) {
                System.out.println();
                System.out.println("################################################");
                System.out.println("# Errors occurred while transforming references");
                System.out.println("################################################");
                System.out.println();
                for (Map.Entry entry : linkRewritingErrors.entrySet()) {
                    System.out.println("- " + (String)entry.getKey());
                    for (String error : (List)entry.getValue()) {
                        System.out.println("    . " + error);
                    }
                }
                System.out.println();
                System.exit(1);
            }
            LOG.info((Object)("Downstream documentation tree is available in: " + String.valueOf(TARGET_ROOT_DIRECTORY)));
            LOG.info((Object)("Downstream documentation listing is available in: " + String.valueOf(TARGET_LISTING)));
        }
        catch (IOException e) {
            throw new UncheckedIOException("An error occurred while generating the downstream tree", e);
        }
    }

    private static void copyGeneratedFiles(Map<String, List<String>> linkRewritingErrors, Map<String, String> titlesByReference, Set<Path> allResolvedPaths, Set<String> downstreamGuides, Path generatedSourceFilesDirectory, Set<Path> generatedFiles) throws IOException {
        for (Path generatedConfigDocFile : generatedFiles) {
            Path sourceFile = generatedSourceFilesDirectory.resolve(generatedConfigDocFile);
            if (EXCLUDED_FILES.contains(sourceFile)) continue;
            if (!Files.isReadable(sourceFile)) {
                LOG.error((Object)("Unable to read generated file " + String.valueOf(sourceFile)));
            }
            allResolvedPaths.add(sourceFile);
            Path targetFile = TARGET_GENERATED_DIRECTORY.resolve(generatedConfigDocFile);
            Files.createDirectories(targetFile.getParent(), new FileAttribute[0]);
            AssembleDownstreamDocumentation.copyAsciidoc(sourceFile, targetFile, downstreamGuides, titlesByReference, linkRewritingErrors);
        }
    }

    private static void getFiles(GuideContent guideContent, Path currentFile) throws IOException {
        List<String> lines = Files.readAllLines(currentFile);
        for (String line : lines) {
            Optional<Path> possibleInclude = AssembleDownstreamDocumentation.extractPath(line, "include::{includes}");
            if (possibleInclude.isPresent()) {
                guideContent.includes.add(possibleInclude.get());
                AssembleDownstreamDocumentation.getFurtherIncludes(guideContent, INCLUDES_PATH.resolve(possibleInclude.get()));
                continue;
            }
            Optional<Path> possibleGeneratedConfigDocFile = AssembleDownstreamDocumentation.extractPath(line, "include::{generated-dir}");
            if (possibleGeneratedConfigDocFile.isPresent()) {
                guideContent.generatedDocFiles.add(possibleGeneratedConfigDocFile.get());
                continue;
            }
            Optional<Path> possibleSimpleInclude = AssembleDownstreamDocumentation.extractPath(line, "include::");
            if (possibleSimpleInclude.isPresent()) {
                guideContent.simpleIncludes.add(possibleSimpleInclude.get());
                AssembleDownstreamDocumentation.getFiles(guideContent, currentFile.getParent().resolve(possibleSimpleInclude.get()));
                continue;
            }
            Optional<Path> possibleImage = AssembleDownstreamDocumentation.extractPath(line, "image::");
            if (!possibleImage.isPresent()) continue;
            guideContent.images.add(possibleImage.get());
        }
    }

    private static void getFurtherIncludes(GuideContent guideContent, Path currentFile) throws IOException {
        List<String> lines = Files.readAllLines(currentFile);
        for (String line : lines) {
            Optional<Path> possibleInclude = AssembleDownstreamDocumentation.extractPath(line, "include::");
            if (possibleInclude.isPresent()) {
                guideContent.includes.add(possibleInclude.get());
                AssembleDownstreamDocumentation.getFurtherIncludes(guideContent, currentFile.getParent().resolve(possibleInclude.get()));
                continue;
            }
            Optional<Path> possibleImage = AssembleDownstreamDocumentation.extractPath(line, "image::");
            if (!possibleImage.isPresent()) continue;
            guideContent.images.add(possibleImage.get());
        }
    }

    private static Optional<Path> extractPath(String asciidoc, String prefix) {
        if (!asciidoc.startsWith(prefix)) {
            return Optional.empty();
        }
        String path = asciidoc.substring(prefix.length(), asciidoc.indexOf(91));
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        return Optional.of(Path.of(path, new String[0]));
    }

    private static void deleteDirectory(Path directory) throws IOException {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            return;
        }
        Files.walk(directory, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }

    private static void copyAsciidoc(Path sourceFile, Path targetFile, Set<String> downstreamGuides, Map<String, String> titlesByReference, Map<String, List<String>> linkRewritingErrors) throws IOException {
        List<String> guideLines = Files.readAllLines(sourceFile);
        StringBuilder rewrittenGuide = new StringBuilder();
        StringBuilder currentBuffer = new StringBuilder();
        boolean inSourceBlock = false;
        boolean findDelimiter = false;
        String currentSourceBlockDelimiter = "----";
        int lineNumber = 0;
        boolean documentTitleFound = false;
        for (String line : guideLines) {
            ++lineNumber;
            if (!documentTitleFound && line.startsWith("= ")) {
                if (currentBuffer.length() > 0) {
                    rewrittenGuide.append((CharSequence)currentBuffer);
                    currentBuffer.setLength(0);
                }
                rewrittenGuide.append(line.replace(PROJECT_NAME_ATTRIBUTE, RED_HAT_BUILD_OF_QUARKUS) + "\n");
                documentTitleFound = true;
                continue;
            }
            if (inSourceBlock) {
                if (findDelimiter) {
                    rewrittenGuide.append(line + "\n");
                    if (line.isBlank() || line.startsWith(".")) continue;
                    if (!line.startsWith(SOURCE_BLOCK_DELIMITER)) {
                        throw new IllegalStateException("Unable to find source block delimiter in file " + String.valueOf(sourceFile) + " at line " + lineNumber);
                    }
                    currentSourceBlockDelimiter = line.stripTrailing();
                    findDelimiter = false;
                    continue;
                }
                if (line.stripTrailing().equals(currentSourceBlockDelimiter)) {
                    inSourceBlock = false;
                }
                rewrittenGuide.append(line + "\n");
                continue;
            }
            if (line.startsWith(SOURCE_BLOCK_PREFIX)) {
                inSourceBlock = true;
                findDelimiter = true;
                if (currentBuffer.length() > 0) {
                    rewrittenGuide.append(AssembleDownstreamDocumentation.rewriteContent(sourceFile.getFileName().toString(), currentBuffer.toString(), downstreamGuides, titlesByReference, linkRewritingErrors));
                    currentBuffer.setLength(0);
                }
                rewrittenGuide.append(line + "\n");
                continue;
            }
            currentBuffer.append(line + "\n");
        }
        if (currentBuffer.length() > 0) {
            rewrittenGuide.append(AssembleDownstreamDocumentation.rewriteContent(sourceFile.getFileName().toString(), currentBuffer.toString(), downstreamGuides, titlesByReference, linkRewritingErrors));
        }
        String rewrittenGuideWithoutTabs = rewrittenGuide.toString().trim();
        for (Map.Entry<Pattern, String> tabReplacement : TABS_REPLACEMENTS.entrySet()) {
            rewrittenGuideWithoutTabs = tabReplacement.getKey().matcher(rewrittenGuideWithoutTabs).replaceAll(tabReplacement.getValue());
        }
        Files.writeString(targetFile, (CharSequence)rewrittenGuideWithoutTabs.trim(), new OpenOption[0]);
    }

    private static String rewriteContent(String fileName, String content, Set<String> downstreamGuides, Map<String, String> titlesByReference, Map<String, List<String>> errors) {
        content = XREF_PATTERN.matcher(content).replaceAll(mr -> {
            String reference = AssembleDownstreamDocumentation.getQualifiedReference(fileName, mr.group(1));
            String title = (String)titlesByReference.get(reference);
            if (title == null || title.isBlank()) {
                AssembleDownstreamDocumentation.addError(errors, fileName, "Unable to find title for: " + mr.group() + " [" + reference + "]");
                title = "~~ unknown title ~~";
            }
            return "xref:" + AssembleDownstreamDocumentation.trimReference(mr.group(1)) + "[" + AssembleDownstreamDocumentation.escapeXrefTitleForReplaceAll(title) + "]";
        });
        content = ANGLE_BRACKETS_WITHOUT_DESCRIPTION_PATTERN.matcher(content).replaceAll(mr -> {
            String reference = AssembleDownstreamDocumentation.getQualifiedReference(fileName, mr.group(1));
            String title = (String)titlesByReference.get(reference);
            if (title == null || title.isBlank()) {
                AssembleDownstreamDocumentation.addError(errors, fileName, "Unable to find title for: " + mr.group() + " [" + reference + "]");
                title = "~~ unknown title ~~";
            }
            return "xref:" + AssembleDownstreamDocumentation.trimReference(mr.group(1)) + "[" + AssembleDownstreamDocumentation.escapeXrefTitleForReplaceAll(title) + "]";
        });
        content = ANGLE_BRACKETS_WITH_DESCRIPTION_PATTERN.matcher(content).replaceAll(mr -> "xref:" + AssembleDownstreamDocumentation.trimReference(mr.group(1)) + "[" + AssembleDownstreamDocumentation.escapeXrefTitleForReplaceAll(mr.group(2)) + "]");
        content = XREF_GUIDE_PATTERN.matcher(content).replaceAll(mr -> {
            if (downstreamGuides.contains(mr.group(1) + ADOC_SUFFIX)) {
                return mr.group(0);
            }
            return "link:{quarkusio-guides}/" + mr.group(1);
        });
        content = ANCHOR_PATTERN.matcher(content).replaceAll(mr -> "[[" + mr.group(1) + "]]");
        content = FOOTNOTE_PATTERN.matcher(content).replaceAll(mr -> {
            if (mr.group(2) != null) {
                return "footnoteref:[" + mr.group(1) + "]";
            }
            return "footnoteref:[" + mr.group(1) + ", ";
        });
        content = TOOLTIP_PATTERN_DEFAULT_COLUMN.matcher(content).replaceAll(mr -> "|*" + mr.group(1) + "*");
        content = TOOLTIP_PATTERN.matcher(content).replaceAll(mr -> {
            if (mr.group(3) != null) {
                return "*" + mr.group(1) + "*: " + mr.group(2) + "\n\n";
            }
            return "*" + mr.group(1) + "*: " + mr.group(2);
        });
        return content;
    }

    private static String escapeXrefTitleForReplaceAll(String title) {
        return title.trim().replace("]", "\\\\]");
    }

    private static String trimReference(String reference) {
        if ((reference = AssembleDownstreamDocumentation.normalizeAdoc(reference)).startsWith("#")) {
            return reference.substring(1);
        }
        if (reference.contains(ADOC_SUFFIX)) {
            return reference;
        }
        if (reference.contains("#")) {
            int hashIndex = reference.indexOf(35);
            return reference.substring(0, hashIndex) + ADOC_SUFFIX + reference.substring(hashIndex);
        }
        return reference;
    }

    private static String getQualifiedReference(String fileName, String reference) {
        if ((reference = AssembleDownstreamDocumentation.normalizeAdoc(reference)).startsWith("#")) {
            return fileName + reference;
        }
        if (reference.contains(ADOC_SUFFIX)) {
            return reference;
        }
        if (reference.contains("#")) {
            int hashIndex = reference.indexOf(35);
            return reference.substring(0, hashIndex) + ADOC_SUFFIX + reference.substring(hashIndex);
        }
        return fileName + "#" + reference;
    }

    private static String normalizeAdoc(String adoc) {
        if (adoc.startsWith("./")) {
            return adoc.substring(2);
        }
        return adoc;
    }

    private static void addError(Map<String, List<String>> errors, String fileName, String error) {
        errors.computeIfAbsent(fileName, f -> new ArrayList()).add(error);
    }

    public static class ConfigFile {
        public List<String> guides;
    }

    public static class GuideContent {
        public Path guide;
        public Set<Path> simpleIncludes = new TreeSet<Path>();
        public Set<Path> includes = new TreeSet<Path>();
        public Set<Path> images = new TreeSet<Path>();
        public Set<Path> generatedDocFiles = new TreeSet<Path>();

        public GuideContent(Path guide) {
            this.guide = guide;
        }
    }
}

