/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.docs.generation;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.exc.StreamWriteException;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.asciidoctor.Asciidoctor;
import org.asciidoctor.Options;
import org.asciidoctor.SafeMode;
import org.asciidoctor.ast.Document;
import org.asciidoctor.ast.StructuralNode;

public class YamlMetadataGenerator {
    private static Messages messages = new Messages();
    static final String INCL_ATTRIBUTES = "include::_attributes.adoc[]\n";
    static final String YAML_FRONTMATTER = "---\n";
    private static final String COMPATIBILITY_TOPIC = "compatibility";
    Path srcDir;
    Path targetDir;
    final Index index = new Index();
    Predicate<String> filePatternFilter;

    public static void main(String[] args) throws Exception {
        System.out.println("[INFO] Creating YAML metadata generator: " + String.valueOf(List.of(args)));
        YamlMetadataGenerator generator = new YamlMetadataGenerator().setSrcDir(args.length >= 1 ? Path.of(args[0], new String[0]) : YamlMetadataGenerator.docsDir().resolve("src/main/asciidoc")).setTargetDir(args.length >= 2 ? Path.of(args[1], new String[0]) : YamlMetadataGenerator.docsDir().resolve("target"));
        System.out.println("[INFO] Generating metadata index");
        generator.generateIndex();
        System.out.println("[INFO] Writing metadata index and error files");
        generator.writeYamlFiles();
        System.out.println("[INFO] Done");
    }

    public YamlMetadataGenerator setSrcDir(Path srcDir) {
        this.srcDir = srcDir;
        return this;
    }

    public YamlMetadataGenerator setTargetDir(Path targetDir) {
        this.targetDir = targetDir;
        return this;
    }

    public YamlMetadataGenerator setFileFilterPattern(String filter) {
        if ("true".equals(filter)) {
            this.filePatternFilter = x -> true;
        } else if ("false".equals(filter)) {
            this.filePatternFilter = x -> false;
        } else if (filter == null || filter.isBlank()) {
            this.filePatternFilter = Pattern.compile(filter).asPredicate();
        }
        return this;
    }

    public YamlMetadataGenerator setFileList(final Collection<String> fileNames) {
        if (fileNames != null && !fileNames.isEmpty()) {
            this.filePatternFilter = new Predicate<String>(){

                @Override
                public boolean test(String p) {
                    return fileNames.contains(p);
                }
            };
        }
        return this;
    }

    public void writeYamlFiles() throws StreamWriteException, DatabindException, IOException {
        ObjectMapper om = new ObjectMapper((JsonFactory)new YAMLFactory().enable(YAMLGenerator.Feature.MINIMIZE_QUOTES).disable(YAMLGenerator.Feature.SPLIT_LINES));
        Map<String, DocMetadata> metadata = this.index.metadataByFile();
        om.writeValue(this.targetDir.resolve("indexByType.yaml").toFile(), (Object)this.index);
        om.writeValue(this.targetDir.resolve("indexByFile.yaml").toFile(), metadata);
        om.writeValue(this.targetDir.resolve("relations.yaml").toFile(), this.index.relationsByUrl(metadata));
        om.writeValue(this.targetDir.resolve("errorsByType.yaml").toFile(), (Object)messages);
        om.writeValue(this.targetDir.resolve("errorsByFile.yaml").toFile(), messages.allByFile());
    }

    public Index generateIndex() throws IOException {
        if (!Files.exists(this.srcDir, new LinkOption[0]) || !Files.isDirectory(this.srcDir, new LinkOption[0])) {
            throw new IllegalStateException(String.format("Source directory (%s) does not exist", this.srcDir.toAbsolutePath()));
        }
        if (!Files.exists(this.targetDir, new LinkOption[0]) || !Files.isDirectory(this.targetDir, new LinkOption[0])) {
            throw new IllegalStateException(String.format("Target directory (%s) does not exist. Exiting.%n", this.targetDir.toAbsolutePath()));
        }
        messages.setRoot(this.srcDir);
        Options options = Options.builder().docType("book").sourceDir(this.srcDir.toFile()).baseDir(this.srcDir.toFile()).safe(SafeMode.UNSAFE).build();
        try (Asciidoctor asciidoctor = Asciidoctor.Factory.create();
             Stream<Path> pathStream = Files.list(this.srcDir);){
            pathStream.filter(path -> this.includeFile(path.getFileName().toString())).forEach(path -> {
                String summaryString;
                String str;
                try {
                    str = Files.readString(path);
                }
                catch (IOException e) {
                    messages.record("ioexception", (Path)path);
                    return;
                }
                if (str.startsWith(YAML_FRONTMATTER)) {
                    int end = str.indexOf(YAML_FRONTMATTER, YAML_FRONTMATTER.length());
                    str = str.substring(end + YAML_FRONTMATTER.length());
                }
                Document doc = asciidoctor.load(str, options);
                int includeAttr = str.indexOf(INCL_ATTRIBUTES);
                if (includeAttr < 0) {
                    messages.record("missing-attributes", (Path)path);
                } else {
                    String prefix = str.substring(0, includeAttr);
                    if (prefix.contains("\n\n")) {
                        messages.record("detached-attributes", (Path)path);
                    }
                }
                int titlePos = str.indexOf("\n= ");
                int documentHeaderEnd = str.indexOf("\n\n", titlePos);
                String documentHeader = str.substring(0, documentHeaderEnd);
                if (documentHeader.contains(":toc:")) {
                    messages.record("toc", (Path)path);
                }
                String title = doc.getDoctitle();
                String id = doc.getId();
                Object categories = doc.getAttribute((Object)"categories");
                Object keywords = doc.getAttribute((Object)"keywords");
                Object summary = doc.getAttribute((Object)"summary");
                Object type = doc.getAttribute((Object)"diataxis-type");
                Object topics = doc.getAttribute((Object)"topics");
                Object extensions = doc.getAttribute((Object)"extensions");
                Optional<StructuralNode> preambleNode = doc.getBlocks().stream().filter(b -> "preamble".equals(b.getNodeName())).findFirst();
                if (preambleNode.isPresent()) {
                    Optional<String> content = preambleNode.get().getBlocks().stream().filter(b -> "paragraph".equals(b.getContext())).map(b -> b.getContent().toString()).filter(s -> !s.contains("attributes.adoc")).findFirst();
                    summaryString = this.getSummary(summary, content);
                    if (content.isPresent()) {
                        this.index.add(new DocMetadata(title, (Path)path, summaryString, categories, keywords, topics, extensions, type, id));
                    } else {
                        messages.record("empty-preamble", (Path)path);
                        this.index.add(new DocMetadata(title, (Path)path, summaryString, categories, keywords, topics, extensions, type, id));
                    }
                } else {
                    messages.record("missing-preamble", (Path)path);
                    summaryString = this.getSummary(summary, Optional.empty());
                    this.index.add(new DocMetadata(title, (Path)path, summaryString, categories, keywords, topics, extensions, type, id));
                }
                long spaceCount = summaryString.chars().filter(c -> c == 32).count();
                if (spaceCount > 26L) {
                    messages.record("summary-too-long", (Path)path);
                }
            });
        }
        return this.index;
    }

    boolean includeFile(String fileName) {
        if (fileName.startsWith("_attributes") || fileName.equals("README.adoc")) {
            return false;
        }
        if (fileName.endsWith(".adoc")) {
            return this.filePatternFilter == null || this.filePatternFilter.test(fileName);
        }
        return false;
    }

    String getSummary(Object summary, Optional<String> preamble) {
        String result = (summary != null ? summary.toString() : preamble.orElse("")).trim().replaceAll("\n", " ").replaceAll("\\s+", " ").replaceAll("<[^>]+>(.*?)</[^>]+>", "$1");
        int pos = result.indexOf(". ");
        if (pos >= 1) {
            return result.substring(0, pos + 1).trim();
        }
        return result;
    }

    static Path docsDir() {
        Path path = Paths.get(System.getProperty("user.dir"), new String[0]);
        if (path.endsWith("docs")) {
            return path;
        }
        return path.resolve("docs");
    }

    public static class Index {
        Map<Type, IndexByType> types = new HashMap<Type, IndexByType>();

        public List<Map<String, String>> getCategories() {
            return Stream.of(Category.values()).map(c -> c.toMap()).collect(Collectors.toList());
        }

        public Map<String, Collection<DocMetadata>> getTypes() {
            return this.types.entrySet().stream().collect(Collectors.toMap(e -> ((Type)((Object)((Object)e.getKey()))).id, e -> ((IndexByType)e.getValue()).getIndex()));
        }

        public void add(DocMetadata doc) {
            this.types.computeIfAbsent(doc.type, IndexByType::new).add(doc);
        }

        public Map<String, DocMetadata> metadataByFile() {
            return this.types.values().stream().flatMap(v -> v.getIndex().stream()).collect(Collectors.toMap(v -> v.filename, v -> v, (o1, o2) -> o1, TreeMap::new));
        }

        public Map<String, DocRelations> relationsByUrl(Map<String, DocMetadata> metadataByFile) {
            TreeMap<String, DocRelations> relationsByUrl = new TreeMap<String, DocRelations>();
            for (Map.Entry<String, DocMetadata> currentMetadataEntry : metadataByFile.entrySet()) {
                DocRelations docRelations = new DocRelations();
                for (Map.Entry<String, DocMetadata> candidateMetadataEntry : metadataByFile.entrySet()) {
                    if (candidateMetadataEntry.getKey().equals(currentMetadataEntry.getKey())) continue;
                    DocMetadata candidateMetadata = candidateMetadataEntry.getValue();
                    int extensionMatches = 0;
                    for (String extension : currentMetadataEntry.getValue().getExtensions()) {
                        if (!candidateMetadata.getExtensions().contains(extension)) continue;
                        ++extensionMatches;
                    }
                    if (extensionMatches > 0) {
                        docRelations.sameExtensions.add(new DocRelation(candidateMetadata.getTitle(), candidateMetadata.getUrl(), candidateMetadata.getType(), extensionMatches));
                    }
                    int topicMatches = 0;
                    for (String topic : currentMetadataEntry.getValue().getTopics()) {
                        if (!candidateMetadata.getTopics().contains(topic)) continue;
                        ++topicMatches;
                    }
                    if (topicMatches <= 0 || candidateMetadata.getTopics().contains(YamlMetadataGenerator.COMPATIBILITY_TOPIC) && !currentMetadataEntry.getValue().getTopics().contains(YamlMetadataGenerator.COMPATIBILITY_TOPIC)) continue;
                    docRelations.sameTopics.add(new DocRelation(candidateMetadata.getTitle(), candidateMetadata.getUrl(), candidateMetadata.getType(), topicMatches));
                }
                if (docRelations.isEmpty()) continue;
                relationsByUrl.put(currentMetadataEntry.getValue().getUrl(), docRelations);
            }
            return relationsByUrl;
        }

        public Map<String, FileMessages> messagesByFile() {
            return messages.allByFile();
        }
    }

    private static class Messages {
        String root;
        Map<String, Collection<String>> errorsByFile = new TreeMap<String, Collection<String>>();
        Map<String, Collection<String>> warningsByFile = new TreeMap<String, Collection<String>>();
        public final Map<String, Collection<String>> errors = new TreeMap<String, Collection<String>>();

        private Messages() {
        }

        void setRoot(Path root) {
            this.root = root.toString();
            this.errors.clear();
            this.errorsByFile.clear();
            this.warningsByFile.clear();
        }

        void record(String errorKey, Path path) {
            this.record(errorKey, path, null);
        }

        void record(String errorKey, Path path, String message) {
            String filename = path.getFileName().toString().replace(this.root, "");
            if (message == null) {
                message = this.getMessageforKey(errorKey);
            }
            if (this.isWarning(errorKey)) {
                this.warningsByFile.computeIfAbsent(filename, k -> new ArrayList()).add(message);
            } else {
                this.errorsByFile.computeIfAbsent(filename, k -> new ArrayList()).add(message);
            }
            this.errors.computeIfAbsent(errorKey, k -> new HashSet()).add(filename);
        }

        private boolean isWarning(String errorKey) {
            switch (errorKey) {
                case "missing-id": 
                case "not-diataxis-type": {
                    return true;
                }
            }
            return false;
        }

        private String getMessageforKey(String errorKey) {
            switch (errorKey) {
                case "missing-attributes": {
                    return "Document does not include common attributes: include::_attributes.adoc[]\n";
                }
                case "detached-attributes": {
                    return "The document header ended (blank line) before common attributes were included.";
                }
                case "empty-preamble": {
                    return "Document preamble is empty. See https://quarkus.io/guides/doc-reference#abstracts-preamble";
                }
                case "missing-preamble": {
                    return "Document does not have a preamble. See https://quarkus.io/guides/doc-reference#abstracts-preamble";
                }
                case "summary-too-long": {
                    return "Document summary (either summary attribute or the preamble) is longer than 26 words. See https://quarkus.io/guides/doc-reference#doc-header-optional";
                }
                case "missing-id": {
                    return "Document does not define an id. See https://quarkus.io/guides/doc-reference#document-header";
                }
                case "missing-categories": {
                    return "Document does not specify associated categories. See https://quarkus.io/guides/doc-reference#categories";
                }
                case "not-diataxis-type": {
                    return "Document type not recognized. It either does not have a diataxis-type attribute or does not follow naming conventions. See https://quarkus.io/guides/doc-reference#document-header";
                }
                case "toc": {
                    return "A :toc: attribute is present in the document header (remove it)";
                }
            }
            return errorKey;
        }

        public Map<String, FileMessages> allByFile() {
            TreeMap<String, FileMessages> result = new TreeMap<String, FileMessages>();
            this.errorsByFile.forEach((k, v) -> {
                FileMessages mr = result.computeIfAbsent((String)k, x -> new FileMessages());
                mr.errors = v;
            });
            this.warningsByFile.forEach((k, v) -> {
                FileMessages mr = result.computeIfAbsent((String)k, x -> new FileMessages());
                mr.warnings = v;
            });
            return result;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    static class DocMetadata
    implements Comparable<DocMetadata> {
        String title;
        String filename;
        String summary;
        Set<String> keywords = new LinkedHashSet<String>();
        Set<Category> categories = new TreeSet<Category>();
        Set<String> topics = new LinkedHashSet<String>();
        Set<String> extensions = new LinkedHashSet<String>();
        String id;
        Type type;

        DocMetadata(String title, Path path, String summary, Object categories, Object keywords, Object topics, Object extensions, Object diataxisType, String id) {
            this.id = id;
            this.title = title == null ? "" : title;
            this.filename = path.getFileName().toString();
            this.summary = summary;
            this.keywords = this.toSet(keywords);
            this.topics = this.toSet(topics);
            this.extensions = this.toSet(extensions);
            Category.addAll(this.categories, categories, path);
            this.type = Type.fromObject(diataxisType);
            if (this.type == null) {
                if (this.categories.contains((Object)Category.getting_started)) {
                    this.type = Type.tutorial;
                } else if (this.filename.endsWith("-concept.adoc")) {
                    this.type = Type.concept;
                } else if (this.filename.endsWith("-howto.adoc")) {
                    this.type = Type.howto;
                } else if (this.filename.endsWith("-tutorial.adoc")) {
                    this.type = Type.tutorial;
                } else if (this.filename.endsWith("-reference.adoc")) {
                    this.type = Type.reference;
                } else {
                    this.type = Type.other;
                    messages.record("not-diataxis-type", path);
                }
            }
            if (id == null) {
                messages.record("missing-id", path);
            }
            if (this.categories.isEmpty()) {
                messages.record("missing-categories", path);
            }
        }

        public String getId() {
            return this.id;
        }

        public String getFilename() {
            return this.filename;
        }

        public String getTitle() {
            return this.title;
        }

        public String getSummary() {
            return this.summary;
        }

        public String getUrl() {
            return "/guides/" + this.filename.replace(".adoc", "");
        }

        public String getCategories() {
            return this.categories.stream().map(x -> x.id).collect(Collectors.joining(", "));
        }

        public Set<String> toSet(Object value) {
            if (value == null) {
                return Set.of();
            }
            String valueString = value.toString().trim();
            if (valueString.isEmpty()) {
                return Set.of();
            }
            return Arrays.stream(valueString.split(",")).map(String::trim).collect(Collectors.toCollection(LinkedHashSet::new));
        }

        public String getKeywords() {
            return String.join((CharSequence)", ", this.keywords);
        }

        public Set<String> getExtensions() {
            return this.extensions;
        }

        public Set<String> getTopics() {
            return this.topics;
        }

        public String getType() {
            return this.type.id;
        }

        @Override
        public int compareTo(DocMetadata that) {
            return this.title.compareTo(that.title);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class FileMessages {
        Collection<String> errors;
        Collection<String> warnings;

        Collection<String> warnings() {
            return this.warnings == null ? List.of() : this.warnings;
        }

        Collection<String> errors() {
            return this.errors == null ? List.of() : this.errors;
        }

        public boolean listAll(StringBuilder sb) {
            this.errors().forEach(e -> sb.append("    [ ERR] ").append((String)e).append("\n"));
            this.warnings().forEach(e -> sb.append("    [WARN] ").append((String)e).append("\n"));
            sb.append("\n");
            return !this.errors().isEmpty();
        }

        public boolean mdListAll(StringBuilder sb) {
            this.errors().forEach(e -> sb.append("- \ud83d\uded1 ").append((String)e).append("\n"));
            this.warnings().forEach(e -> sb.append("- \u26a0\ufe0f ").append((String)e).append("\n"));
            sb.append("\n");
            return !this.errors().isEmpty();
        }
    }

    public static class DocRelationComparator
    implements Comparator<DocRelation> {
        static final DocRelationComparator INSTANCE = new DocRelationComparator();

        @Override
        public int compare(DocRelation o1, DocRelation o2) {
            int compareMatches = o2.matches - o1.matches;
            if (compareMatches != 0) {
                return compareMatches;
            }
            return o1.title.compareToIgnoreCase(o2.title);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class DocRelation {
        final String title;
        final String url;
        final String type;
        final int matches;

        DocRelation(String title, String url, String type, int matches) {
            this.title = title;
            this.url = url;
            this.type = type;
            this.matches = matches;
        }

        public String getTitle() {
            return this.title;
        }

        public String getUrl() {
            return this.url;
        }

        public String getType() {
            return this.type;
        }

        public int getMatches() {
            return this.matches;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public static class DocRelations {
        final Set<DocRelation> sameTopics = new TreeSet<DocRelation>(DocRelationComparator.INSTANCE);
        final Set<DocRelation> sameExtensions = new TreeSet<DocRelation>(DocRelationComparator.INSTANCE);

        public Set<DocRelation> getSameTopics() {
            return this.sameTopics;
        }

        public Set<DocRelation> getSameExtensions() {
            return this.sameExtensions;
        }

        @JsonIgnore
        public boolean isEmpty() {
            return this.sameTopics.isEmpty() && this.sameExtensions.isEmpty();
        }
    }

    static class IndexByType {
        String id;
        String name;
        Map<String, DocMetadata> docs = new TreeMap<String, DocMetadata>();

        IndexByType(Type c) {
            this.name = c.name;
            this.id = c.id;
        }

        public Collection<DocMetadata> getIndex() {
            return this.docs.values().stream().sorted(DocMetadata::compareTo).collect(Collectors.toList());
        }

        public void add(DocMetadata doc) {
            this.docs.put(doc.filename, doc);
        }
    }

    static enum Type {
        concept("concepts", "Concept", "concept"),
        howto("howto", "How-To Guide"),
        tutorial("tutorial", "Tutorial"),
        reference("reference", "Reference"),
        other("guide", "General Guide");

        final String name;
        final String id;
        final String suffix;

        private Type(String id, String name) {
            this(id, name, id);
        }

        private Type(String id, String name, String suffix) {
            this.name = name;
            this.id = id;
            this.suffix = suffix;
        }

        public static Type fromObject(Object diataxisType) {
            if (diataxisType != null) {
                String type = diataxisType.toString().toLowerCase();
                for (Type value : Type.values()) {
                    if (!value.id.equals(type) && !value.suffix.equals(type)) continue;
                    return value;
                }
            }
            return null;
        }
    }

    static enum Category {
        alt_languages("alt-languages", "Alternative languages"),
        architecture("architecture", "Architecture"),
        business_automation("business-automation", "Business Automation"),
        cloud("cloud", "Cloud"),
        command_line("command-line", "Command Line Applications"),
        compatibility("compatibility", "Compatibility"),
        contributing("contributing", "Contributing"),
        core("core", "Core"),
        data("data", "Data"),
        getting_started("getting-started", "Getting Started"),
        integration("integration", "Integration"),
        messaging("messaging", "Messaging"),
        miscellaneous("miscellaneous", "Miscellaneous"),
        native_docs("native", "Native"),
        observability("observability", "Observability"),
        security("security", "Security"),
        serialization("serialization", "Serialization"),
        tooling("tooling", "Tooling"),
        web("web", "Web"),
        writing_extensions("writing-extensions", "Writing Extensions");

        final String id;
        final String name;

        private Category(String id, String name) {
            this.id = id;
            this.name = name;
        }

        public Map<String, String> toMap() {
            HashMap<String, String> result = new HashMap<String, String>();
            result.put("cat-id", this.id);
            result.put("category", this.name);
            return result;
        }

        public static void addAll(Set<Category> set, Object source, Path path) {
            if (source == null) {
                return;
            }
            for (String c : source.toString().split("\\s*,\\s*")) {
                String lower = c.toLowerCase();
                Optional<Category> match = Stream.of(Category.values()).filter(cat -> cat.id.equals(lower)).findFirst();
                if (match.isEmpty()) {
                    messages.record("unknown-category", path, "Unknown category: " + c);
                    continue;
                }
                set.add(match.get());
            }
        }
    }
}

