/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.mcp;

import io.quarkus.devui.runtime.DevUIBuildTimeStaticService;
import io.quarkus.devui.runtime.comms.JsonRpcRouter;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethod;
import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.quarkus.devui.runtime.mcp.Filter;
import io.quarkus.devui.runtime.mcp.McpDevUIJsonRpcService;
import io.quarkus.devui.runtime.mcp.model.resource.Content;
import io.quarkus.devui.runtime.mcp.model.resource.Resource;
import io.quarkus.runtime.annotations.DevMCPEnableByDefault;
import io.quarkus.runtime.annotations.JsonRpcDescription;
import io.quarkus.runtime.annotations.Usage;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ApplicationScoped
public class McpResourcesService {
    @Inject
    JsonRpcRouter jsonRpcRouter;
    @Inject
    DevUIBuildTimeStaticService buildTimeStaticService;
    @Inject
    McpDevUIJsonRpcService mcpDevUIJsonRpcService;
    private static final Pattern BTD_PATTERN = Pattern.compile("export const (\\w+)\\s*=\\s*([^;]+);", 32);
    private static final String URI_SCHEME = "quarkus://resource/";
    private static final String SUB_SCHEME_BUILD_TIME = "build-time/";
    private static final String SUB_SCHEME_RECORDED = "recorded/";
    private static final String UNDERSCORE = "_";
    private static final String DASH_DATA_DOT_JS = "-data.js";

    @DevMCPEnableByDefault
    @JsonRpcDescription(value="This list all resources available for MCP")
    public Map<String, List<Resource>> list() {
        return this.listAny(Filter.enabled);
    }

    public Map<String, List<Resource>> listDisabled() {
        return this.listAny(Filter.disabled);
    }

    private Map<String, List<Resource>> listAny(Filter filter) {
        if (this.mcpDevUIJsonRpcService.getMcpServerConfiguration().isEnabled()) {
            ArrayList<Resource> resources = new ArrayList<Resource>();
            resources.addAll(this.getBuildTimeData(filter));
            resources.addAll(this.getRecordedData(filter));
            return Map.of("resources", resources);
        }
        return null;
    }

    public boolean disableResource(String name) {
        this.mcpDevUIJsonRpcService.disableMethod(name);
        return true;
    }

    public boolean enableResource(String name) {
        this.mcpDevUIJsonRpcService.enableMethod(name);
        return true;
    }

    @DevMCPEnableByDefault
    @JsonRpcDescription(value="This reads a certain resource given the uri as provided by resources/list")
    public Map<String, List<Content>> read(@JsonRpcDescription(value="The uri of the resources as defined in resources/list") String uri) {
        if (this.mcpDevUIJsonRpcService.getMcpServerConfiguration().isEnabled()) {
            String subUri = uri.substring(URI_SCHEME.length());
            if (subUri.startsWith(SUB_SCHEME_BUILD_TIME)) {
                return this.readBuildTimeData(uri);
            }
            if (subUri.startsWith(SUB_SCHEME_RECORDED)) {
                return this.readRecordedData(uri);
            }
            throw new UncheckedIOException(uri + " not found", new IOException());
        }
        return null;
    }

    private Map<String, List<Content>> readBuildTimeData(String uri) {
        JsonMapper jsonMapper = this.jsonRpcRouter.getJsonMapper();
        String method = uri.substring("quarkus://resource/build-time/".length());
        String[] split = method.split(UNDERSCORE);
        String ns = split[0];
        String constt = split[1];
        String filename = ns + DASH_DATA_DOT_JS;
        String path = this.buildTimeStaticService.getUrlAndPath().get(filename);
        try {
            String jsContent = Files.readString(Paths.get(path, new String[0]));
            Content content = new Content();
            content.uri = uri;
            content.text = this.getBuildTimeDataConstValue(jsContent, constt);
            return Map.of("contents", List.of(content));
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Could not read " + path, ex);
        }
    }

    private Map<String, List<Content>> readRecordedData(String uri) {
        Map<String, JsonRpcMethod> recordedMethodsMap = this.jsonRpcRouter.getRecordedMethodsMap();
        JsonMapper jsonMapper = this.jsonRpcRouter.getJsonMapper();
        String method = uri.substring("quarkus://resource/recorded/".length());
        Content content = new Content();
        content.uri = uri;
        content.text = jsonMapper.toString(recordedMethodsMap.get(method).getRuntimeValue().getValue(), true);
        return Map.of("contents", List.of(content));
    }

    private List<Resource> getBuildTimeData(Filter filter) {
        ArrayList<Resource> r = new ArrayList<Resource>();
        Map<String, String> descriptions = this.buildTimeStaticService.getDescriptions();
        Map<String, String> contentTypes = this.buildTimeStaticService.getContentTypes();
        Map<String, String> urlAndPath = this.buildTimeStaticService.getUrlAndPath();
        for (Map.Entry<String, String> kv : urlAndPath.entrySet()) {
            if (!kv.getKey().endsWith(DASH_DATA_DOT_JS)) continue;
            try {
                String key = kv.getKey().substring(0, kv.getKey().length() - DASH_DATA_DOT_JS.length());
                if (key.equalsIgnoreCase("devui-jsonrpc")) continue;
                String content = Files.readString(Paths.get(kv.getValue(), new String[0]));
                Set<String> methodNames = this.extractBuildTimeDataMethods(key, content);
                for (String methodName : methodNames) {
                    if (!descriptions.containsKey(methodName) || !this.isEnabled(methodName, filter)) continue;
                    Resource resource = new Resource();
                    resource.uri = "quarkus://resource/build-time/" + methodName;
                    resource.name = methodName;
                    resource.description = descriptions.get(methodName);
                    resource.mimeType = contentTypes.get(methodName);
                    r.add(resource);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return r;
    }

    private List<Resource> getRecordedData(Filter filter) {
        ArrayList<Resource> r = new ArrayList<Resource>();
        Map<String, JsonRpcMethod> recordedMethodsMap = this.jsonRpcRouter.getRecordedMethodsMap();
        for (JsonRpcMethod recordedJsonRpcMethod : recordedMethodsMap.values()) {
            if (!this.isEnabled(recordedJsonRpcMethod, filter)) continue;
            Resource resource = new Resource();
            resource.uri = "quarkus://resource/recorded/" + recordedJsonRpcMethod.getMethodName();
            resource.name = recordedJsonRpcMethod.getMethodName();
            if (recordedJsonRpcMethod.getDescription() != null && !recordedJsonRpcMethod.getDescription().isBlank()) {
                resource.description = recordedJsonRpcMethod.getDescription();
            }
            r.add(resource);
        }
        return r;
    }

    private boolean isEnabled(JsonRpcMethod method, Filter filter) {
        if (method.getUsage().contains(Usage.DEV_MCP)) {
            if (this.mcpDevUIJsonRpcService.isExplicitlyEnabled(method.getMethodName())) {
                return filter.equals((Object)Filter.enabled);
            }
            if (this.mcpDevUIJsonRpcService.isExplicitlyDisabled(method.getMethodName())) {
                return filter.equals((Object)Filter.disabled);
            }
            if (filter.equals((Object)Filter.enabled)) {
                return method.isMcpEnabledByDefault();
            }
            if (filter.equals((Object)Filter.disabled)) {
                return !method.isMcpEnabledByDefault();
            }
        }
        return false;
    }

    private boolean isEnabled(String method, Filter filter) {
        Map<String, String> mcpDefaultEnabled = this.buildTimeStaticService.getMcpDefaultEnabled();
        if (this.mcpDevUIJsonRpcService.isExplicitlyEnabled(method)) {
            return filter.equals((Object)Filter.enabled);
        }
        if (this.mcpDevUIJsonRpcService.isExplicitlyDisabled(method)) {
            return filter.equals((Object)Filter.disabled);
        }
        if (filter.equals((Object)Filter.enabled)) {
            return !mcpDefaultEnabled.containsKey(method) || mcpDefaultEnabled.get(method).equals("true");
        }
        if (filter.equals((Object)Filter.disabled)) {
            return mcpDefaultEnabled.containsKey(method) && mcpDefaultEnabled.get(method).equals("false");
        }
        return false;
    }

    private Set<String> extractBuildTimeDataMethods(String ns, String jsContent) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Matcher matcher = BTD_PATTERN.matcher(jsContent);
        while (matcher.find()) {
            String name = matcher.group(1);
            String jsonValue = matcher.group(2).trim();
            if (this.isEmptyValue(jsonValue)) continue;
            result.add(ns + UNDERSCORE + name);
        }
        return result;
    }

    private boolean isEmptyValue(String value) {
        return value == null || value.trim().isEmpty() || value.trim().matches("^\\[\\s*]$");
    }

    private String getBuildTimeDataConstValue(String jsContent, String constName) {
        String patternString = "export const " + Pattern.quote(constName) + "\\s*=\\s*([^;]+);";
        Pattern pattern = Pattern.compile(patternString, 32);
        Matcher matcher = pattern.matcher(jsContent);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return "Error: Data not found for " + constName;
    }
}

