/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.config;

import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.runtime.config.ConfigDescriptionBean;
import io.quarkus.runtime.annotations.JsonRpcDescription;
import io.quarkus.vertx.http.runtime.devmode.ConfigDescription;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;

@ApplicationScoped
public class ConfigJsonRPCService {
    @Inject
    ConfigDescriptionBean configDescriptionBean;

    public JsonArray getAllConfiguration() {
        return new JsonArray(this.configDescriptionBean.getAllConfig());
    }

    @JsonRpcDescription(value="Get all configurations and their values for the Quarkus application")
    public JsonObject getAllValues() {
        JsonObject values = new JsonObject();
        for (ConfigDescription configDescription : this.configDescriptionBean.getAllConfig()) {
            values.put(configDescription.getName(), (Object)configDescription.getConfigValue().getValue());
        }
        return values;
    }

    @JsonRpcDescription(value="Get the project properties for the Quarkus application")
    public JsonObject getProjectProperties() {
        JsonObject response = new JsonObject();
        try {
            List resourcesDir = DevConsoleManager.getHotReplacementContext().getResourcesDir();
            if (resourcesDir.isEmpty()) {
                response.put("error", (Object)"Unable to manage configurations - no resource directory found");
            } else {
                Path path = (Path)resourcesDir.get(0);
                Path configPropertiesPath = path.resolve("application.properties");
                if (Files.exists(configPropertiesPath, new LinkOption[0])) {
                    response.put("type", (Object)"properties");
                    String value = new String(Files.readAllBytes(configPropertiesPath));
                    response.put("value", (Object)value);
                } else {
                    response.put("type", (Object)"properties");
                    response.put("value", (Object)"");
                }
            }
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
        return response;
    }
}

