/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime.mcp;

import io.quarkus.devui.runtime.DevUIBuildTimeStaticService;
import io.quarkus.devui.runtime.comms.JsonRpcRouter;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethod;
import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.quarkus.devui.runtime.mcp.model.resource.Content;
import io.quarkus.devui.runtime.mcp.model.resource.Resource;
import io.quarkus.runtime.annotations.JsonRpcDescription;
import io.quarkus.runtime.annotations.Usage;
import jakarta.annotation.PostConstruct;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@ApplicationScoped
public class McpResourcesService {
    @Inject
    JsonRpcRouter jsonRpcRouter;
    @Inject
    DevUIBuildTimeStaticService buildTimeStaticService;
    private final List<Resource> resources = new LinkedList<Resource>();
    private static final Pattern BTD_PATTERN = Pattern.compile("export const (\\w+)\\s*=\\s*([^;]+);", 32);
    private static final String URI_SCHEME = "quarkus://resource/";
    private static final String SUB_SCHEME_BUILD_TIME = "build-time/";
    private static final String SUB_SCHEME_RECORDED = "recorded/";
    private static final String UNDERSCORE = "_";
    private static final String DASH_DATA_DOT_JS = "-data.js";

    @PostConstruct
    public void init() {
        if (this.resources.isEmpty()) {
            this.addBuildTimeData();
            this.addRecordedData();
        }
    }

    @JsonRpcDescription(value="This list all resources available for MCP")
    public Map<String, List<Resource>> list() {
        return Map.of("resources", this.resources);
    }

    @JsonRpcDescription(value="This reads a certain resource given the uri as provided by resources/list")
    public Map<String, List<Content>> read(@JsonRpcDescription(value="The uri of the resources as defined in resources/list") String uri) {
        String subUri = uri.substring(URI_SCHEME.length());
        if (subUri.startsWith(SUB_SCHEME_BUILD_TIME)) {
            return this.readBuildTimeData(uri);
        }
        if (subUri.startsWith(SUB_SCHEME_RECORDED)) {
            return this.readRecordedData(uri);
        }
        throw new UncheckedIOException(uri + " not found", new IOException());
    }

    private Map<String, List<Content>> readBuildTimeData(String uri) {
        JsonMapper jsonMapper = this.jsonRpcRouter.getJsonMapper();
        String method = uri.substring("quarkus://resource/build-time/".length());
        String[] split = method.split(UNDERSCORE);
        String ns = split[0];
        String constt = split[1];
        String filename = ns + DASH_DATA_DOT_JS;
        String path = this.buildTimeStaticService.getUrlAndPath().get(filename);
        try {
            String jsContent = Files.readString(Paths.get(path, new String[0]));
            Content content = new Content();
            content.uri = uri;
            content.text = this.getBuildTimeDataConstValue(jsContent, constt);
            return Map.of("contents", List.of(content));
        }
        catch (IOException ex) {
            throw new UncheckedIOException("Could not read " + path, ex);
        }
    }

    private Map<String, List<Content>> readRecordedData(String uri) {
        Map<String, JsonRpcMethod> recordedMethodsMap = this.jsonRpcRouter.getRecordedMethodsMap();
        JsonMapper jsonMapper = this.jsonRpcRouter.getJsonMapper();
        String method = uri.substring("quarkus://resource/recorded/".length());
        Content content = new Content();
        content.uri = uri;
        content.text = jsonMapper.toString(recordedMethodsMap.get(method).getRuntimeValue().getValue(), true);
        return Map.of("contents", List.of(content));
    }

    private void addBuildTimeData() {
        Map<String, String> descriptions = this.buildTimeStaticService.getDescriptions();
        Map<String, String> contentTypes = this.buildTimeStaticService.getContentTypes();
        Map<String, String> urlAndPath = this.buildTimeStaticService.getUrlAndPath();
        for (Map.Entry<String, String> kv : urlAndPath.entrySet()) {
            if (!kv.getKey().endsWith(DASH_DATA_DOT_JS)) continue;
            try {
                String key = kv.getKey().substring(0, kv.getKey().length() - DASH_DATA_DOT_JS.length());
                if (key.equalsIgnoreCase("devui-jsonrpc")) continue;
                String content = Files.readString(Paths.get(kv.getValue(), new String[0]));
                Set<String> methodNames = this.extractBuildTimeDataMethods(key, content);
                for (String methodName : methodNames) {
                    if (!descriptions.containsKey(methodName)) continue;
                    Resource resource = new Resource();
                    resource.uri = "quarkus://resource/build-time/" + methodName;
                    resource.name = methodName;
                    resource.description = descriptions.get(methodName);
                    resource.mimeType = contentTypes.get(methodName);
                    this.resources.add(resource);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }

    private void addRecordedData() {
        Map<String, JsonRpcMethod> recordedMethodsMap = this.jsonRpcRouter.getRecordedMethodsMap();
        for (JsonRpcMethod recordedJsonRpcMethod : recordedMethodsMap.values()) {
            if (!recordedJsonRpcMethod.getUsage().contains(Usage.DEV_MCP)) continue;
            Resource resource = new Resource();
            resource.uri = "quarkus://resource/recorded/" + recordedJsonRpcMethod.getMethodName();
            resource.name = recordedJsonRpcMethod.getMethodName();
            if (recordedJsonRpcMethod.getDescription() != null && !recordedJsonRpcMethod.getDescription().isBlank()) {
                resource.description = recordedJsonRpcMethod.getDescription();
            }
            this.resources.add(resource);
        }
    }

    private Set<String> extractBuildTimeDataMethods(String ns, String jsContent) {
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        Matcher matcher = BTD_PATTERN.matcher(jsContent);
        while (matcher.find()) {
            String name = matcher.group(1);
            String jsonValue = matcher.group(2).trim();
            if (this.isEmptyValue(jsonValue)) continue;
            result.add(ns + UNDERSCORE + name);
        }
        return result;
    }

    private boolean isEmptyValue(String value) {
        return value == null || value.trim().isEmpty() || value.trim().matches("^\\[\\s*]$");
    }

    private String getBuildTimeDataConstValue(String jsContent, String constName) {
        String patternString = "export const " + Pattern.quote(constName) + "\\s*=\\s*([^;]+);";
        Pattern pattern = Pattern.compile(patternString, 32);
        Matcher matcher = pattern.matcher(jsContent);
        if (matcher.find()) {
            return matcher.group(1).trim();
        }
        return "Error: Data not found for " + constName;
    }
}

