/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.runtime;

import io.netty.handler.codec.http.HttpResponseStatus;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.runtime.DevUIBuildTimeStaticHandler;
import io.quarkus.devui.runtime.DevUICORSFilter;
import io.quarkus.devui.runtime.DevUIWebSocket;
import io.quarkus.devui.runtime.EndpointInfoHandler;
import io.quarkus.devui.runtime.LocalHostOnlyFilter;
import io.quarkus.devui.runtime.MvnpmHandler;
import io.quarkus.devui.runtime.VaadinRouterHandler;
import io.quarkus.devui.runtime.comms.JsonRpcRouter;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethod;
import io.quarkus.devui.runtime.jsonrpc.JsonRpcMethodName;
import io.quarkus.devui.runtime.jsonrpc.json.JsonMapper;
import io.quarkus.devui.runtime.jsonrpc.json.JsonTypeAdapter;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.devmode.FileSystemStaticHandler;
import io.quarkus.vertx.http.runtime.webjar.WebJarStaticHandler;
import io.quarkus.vertx.runtime.jackson.JsonUtil;
import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.web.RoutingContext;
import java.io.Closeable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.net.URL;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jboss.logging.Logger;

@Recorder
public class DevUIRecorder {
    private static final Logger LOG = Logger.getLogger(DevUIRecorder.class);
    public static final String DEV_MANAGER_GLOBALS_JSON_MAPPER_FACTORY = "dev-ui-databind-codec-builder";

    public void shutdownTask(ShutdownContext shutdownContext, String devUIBasePath) {
        shutdownContext.addShutdownTask((Runnable)new DeleteDirectoryRunnable(devUIBasePath));
    }

    public void createJsonRpcRouter(BeanContainer beanContainer, Map<String, Map<JsonRpcMethodName, JsonRpcMethod>> extensionMethodsMap, List<String> deploymentMethods, List<String> deploymentSubscriptions, Map<String, RuntimeValue> recordedValues) {
        JsonRpcRouter jsonRpcRouter = (JsonRpcRouter)beanContainer.beanInstance(JsonRpcRouter.class, new Annotation[0]);
        jsonRpcRouter.populateJsonRPCRuntimeMethods(extensionMethodsMap);
        jsonRpcRouter.setJsonRPCDeploymentActions(deploymentMethods, deploymentSubscriptions);
        if (recordedValues != null && !recordedValues.isEmpty()) {
            jsonRpcRouter.setRecordedValues(recordedValues);
        }
        jsonRpcRouter.initializeCodec(this.createJsonMapper());
    }

    private JsonMapper createJsonMapper() {
        JsonMapper.Factory factory = (JsonMapper.Factory)JsonMapper.Factory.deploymentLinker().createLink((Map)DevConsoleManager.getGlobal((String)DEV_MANAGER_GLOBALS_JSON_MAPPER_FACTORY));
        return factory.create(new JsonTypeAdapter<JsonObject, Map>(JsonObject.class, JsonObject::getMap, JsonObject::new), new JsonTypeAdapter<JsonArray, List>(JsonArray.class, JsonArray::getList, JsonArray::new), new JsonTypeAdapter<Buffer, String>(Buffer.class, buffer -> JsonUtil.BASE64_ENCODER.encodeToString(buffer.getBytes()), text -> {
            try {
                return Buffer.buffer((byte[])JsonUtil.BASE64_DECODER.decode((String)text));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Expected a base64 encoded byte array, got: " + text, e);
            }
        }));
    }

    public Handler<RoutingContext> communicationHandler() {
        return new DevUIWebSocket();
    }

    public Handler<RoutingContext> uiHandler(String finalDestination, String path, List<FileSystemStaticHandler.StaticWebRootConfiguration> webRootConfigurations, ShutdownContext shutdownContext) {
        WebJarStaticHandler handler = new WebJarStaticHandler(finalDestination, path, webRootConfigurations);
        shutdownContext.addShutdownTask((Runnable)new ShutdownContext.CloseRunnable((Closeable)handler));
        return handler;
    }

    public Handler<RoutingContext> buildTimeStaticHandler(String basePath, Map<String, String> urlAndPath) {
        return new DevUIBuildTimeStaticHandler(basePath, urlAndPath);
    }

    public Handler<RoutingContext> endpointInfoHandler(String basePath) {
        return new EndpointInfoHandler(basePath);
    }

    public Handler<RoutingContext> vaadinRouterHandler(String basePath) {
        return new VaadinRouterHandler(basePath);
    }

    public Handler<RoutingContext> mvnpmHandler(String root, Set<URL> mvnpmJarFiles) {
        return new MvnpmHandler(root, mvnpmJarFiles);
    }

    public Handler<RoutingContext> redirect(String contextRoot) {
        return this.redirect(contextRoot, null);
    }

    public Handler<RoutingContext> redirect(final String contextRoot, final String page) {
        return new Handler<RoutingContext>(){

            public void handle(RoutingContext rc) {
                String location = contextRoot + "dev-ui";
                if (page != null) {
                    location = location + "/" + page;
                }
                rc.response().putHeader("Location", location).setStatusCode(HttpResponseStatus.FOUND.code()).end();
            }
        };
    }

    public Handler<RoutingContext> createLocalHostOnlyFilter(List<String> hosts) {
        return new LocalHostOnlyFilter(hosts);
    }

    public Handler<RoutingContext> createDevUICorsFilter(List<String> hosts) {
        return new DevUICORSFilter(hosts);
    }

    private static final class DeleteDirectoryRunnable
    implements Runnable {
        private final Path directory;

        private DeleteDirectoryRunnable(String directory) {
            this.directory = Paths.get(directory, new String[0]);
        }

        @Override
        public void run() {
            try {
                Files.walkFileTree(this.directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                        Files.delete(dir);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Files.delete(file);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
            catch (IOException e) {
                LOG.error((Object)("Error cleaning up dev-ui temporary directory: " + String.valueOf(this.directory)), (Throwable)e);
            }
        }
    }
}

