/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.deployment.menu;

import io.quarkus.assistant.runtime.dev.Assistant;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.Capabilities;
import io.quarkus.deployment.IsLocalDevelopment;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.BuildSteps;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.devui.deployment.DevUIConfig;
import io.quarkus.devui.deployment.InternalPageBuildItem;
import io.quarkus.devui.spi.buildtime.BuildTimeActionBuildItem;
import io.quarkus.devui.spi.page.Page;
import io.quarkus.devui.spi.page.PageBuilder;
import io.quarkus.devui.spi.page.WebComponentPageBuilder;
import io.quarkus.devui.spi.workspace.Action;
import io.quarkus.devui.spi.workspace.ActionBuilder;
import io.quarkus.devui.spi.workspace.Display;
import io.quarkus.devui.spi.workspace.DisplayType;
import io.quarkus.devui.spi.workspace.Patterns;
import io.quarkus.devui.spi.workspace.WorkspaceActionBuildItem;
import io.quarkus.devui.spi.workspace.WorkspaceBuildItem;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletionStage;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

@BuildSteps(onlyIf={IsLocalDevelopment.class})
public class WorkspaceProcessor {
    private static final String NAMESPACE = "devui-workspace";

    @BuildStep
    void locateWorkspaceItems(BuildSystemTargetBuildItem buildSystemTarget, LaunchModeBuildItem launchModeBuildItem, BuildProducer<WorkspaceBuildItem> workspaceProducer, DevUIConfig devUIConfig) {
        if (launchModeBuildItem.isNotLocalDevModeType()) {
            return;
        }
        final Path outputDir = buildSystemTarget.getOutputDirectory();
        final Path projectRoot = outputDir.getParent();
        if (projectRoot != null && Files.exists(projectRoot, new LinkOption[0])) {
            final ArrayList<WorkspaceBuildItem.WorkspaceItem> workspaceItems = new ArrayList<WorkspaceBuildItem.WorkspaceItem>();
            final List ignoreFolders = devUIConfig.workspace().ignoreFolders().orElse(new ArrayList());
            ignoreFolders.add("node_modules");
            final List ignoreFilePatterns = devUIConfig.workspace().ignoreFiles().orElse(List.of());
            try {
                Files.walkFileTree(projectRoot, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        if (Files.isHidden(dir) || ignoreFolders.contains(dir.getFileName().toString()) || !Files.isReadable(dir) || !Files.isExecutable(dir)) {
                            return FileVisitResult.SKIP_SUBTREE;
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        boolean shouldIgnore;
                        String fileName = file.getFileName().toString();
                        boolean bl = shouldIgnore = Files.isHidden(file) || file.startsWith(outputDir) || !Files.isReadable(file) || ignoreFilePatterns.stream().anyMatch(p -> p.matcher(fileName).matches());
                        if (!shouldIgnore) {
                            String name = projectRoot.relativize(file).toString();
                            workspaceItems.add(new WorkspaceBuildItem.WorkspaceItem(name, file));
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
                        if (exc instanceof AccessDeniedException) {
                            if (Files.isDirectory(file, new LinkOption[0])) {
                                return FileVisitResult.SKIP_SUBTREE;
                            }
                            return FileVisitResult.CONTINUE;
                        }
                        return super.visitFileFailed(file, exc);
                    }
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            this.sortWorkspaceItems(workspaceItems);
            workspaceProducer.produce((BuildItem)new WorkspaceBuildItem(projectRoot, workspaceItems));
        }
    }

    @BuildStep
    InternalPageBuildItem createWorkspacePage() {
        InternalPageBuildItem item = new InternalPageBuildItem("Workspace", 25);
        item.addPage((PageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)((WebComponentPageBuilder)Page.webComponentPageBuilder().internal()).namespace(NAMESPACE)).title("Workspace")).icon("font-awesome-solid:folder-tree")).componentLink("qwc-workspace.js"));
        return item;
    }

    @BuildStep
    void createDefaultWorkspaceActions(BuildProducer<WorkspaceActionBuildItem> workspaceActionProducer) {
        ActionBuilder actionBuilder = Action.actionBuilder().label("Preview").function(t -> t).display(Display.split).displayType(DisplayType.markdown).namespace(NAMESPACE).filter(Patterns.ANY_MD);
        workspaceActionProducer.produce((BuildItem)new WorkspaceActionBuildItem(NAMESPACE, new ActionBuilder[]{actionBuilder}));
    }

    @BuildStep
    void createBuildTimeActions(Optional<WorkspaceBuildItem> workspaceBuildItem, List<WorkspaceActionBuildItem> workspaceActionBuildItems, BuildProducer<BuildTimeActionBuildItem> buildTimeActionProducer, Capabilities capabilities, CurateOutcomeBuildItem curateOutcomeBuildItem) {
        boolean assistantIsAvailable = capabilities.isPresent("io.quarkus.assistant");
        if (workspaceBuildItem.isPresent()) {
            BuildTimeActionBuildItem buildItemActions = new BuildTimeActionBuildItem(NAMESPACE);
            Map<String, Action> actionMap = workspaceActionBuildItems.stream().flatMap(item -> item.getActions().stream().map(builder -> builder.namespace(item.getExtensionPathName(curateOutcomeBuildItem)).build())).collect(Collectors.toMap(Action::getId, action -> action, (a, b) -> a));
            buildItemActions.actionBuilder().methodName("getWorkspaceItems").description("Gets all the items in the current workspace of the Quarkus project. This will return a list of workspace items, where a workspace item has a name and a path to the file").function(t -> ((WorkspaceBuildItem)workspaceBuildItem.get()).getWorkspaceItems()).build();
            buildItemActions.actionBuilder().methodName("getWorkspaceActions").description("Gets all the actions that can be performed on a item in the workspace").function(t -> actionMap.values().stream().map(action -> new WorkspaceAction(action.getId(), action.getLabel(), action.getFilter(), action.getDisplay(), action.getDisplayType(), action.isAssistant())).sorted(Comparator.comparing(WorkspaceAction::label)).collect(Collectors.toList())).build();
            buildItemActions.actionBuilder().methodName("executeAction").description("Execute a certain action on a workspace item").parameter("actionId", "The actionId as defined in the `getWorkspaceActions`. Each workspace action has a unique id").parameter("path", "The path, as a URI in String format, to the workspace item that this action should be peformed on").function(t -> {
                String actionId = (String)t.get("actionId");
                if (actionId != null) {
                    Object result;
                    Path path = Path.of(URI.create((String)t.get("path")));
                    Action actionToExecute = (Action)actionMap.get(actionId);
                    Path convertedPath = (Path)actionToExecute.getPathConverter().apply(path);
                    if (actionToExecute.isAssistant()) {
                        Assistant assistant = (Assistant)DevConsoleManager.getGlobal((String)DevConsoleManager.DEV_MANAGER_GLOBALS_ASSISTANT);
                        result = actionToExecute.getAssistantFunction().apply(assistant, t);
                    } else {
                        result = actionToExecute.getFunction().apply(t);
                    }
                    if (result != null && result instanceof CompletionStage) {
                        CompletionStage stage = (CompletionStage)result;
                        return stage.thenApply(res -> new WorkspaceActionResult(convertedPath, res, actionToExecute.isAssistant()));
                    }
                    return new WorkspaceActionResult(convertedPath, result, actionToExecute.isAssistant());
                }
                return null;
            }).build();
            buildItemActions.actionBuilder().methodName("getWorkspaceItemContent").description("The the content of a certain workspace item. This returns a WorkspaceContent that has String type, String content, boolean isBinary fields").parameter("path", "The path, as a URI in String format, to the workspace item that content is requested").function(params -> {
                if (params.containsKey("path")) {
                    Path path = Paths.get(URI.create((String)params.get("path")));
                    return this.readContents(path);
                }
                return null;
            }).build();
            buildItemActions.actionBuilder().methodName("saveWorkspaceItemContent").description("This will add or update an item in the workspace").parameter("content", "The new or updated content in String format").parameter("path", "The path, as a URI in String format, to the workspace item that should be created or updated").function(params -> {
                if (params.containsKey("content")) {
                    String content = (String)params.get("content");
                    Path path = Paths.get(URI.create((String)params.get("path")));
                    this.writeContent(path, content);
                    return new SavedResult(((WorkspaceBuildItem)workspaceBuildItem.get()).getRootPath().relativize(path).toString(), true, null);
                }
                return new SavedResult(null, false, "Invalid input");
            }).build();
            buildTimeActionProducer.produce((BuildItem)buildItemActions);
        }
    }

    private void sortWorkspaceItems(List<WorkspaceBuildItem.WorkspaceItem> items) {
        items.sort(Comparator.comparing(item -> this.isFileInRoot(item.name())).thenComparing(item -> WorkspaceProcessor.folderPriority(item.name())).thenComparing(WorkspaceBuildItem.WorkspaceItem::name));
    }

    private static int folderPriority(String name) {
        if (name.startsWith("src/main/java")) {
            return 1;
        }
        if (name.startsWith("src/main/resources")) {
            return 2;
        }
        if (name.startsWith("src/main/")) {
            return 3;
        }
        if (name.startsWith("src/")) {
            return 4;
        }
        if (name.startsWith("src/test/java")) {
            return 5;
        }
        if (name.startsWith("src/test/resources")) {
            return 6;
        }
        if (name.startsWith("src/test/")) {
            return 7;
        }
        if (name.startsWith("src/integrationTest/java")) {
            return 8;
        }
        if (name.startsWith("src/integrationTest/resources")) {
            return 9;
        }
        if (name.startsWith("src/integrationTest/")) {
            return 10;
        }
        return 11;
    }

    private boolean isFileInRoot(String name) {
        return !name.contains("/");
    }

    private String writeContent(Path path, String contents) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            if (!Files.exists(path, new LinkOption[0])) {
                Files.createFile(path, new FileAttribute[0]);
            }
            Files.writeString(path, (CharSequence)contents, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
            return path.toString();
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }

    private WorkspaceContent readContents(Path filePath) {
        if (filePath != null && Files.exists(filePath, new LinkOption[0]) && Files.isReadable(filePath)) {
            String mimeType = this.getMimeType(filePath);
            try {
                return new WorkspaceContent(mimeType, Files.readString(filePath), false);
            }
            catch (IOException ex) {
                return this.getEncodedBytes(mimeType, filePath);
            }
        }
        return null;
    }

    private String getMimeType(Path filePath) {
        try {
            String mimeType = Files.probeContentType(filePath);
            if (mimeType == null) {
                return this.getFileTypeManually(filePath);
            }
            return mimeType;
        }
        catch (IOException ex) {
            return this.getFileTypeManually(filePath);
        }
    }

    private WorkspaceContent getEncodedBytes(String mimeType, Path filePath) {
        try {
            return new WorkspaceContent(mimeType, Base64.getEncoder().encodeToString(Files.readAllBytes(filePath)), true);
        }
        catch (IOException ex) {
            return new WorkspaceContent("text", "Error: Could not read content of " + mimeType + " item. \n [" + ex.getMessage() + "]", false);
        }
    }

    private String getFileTypeManually(Path filePath) {
        String fileName = filePath.getFileName().toString();
        return fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(46) + 1) : "";
    }

    record WorkspaceContent(String type, String content, boolean isBinary) {
    }

    record SavedResult(String path, boolean success, String errorMessage) {
    }

    record WorkspaceActionResult(Path path, Object result, boolean isAssistant) {
    }

    record WorkspaceAction(String id, String label, Optional<Pattern> pattern, Display display, DisplayType displayType, boolean isAssistanceAction) {
    }
}

