/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.selection;

import io.quarkus.registry.catalog.selection.ExtensionOrigins;
import io.quarkus.registry.catalog.selection.OriginCombination;
import io.quarkus.registry.catalog.selection.OriginSelector;
import io.quarkus.registry.catalog.selection.OriginWithPreference;
import java.util.ArrayList;
import java.util.List;

public class AllCombinationsOriginSelector
implements OriginSelector {
    private final List<ExtensionOrigins> extOrigins;
    private final List<OriginCombination> completeCombinations = new ArrayList<OriginCombination>();
    private int highestRegistryPreference;

    public AllCombinationsOriginSelector(List<ExtensionOrigins> extOrigins) {
        this.extOrigins = extOrigins;
    }

    @Override
    public OriginCombination calculateRecommendedCombination() {
        this.calculateCompatibleCombinations();
        return this.getRecommendedCombination();
    }

    public void calculateCompatibleCombinations() {
        if (this.extOrigins.isEmpty()) {
            return;
        }
        this.select(0, new OriginCombination());
    }

    public OriginCombination getRecommendedCombination() {
        if (this.completeCombinations.isEmpty()) {
            return null;
        }
        if (this.completeCombinations.size() == 1) {
            return this.completeCombinations.get(0);
        }
        double highestScore = 0.0;
        OriginCombination recommended = null;
        for (OriginCombination combination : this.completeCombinations) {
            double score = this.calculateScore(combination);
            if (!(score > highestScore)) continue;
            highestScore = score;
            recommended = combination;
        }
        return recommended;
    }

    private double calculateScore(OriginCombination s) {
        return OriginCombination.calculateScore(s, this.highestRegistryPreference, this.extOrigins.size());
    }

    private void select(int extIndex, OriginCombination combination) {
        if (extIndex >= this.extOrigins.size()) {
            throw new IllegalArgumentException("Extension index " + extIndex + " exceeded the total number of extensions " + this.extOrigins.size());
        }
        ExtensionOrigins eo = this.extOrigins.get(extIndex);
        for (OriginWithPreference o : eo.getOrigins()) {
            this.highestRegistryPreference = Math.max(this.highestRegistryPreference, o.getPreference().registryPreference);
            OriginCombination augmentedCombination = combination.add(eo.getExtensionKey(), o);
            if (augmentedCombination == null) continue;
            if (this.extOrigins.size() == augmentedCombination.size()) {
                this.completeCombinations.add(augmentedCombination);
                continue;
            }
            if (extIndex + 1 == this.extOrigins.size()) {
                return;
            }
            this.select(extIndex + 1, augmentedCombination);
        }
    }
}

