/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog;

import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.registry.catalog.CatalogMapperHelper;
import io.quarkus.registry.catalog.ExtensionImpl;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.json.JsonBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;

public interface Extension {
    public static final String MD_SHORT_NAME = "short-name";
    public static final String MD_NESTED_CODESTART_NAME = "codestart.name";
    public static final String MD_NESTED_CODESTART_LANGUAGES = "codestart.languages";
    public static final String MD_NESTED_CODESTART_KIND = "codestart.kind";
    public static final String MD_NESTED_CODESTART_ARTIFACT = "codestart.artifact";
    public static final String MD_GUIDE = "guide";
    public static final String MD_KEYWORDS = "keywords";
    public static final String MD_UNLISTED = "unlisted";
    public static final String MD_CATEGORIES = "categories";
    public static final String MD_STATUS = "status";
    public static final String MD_BUILT_WITH_QUARKUS_CORE = "built-with-quarkus-core";

    public String getName();

    public String getDescription();

    public ArtifactCoords getArtifact();

    public List<ExtensionOrigin> getOrigins();

    default public boolean hasPlatformOrigin() {
        List<ExtensionOrigin> origins = this.getOrigins();
        if (origins == null || origins.isEmpty()) {
            return false;
        }
        for (ExtensionOrigin o : origins) {
            if (!o.isPlatform()) continue;
            return true;
        }
        return false;
    }

    public Map<String, Object> getMetadata();

    default public String managementKey() {
        ArtifactCoords artifact = this.getArtifact();
        return artifact.getGroupId() + ":" + artifact.getArtifactId();
    }

    default public Mutable mutable() {
        return new ExtensionImpl.Builder(this);
    }

    default public void persist(Path p) throws IOException {
        CatalogMapperHelper.serialize((Object)this, p);
    }

    public static Mutable builder() {
        return new ExtensionImpl.Builder();
    }

    public static Extension fromFile(Path path) throws IOException {
        return Extension.mutableFromFile(path).build();
    }

    public static Mutable mutableFromFile(Path path) throws IOException {
        Mutable mutable = CatalogMapperHelper.deserialize(path, ExtensionImpl.Builder.class);
        return mutable == null ? Extension.builder() : mutable;
    }

    public static interface Mutable
    extends Extension,
    JsonBuilder<Extension> {
        public Mutable setGroupId(String var1);

        public Mutable setArtifactId(String var1);

        public Mutable setVersion(String var1);

        public Mutable setName(String var1);

        public Mutable setDescription(String var1);

        public Mutable setMetadata(Map<String, Object> var1);

        public Mutable setMetadata(String var1, Object var2);

        public Mutable removeMetadata(String var1);

        public Mutable setArtifact(ArtifactCoords var1);

        public Mutable setOrigins(List<ExtensionOrigin> var1);

        @Override
        public Extension build();
    }
}

