/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.strategy;

import io.quarkus.devtools.codestarts.reader.CodestartFile;
import io.quarkus.devtools.codestarts.strategy.DefaultCodestartFileStrategyHandler;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;

final class ReplaceCodestartFileStrategyHandler
implements DefaultCodestartFileStrategyHandler {
    ReplaceCodestartFileStrategyHandler() {
    }

    @Override
    public String name() {
        return "replace";
    }

    @Override
    public void copyStaticFile(Path sourcePath, Path targetPath) throws IOException {
        Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
        Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void process(Path targetDirectory, String relativePath, List<CodestartFile> codestartFiles, Map<String, Object> data) throws IOException {
        this.checkNotEmptyCodestartFiles(codestartFiles);
        Path targetPath = targetDirectory.resolve(relativePath);
        this.checkTargetDoesNotExist(targetPath);
        this.createDirectories(targetPath);
        Files.write(targetPath, codestartFiles.get(codestartFiles.size() - 1).getContent().getBytes(), new OpenOption[0]);
    }
}

