/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.codestarts.utils;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;

public final class NestedMaps {
    private NestedMaps() {
    }

    public static <T> Optional<T> getValue(Map<String, Object> data, String path) {
        if (!path.contains(".")) {
            return Optional.ofNullable(data.get(path));
        }
        int index = path.indexOf(".");
        String key = path.substring(0, index);
        if (data.get(key) instanceof Map) {
            return NestedMaps.getValue((Map)data.get(key), path.substring(index + 1));
        }
        return Optional.empty();
    }

    public static <T> Map<String, T> deepMerge(Stream<Map<String, T>> mapStream) {
        HashMap out = new HashMap();
        mapStream.forEach(m -> NestedMaps.deepMerge(out, m));
        return out;
    }

    public static void deepMerge(Map left, Map right) {
        for (Object key : right.keySet()) {
            Object rightValue = right.get(key);
            Object leftValue = left.get(key);
            if (rightValue instanceof Map && leftValue instanceof Map) {
                NestedMaps.deepMerge((Map)leftValue, (Map)rightValue);
                continue;
            }
            if (rightValue instanceof Collection && leftValue instanceof Collection) {
                LinkedHashSet c = new LinkedHashSet();
                c.addAll((Collection)leftValue);
                c.addAll((Collection)rightValue);
                left.put(key, c);
                continue;
            }
            left.put(key, rightValue);
        }
    }

    public static Map<String, Object> unflatten(Map<String, Object> flattened) {
        HashMap<String, Object> unflattened = new HashMap<String, Object>();
        for (Map.Entry<String, Object> entry : flattened.entrySet()) {
            NestedMaps.doUnflatten(unflattened, entry.getKey(), entry.getValue());
        }
        return unflattened;
    }

    private static void doUnflatten(Map<String, Object> current, String key, Object originalValue) {
        String[] parts = key.split("\\.");
        for (int i = 0; i < parts.length; ++i) {
            String part = parts[i];
            if (i == parts.length - 1) {
                if (current.containsKey(part)) {
                    throw new IllegalStateException("Conflicting data types for key '" + key + "'");
                }
                current.put(part, originalValue);
                return;
            }
            Object value = current.get(part);
            if (value == null) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                current.put(part, map);
                current = map;
                continue;
            }
            if (value instanceof Map) {
                current = (HashMap<String, Object>)value;
                continue;
            }
            throw new IllegalStateException("Conflicting data types for key '" + key + "'");
        }
    }
}

