/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.oracle.deployment;

import io.quarkus.datasource.common.runtime.DataSourceUtil;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProviderBuildItem;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.DevServicesComposeProjectBuildItem;
import io.quarkus.deployment.builditem.DevServicesSharedNetworkBuildItem;
import io.quarkus.deployment.dev.devservices.DevServicesConfig;
import io.quarkus.devservices.common.ComposeLocator;
import io.quarkus.devservices.common.ConfigureUtil;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.ContainerShutdownCloseable;
import io.quarkus.devservices.common.JBossLoggingConsumer;
import io.quarkus.devservices.common.Labels;
import io.quarkus.devservices.common.Volumes;
import io.quarkus.devservices.oracle.deployment.OracleDatasourceServiceConfigurator;
import io.quarkus.runtime.LaunchMode;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.OracleContainer;
import org.testcontainers.utility.DockerImageName;

public class OracleDevServicesProcessor {
    private static final Logger LOG = Logger.getLogger(OracleDevServicesProcessor.class);
    public static final String ORIGINAL_IMAGE_NAME = "gvenzl/oracle-xe";
    public static final int PORT = 1521;
    private static final OracleDatasourceServiceConfigurator configurator = new OracleDatasourceServiceConfigurator();

    @BuildStep
    DevServicesDatasourceProviderBuildItem setupOracle(final List<DevServicesSharedNetworkBuildItem> devServicesSharedNetworkBuildItem, final DevServicesComposeProjectBuildItem composeProjectBuildItem, final DevServicesConfig devServicesConfig) {
        return new DevServicesDatasourceProviderBuildItem("oracle", new DevServicesDatasourceProvider(){

            public DevServicesDatasourceProvider.RunningDevServicesDatasource startDatabase(Optional<String> username, Optional<String> password, String datasourceName, DevServicesDatasourceContainerConfig containerConfig, LaunchMode launchMode, Optional<Duration> startupTimeout) {
                boolean useSharedNetwork = DevServicesSharedNetworkBuildItem.isSharedNetworkRequired((DevServicesConfig)devServicesConfig, (List)devServicesSharedNetworkBuildItem);
                String effectiveUsername = containerConfig.getUsername().orElse(username.orElse("quarkus"));
                String effectivePassword = containerConfig.getPassword().orElse(password.orElse("quarkus"));
                String effectiveDbName = containerConfig.getDbName().orElse(DataSourceUtil.isDefault((String)datasourceName) ? "quarkus" : datasourceName);
                Supplier<DevServicesDatasourceProvider.RunningDevServicesDatasource> startService = () -> {
                    QuarkusOracleServerContainer container = new QuarkusOracleServerContainer(containerConfig.getImageName(), containerConfig.getFixedExposedPort(), composeProjectBuildItem.getDefaultNetworkId(), useSharedNetwork);
                    startupTimeout.ifPresent(arg_0 -> ((QuarkusOracleServerContainer)container).withStartupTimeout(arg_0));
                    container.withUsername(effectiveUsername).withPassword(effectivePassword).withDatabaseName(effectiveDbName).withReuse(containerConfig.isReuse());
                    Labels.addDataSourceLabel((GenericContainer)container, (String)datasourceName);
                    Volumes.addVolumes((GenericContainer)container, (Map)containerConfig.getVolumes());
                    container.withEnv(containerConfig.getContainerEnv());
                    container.withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withNanoCPUs(Long.valueOf(2000000000L)));
                    containerConfig.getAdditionalJdbcUrlProperties().forEach((arg_0, arg_1) -> ((QuarkusOracleServerContainer)container).withUrlParam(arg_0, arg_1));
                    containerConfig.getCommand().ifPresent(arg_0 -> ((QuarkusOracleServerContainer)container).setCommand(arg_0));
                    containerConfig.getInitScriptPath().ifPresent(arg_0 -> ((QuarkusOracleServerContainer)container).withInitScripts(arg_0));
                    if (containerConfig.isShowLogs()) {
                        container.withLogConsumer((Consumer)new JBossLoggingConsumer(LOG));
                    }
                    container.start();
                    LOG.info((Object)"Dev Services for Oracle started.");
                    return new DevServicesDatasourceProvider.RunningDevServicesDatasource(container.getContainerId(), container.getEffectiveJdbcUrl(), container.getReactiveUrl(), container.getUsername(), container.getPassword(), (Closeable)new ContainerShutdownCloseable((GenericContainer)container, "Oracle"));
                };
                List<String> images = List.of(containerConfig.getImageName().orElseGet(() -> ConfigureUtil.getDefaultImageNameFor((String)"oracle")), "oracle");
                return ComposeLocator.locateContainer((DevServicesComposeProjectBuildItem)composeProjectBuildItem, images, (int)1521, (LaunchMode)launchMode, (boolean)useSharedNetwork).map(containerAddress -> configurator.composeRunningService((ContainerAddress)containerAddress, containerConfig)).orElseGet(startService);
            }
        });
    }

    private static class QuarkusOracleServerContainer
    extends OracleContainer {
        private final OptionalInt fixedExposedPort;
        private final boolean useSharedNetwork;
        private final String hostName;

        public QuarkusOracleServerContainer(Optional<String> imageName, OptionalInt fixedExposedPort, String defaultNetworkId, boolean useSharedNetwork) {
            super(DockerImageName.parse((String)imageName.orElseGet(() -> ConfigureUtil.getDefaultImageNameFor((String)"oracle"))).asCompatibleSubstituteFor(OracleDevServicesProcessor.ORIGINAL_IMAGE_NAME));
            this.fixedExposedPort = fixedExposedPort;
            this.useSharedNetwork = useSharedNetwork;
            this.hostName = ConfigureUtil.configureNetwork((GenericContainer)this, (String)defaultNetworkId, (boolean)useSharedNetwork, (String)"oracle");
        }

        protected void configure() {
            super.configure();
            if (this.useSharedNetwork) {
                return;
            }
            if (this.fixedExposedPort.isPresent()) {
                this.addFixedExposedPort(this.fixedExposedPort.getAsInt(), 1521);
            } else {
                this.addExposedPort(1521);
            }
        }

        public String getEffectiveJdbcUrl() {
            if (this.useSharedNetwork) {
                return "jdbc:oracle:thin:@" + this.hostName + ":1521/" + this.getDatabaseName();
            }
            return super.getJdbcUrl();
        }

        public String getReactiveUrl() {
            return this.getEffectiveJdbcUrl().replaceFirst("jdbc:", "vertx-reactive:");
        }
    }
}

