/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.mysql.deployment;

import io.quarkus.datasource.deployment.spi.DevServicesDatasourceContainerConfig;
import io.quarkus.datasource.deployment.spi.DevServicesDatasourceProvider;
import io.quarkus.deployment.dev.devservices.RunningContainer;
import io.quarkus.devservices.common.ContainerAddress;
import io.quarkus.devservices.common.DatasourceServiceConfigurator;

public class MySQLDatasourceServiceConfigurator
implements DatasourceServiceConfigurator {
    private static final String[] USERNAME_ENVS = new String[]{"MYSQL_USER"};
    private static final String[] PASSWORD_ENVS = new String[]{"MYSQL_PASSWORD"};
    private static final String[] DATABASE_ENVS = new String[]{"MYSQL_DATABASE"};

    public DevServicesDatasourceProvider.RunningDevServicesDatasource composeRunningService(ContainerAddress containerAddress, DevServicesDatasourceContainerConfig containerConfig) {
        RunningContainer container = containerAddress.getRunningContainer();
        String effectiveDbName = containerConfig.getDbName().orElse("quarkus");
        String effectiveUsername = containerConfig.getDbName().orElse("quarkus");
        String effectivePassword = containerConfig.getDbName().orElse("quarkus");
        String jdbcUrl = this.getJdbcUrl(containerAddress, container.tryGetEnv(DATABASE_ENVS).orElse(effectiveDbName));
        String reactiveUrl = this.getReactiveUrl(jdbcUrl);
        return new DevServicesDatasourceProvider.RunningDevServicesDatasource(containerAddress.getId(), jdbcUrl, reactiveUrl, container.tryGetEnv(USERNAME_ENVS).orElse(effectiveUsername), container.tryGetEnv(PASSWORD_ENVS).orElse(effectivePassword), null);
    }

    public String getJdbcPrefix() {
        return "mysql";
    }
}

