/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.keycloak;

import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.devservices.keycloak.KeycloakDevServicesConfigurator;
import io.quarkus.devservices.keycloak.KeycloakDevServicesProcessor;
import io.quarkus.runtime.configuration.ConfigUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.keycloak.representations.idm.RealmRepresentation;

public final class KeycloakDevServicesRequiredBuildItem
extends MultiBuildItem {
    private static final Logger LOG = Logger.getLogger(KeycloakDevServicesProcessor.class);
    public static final String OIDC_AUTH_SERVER_URL_CONFIG_KEY = "quarkus.oidc.auth-server-url";
    private static final String OIDC_PROVIDER_CONFIG_KEY = "quarkus.oidc.provider";
    private final KeycloakDevServicesConfigurator devServicesConfigurator;
    private final String authServerUrl;

    private KeycloakDevServicesRequiredBuildItem(KeycloakDevServicesConfigurator devServicesConfigurator, String authServerUrl) {
        this.devServicesConfigurator = Objects.requireNonNull(devServicesConfigurator);
        this.authServerUrl = Objects.requireNonNull(authServerUrl);
    }

    String getAuthServerUrl() {
        return this.authServerUrl;
    }

    public static KeycloakDevServicesRequiredBuildItem of(KeycloakDevServicesConfigurator devServicesConfigurator, String authServerUrl, String ... additionalDontStartConfigProperties) {
        HashSet<String> dontStartConfigProperties = new HashSet<String>(Arrays.asList(additionalDontStartConfigProperties));
        dontStartConfigProperties.add(authServerUrl);
        dontStartConfigProperties.add(OIDC_AUTH_SERVER_URL_CONFIG_KEY);
        dontStartConfigProperties.add(OIDC_PROVIDER_CONFIG_KEY);
        return KeycloakDevServicesRequiredBuildItem.of(devServicesConfigurator, authServerUrl, dontStartConfigProperties);
    }

    private static KeycloakDevServicesRequiredBuildItem of(KeycloakDevServicesConfigurator devServicesConfigurator, String authServerUrl, Set<String> dontStartConfigProperties) {
        if (KeycloakDevServicesRequiredBuildItem.shouldStartDevService(dontStartConfigProperties)) {
            return new KeycloakDevServicesRequiredBuildItem(devServicesConfigurator, authServerUrl);
        }
        return null;
    }

    static KeycloakDevServicesConfigurator getDevServicesConfigurator(final List<KeycloakDevServicesRequiredBuildItem> items) {
        return new KeycloakDevServicesConfigurator(){

            @Override
            public Map<String, String> createProperties(KeycloakDevServicesConfigurator.ConfigPropertiesContext context) {
                return items.stream().map(i -> i.devServicesConfigurator).map(producer -> producer.createProperties(context)).map(Map::entrySet).flatMap(Collection::stream).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }

            @Override
            public void customizeDefaultRealm(RealmRepresentation realmRepresentation) {
                items.stream().map(i -> i.devServicesConfigurator).forEach(i -> i.customizeDefaultRealm(realmRepresentation));
            }
        };
    }

    private static boolean shouldStartDevService(Set<String> dontStartConfigProperties) {
        return dontStartConfigProperties.stream().allMatch(KeycloakDevServicesRequiredBuildItem::shouldStartDevService);
    }

    private static boolean shouldStartDevService(String dontStartConfigProperty) {
        if (ConfigUtils.isPropertyNonEmpty((String)dontStartConfigProperty)) {
            LOG.debugf("Not starting Dev Services for Keycloak as '%s' has been provided", (Object)dontStartConfigProperty);
            return false;
        }
        return true;
    }
}

