/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.keycloak;

import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.MemorySize;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;

@ConfigMapping(prefix="quarkus.keycloak.devservices")
@ConfigRoot
public interface KeycloakDevServicesConfig {
    @WithDefault(value="true")
    public boolean enabled();

    @WithDefault(value="quay.io/keycloak/keycloak:26.1.3")
    public String imageName();

    public Optional<Boolean> keycloakXImage();

    @WithDefault(value="true")
    public boolean shared();

    @WithDefault(value="keycloak")
    public String serviceName();

    public Optional<List<String>> realmPath();

    @ConfigDocMapKey(value="alias-name")
    public Map<String, String> resourceAliases();

    @ConfigDocMapKey(value="resource-name")
    public Map<String, String> resourceMappings();

    public Optional<String> javaOpts();

    @WithDefault(value="false")
    public boolean showLogs();

    public Optional<String> startCommand();

    public Optional<Set<String>> features();

    public Optional<String> realmName();

    @WithDefault(value="true")
    public boolean createRealm();

    @WithDefault(value="true")
    public boolean createClient();

    @WithDefault(value="false")
    public boolean startWithDisabledTenant();

    public Map<String, String> users();

    @ConfigDocMapKey(value="role-name")
    public Map<String, List<String>> roles();

    public OptionalInt port();

    @ConfigDocMapKey(value="environment-variable-name")
    public Map<String, String> containerEnv();

    @WithDefault(value="1250M")
    public MemorySize containerMemoryLimit();

    @WithDefault(value="4S")
    public Duration webClientTimeout();
}

