/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.common;

import com.github.dockerjava.api.command.CreateNetworkCmd;
import io.quarkus.devservices.crossclassloader.runtime.RunningDevServicesRegistry;
import io.quarkus.runtime.LaunchMode;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.Base58;

public final class ConfigureUtil {
    private static final Map<String, Properties> DEVSERVICES_PROPS = new ConcurrentHashMap<String, Properties>();

    private ConfigureUtil() {
    }

    public static String configureNetwork(GenericContainer<?> container, String defaultNetworkId, boolean useSharedNetwork, String hostNamePrefix) {
        if (defaultNetworkId != null) {
            container.setNetworkMode(defaultNetworkId);
            return ConfigureUtil.setGeneratedHostname(container, hostNamePrefix);
        }
        if (useSharedNetwork) {
            return ConfigureUtil.configureSharedNetwork(container, hostNamePrefix);
        }
        return container.getHost();
    }

    public static boolean shouldConfigureSharedServiceLabel(LaunchMode launchMode) {
        return launchMode == LaunchMode.DEVELOPMENT;
    }

    public static <T extends GenericContainer<T>> T configureSharedServiceLabel(T container, LaunchMode launchMode, String serviceLabel, String serviceName) {
        if (ConfigureUtil.shouldConfigureSharedServiceLabel(launchMode)) {
            return (T)container.withLabel(serviceLabel, serviceName);
        }
        return container;
    }

    public static void configureLabels(GenericContainer<?> container, LaunchMode launchMode) {
        container.withLabel("io.quarkus.devservice.process-uuid", RunningDevServicesRegistry.APPLICATION_UUID);
        container.withLabel("io.quarkus.devservice.launch-mode", launchMode.toString());
    }

    public static String configureSharedNetwork(GenericContainer<?> container, String hostNamePrefix) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        if (tccl.getName().contains("Deployment")) {
            try {
                Class<?> networkClass = tccl.getParent().loadClass("org.testcontainers.containers.Network");
                Object sharedNetwork = networkClass.getField("SHARED").get(null);
                Consumer<CreateNetworkCmd> addDevservicesLabel = cmd -> cmd.withLabels(Map.of("quarkus.devservices.network", "shared"));
                Field createNetworkCmdModifiersField = sharedNetwork.getClass().getSuperclass().getDeclaredField("createNetworkCmdModifiers");
                createNetworkCmdModifiersField.setAccessible(true);
                createNetworkCmdModifiersField.set(sharedNetwork, Set.of(addDevservicesLabel));
                container.setNetwork((Network)sharedNetwork);
            }
            catch (Exception e) {
                throw new IllegalStateException("Unable to obtain SHARED network from testcontainers", e);
            }
        } else {
            container.setNetwork(Network.SHARED);
        }
        return ConfigureUtil.setGeneratedHostname(container, hostNamePrefix);
    }

    public static String setGeneratedHostname(GenericContainer<?> container, String hostNamePrefix) {
        String hostName = (hostNamePrefix + "-" + Base58.randomString((int)5)).toLowerCase(Locale.ROOT);
        container.setNetworkAliases(new ArrayList<String>(List.of(hostName)));
        return hostName;
    }

    public static String getDefaultImageNameFor(String devserviceName) {
        String imageName = DEVSERVICES_PROPS.computeIfAbsent(devserviceName, ConfigureUtil::loadProperties).getProperty("default.image");
        if (imageName == null) {
            throw new IllegalArgumentException("No default.image configured for " + devserviceName);
        }
        return imageName;
    }

    private static Properties loadProperties(String devserviceName) {
        Properties properties;
        block9: {
            String fileName = devserviceName + "-devservice.properties";
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            try {
                if (in == null) {
                    throw new IllegalArgumentException(fileName + " not found on classpath");
                }
                Properties properties2 = new Properties();
                properties2.load(in);
                properties = properties2;
                if (in == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            in.close();
        }
        return properties;
    }
}

