/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.dev.console;

import io.quarkus.dev.console.QuarkusConsole;
import io.quarkus.dev.console.StatusLine;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BasicConsole
extends QuarkusConsole {
    private static final Logger log = Logger.getLogger(BasicConsole.class.getName());
    private static final ThreadLocal<Boolean> DISABLE_FILTER = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return false;
        }
    };
    final Consumer<String> output;
    final Supplier<Integer> input;
    final boolean inputSupport;
    final boolean color;
    volatile boolean readingLine;

    public BasicConsole(boolean color, boolean inputSupport, Consumer<String> output) {
        this(color, inputSupport, output, () -> {
            try {
                return System.in.read();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    public BasicConsole(boolean color, boolean inputSupport, Consumer<String> output, Supplier<Integer> inputProvider) {
        this.color = color;
        this.inputSupport = inputSupport;
        this.output = output;
        this.input = inputProvider;
        if (inputSupport) {
            Objects.requireNonNull(inputProvider);
            Thread t = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        while (true) {
                            int val;
                            if ((val = BasicConsole.this.input.get().intValue()) == -1) {
                                return;
                            }
                            if (BasicConsole.this.readingLine && val == 10) {
                                BasicConsole.this.readingLine = false;
                                continue;
                            }
                            Consumer handler = BasicConsole.this.inputHandler;
                            if (handler == null) continue;
                            handler.accept(new int[]{val});
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.SEVERE, "Failed to read user input", e);
                        return;
                    }
                }
            }, "Quarkus Terminal Reader");
            t.setDaemon(true);
            t.start();
        }
    }

    @Override
    public void doReadLine() {
        this.readingLine = true;
        this.output.accept(">");
    }

    @Override
    public StatusLine registerStatusLine(int priority) {
        return new StatusLine(){
            boolean closed;
            String old;

            @Override
            public void setMessage(String message) {
                if (this.closed) {
                    return;
                }
                if (message == null) {
                    return;
                }
                if (message.equals(this.old)) {
                    return;
                }
                this.old = message;
                DISABLE_FILTER.set(true);
                try {
                    System.out.println(message);
                }
                finally {
                    DISABLE_FILTER.set(false);
                }
            }

            @Override
            public void close() {
                this.closed = true;
            }
        };
    }

    @Override
    public void setPromptMessage(String prompt) {
        if (!this.inputSupport) {
            return;
        }
        if (prompt == null) {
            return;
        }
        DISABLE_FILTER.set(true);
        try {
            System.out.println(prompt);
        }
        finally {
            DISABLE_FILTER.set(false);
        }
    }

    @Override
    public void write(String s) {
        if (this.outputFilter != null && !this.outputFilter.test(s) && !DISABLE_FILTER.get().booleanValue()) {
            return;
        }
        if (!this.color) {
            this.output.accept(this.stripAnsiCodes(s));
        } else {
            this.output.accept(s);
        }
    }

    @Override
    public void write(byte[] buf, int off, int len) {
        this.write(new String(buf, off, len, StandardCharsets.UTF_8));
    }

    @Override
    public boolean isInputSupported() {
        return this.inputSupport;
    }
}

