/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigItem;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.ConfigUtils;
import io.quarkus.runtime.configuration.HyphenateEnumConverter;
import io.smallrye.config.Converters;
import io.smallrye.config.SmallRyeConfig;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.Converter;

public class ConfigInstantiator {
    private static Set<String> SUPPORTED_CLASS_NAME_SUFFIXES = Set.of("Config", "Configuration");
    private static final String QUARKUS_PROPERTY_PREFIX = "quarkus.";
    private static final Pattern SEGMENT_EXTRACTION_PATTERN = Pattern.compile("(\"[^\"]+\"|[^.\"]+).*");

    public static <T> T handleObject(Supplier<T> supplier) {
        T o = supplier.get();
        ConfigInstantiator.handleObject(o);
        return o;
    }

    public static void handleObject(Object o) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig();
        ConfigInstantiator.handleObject(o, config);
    }

    public static void handleObject(Object o, SmallRyeConfig config) {
        String name;
        String clsNameSuffix = ConfigInstantiator.getClassNameSuffix(o);
        if (clsNameSuffix == null) {
            return;
        }
        Class<?> cls = o.getClass();
        ConfigRoot configRoot = cls.getAnnotation(ConfigRoot.class);
        if (configRoot != null && !configRoot.name().equals("<<hyphenated element name>>")) {
            name = configRoot.name();
            if (name.startsWith("<<")) {
                throw new IllegalArgumentException("Found unsupported @ConfigRoot.name = " + name + " on " + String.valueOf(cls));
            }
        } else {
            name = ConfigInstantiator.dashify(cls.getSimpleName().substring(0, cls.getSimpleName().length() - clsNameSuffix.length()));
        }
        ConfigInstantiator.handleObject(QUARKUS_PROPERTY_PREFIX + name, o, config, ConfigInstantiator.gatherQuarkusPropertyNames(config));
    }

    private static List<String> gatherQuarkusPropertyNames(SmallRyeConfig config) {
        ArrayList<String> names = new ArrayList<String>(50);
        for (String name : config.getPropertyNames()) {
            if (!name.startsWith(QUARKUS_PROPERTY_PREFIX)) continue;
            names.add(name);
        }
        return names;
    }

    private static void handleObject(String prefix, Object o, SmallRyeConfig config, List<String> quarkusPropertyNames) {
        try {
            Class<?> cls = o.getClass();
            if (!ConfigInstantiator.isClassNameSuffixSupported(o)) {
                return;
            }
            for (Field field : cls.getDeclaredFields()) {
                if (field.isSynthetic() || Modifier.isFinal(field.getModifiers())) continue;
                field.setAccessible(true);
                ConfigItem configItem = field.getDeclaredAnnotation(ConfigItem.class);
                Class<?> fieldClass = field.getType();
                if (configItem == null || fieldClass.isAnnotationPresent(ConfigGroup.class)) {
                    Constructor<?> constructor = fieldClass.getConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    Object newInstance = constructor.newInstance(new Object[0]);
                    field.set(o, newInstance);
                    ConfigInstantiator.handleObject(prefix + "." + ConfigInstantiator.dashify(field.getName()), newInstance, config, quarkusPropertyNames);
                    continue;
                }
                String name = configItem.name();
                if (name.equals("<<hyphenated element name>>")) {
                    name = ConfigInstantiator.dashify(field.getName());
                } else if (name.equals("<<element name>>")) {
                    name = field.getName();
                }
                String fullName = prefix + "." + name;
                Type genericType = field.getGenericType();
                if (fieldClass == Map.class) {
                    field.set(o, ConfigInstantiator.handleMap(fullName, genericType, config, quarkusPropertyNames));
                    continue;
                }
                Converter<?> conv = ConfigInstantiator.getConverterFor(genericType, config);
                try {
                    Optional value = config.getOptionalValue(fullName, conv);
                    if (value.isPresent()) {
                        field.set(o, value.get());
                        continue;
                    }
                    if (configItem.defaultValue().equals("<<no default>>")) continue;
                    field.set(o, conv.convert(configItem.defaultValue()));
                }
                catch (NoSuchElementException noSuchElementException) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static Map<?, ?> handleMap(String fullName, Type genericType, SmallRyeConfig config, List<String> quarkusPropertyNames) throws ReflectiveOperationException {
        HashMap map = new HashMap();
        if (ConfigInstantiator.typeOfParameter(genericType, 0) != String.class) {
            return map;
        }
        HashSet<String> processedSegments = new HashSet<String>();
        for (String propertyName : quarkusPropertyNames) {
            Map<Object, Object> mapValue;
            String segment;
            Matcher matcher;
            String fullNameWithDot;
            String withoutPrefix = propertyName.replace(fullNameWithDot = fullName + ".", "");
            if (withoutPrefix.equals(propertyName) || !(matcher = SEGMENT_EXTRACTION_PATTERN.matcher(withoutPrefix)).find() || !processedSegments.add(segment = matcher.group(1))) continue;
            String mapKey = segment.replace("\"", "");
            String nextFullName = fullNameWithDot + segment;
            Type mapValueType = ConfigInstantiator.typeOfParameter(genericType, 1);
            if (mapValueType instanceof ParameterizedType && ((ParameterizedType)mapValueType).getRawType().equals(Map.class)) {
                mapValue = ConfigInstantiator.handleMap(nextFullName, mapValueType, config, quarkusPropertyNames);
            } else {
                Class mapValueClass;
                Class clazz = mapValueClass = mapValueType instanceof Class ? (Class)mapValueType : null;
                if (mapValueClass != null && mapValueClass.isAnnotationPresent(ConfigGroup.class)) {
                    Constructor constructor = mapValueClass.getConstructor(new Class[0]);
                    constructor.setAccessible(true);
                    mapValue = constructor.newInstance(new Object[0]);
                    ConfigInstantiator.handleObject(nextFullName, mapValue, config, quarkusPropertyNames);
                } else {
                    Converter<?> conv = ConfigInstantiator.getConverterFor(mapValueType, config);
                    mapValue = config.getOptionalValue(nextFullName, conv).orElse(null);
                }
            }
            map.put(mapKey, mapValue);
        }
        return map;
    }

    private static Converter<?> getConverterFor(Type type, SmallRyeConfig config) {
        Class<?> rawType = ConfigInstantiator.rawTypeOf(type);
        if (Enum.class.isAssignableFrom(rawType)) {
            return new HyphenateEnumConverter(rawType);
        }
        if (rawType == Optional.class) {
            return Converters.newOptionalConverter(ConfigInstantiator.getConverterFor(ConfigInstantiator.typeOfParameter(type, 0), config));
        }
        if (rawType == List.class) {
            return Converters.newCollectionConverter(ConfigInstantiator.getConverterFor(ConfigInstantiator.typeOfParameter(type, 0), config), ConfigUtils.listFactory());
        }
        if (rawType == Set.class) {
            return Converters.newCollectionConverter(ConfigInstantiator.getConverterFor(ConfigInstantiator.typeOfParameter(type, 0), config), ConfigUtils.setFactory());
        }
        return config.requireConverter(ConfigInstantiator.rawTypeOf(type));
    }

    private static Class<?> rawTypeOf(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return ConfigInstantiator.rawTypeOf(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            return Array.newInstance(ConfigInstantiator.rawTypeOf(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
        }
        throw new IllegalArgumentException("Type has no raw type class: " + String.valueOf(type));
    }

    static Type typeOfParameter(Type type, int paramIdx) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[paramIdx];
        }
        throw new IllegalArgumentException("Type is not parameterized: " + String.valueOf(type));
    }

    private static String dashify(String substring) {
        StringBuilder ret = new StringBuilder();
        char[] chars = substring.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            char c = chars[i];
            if (i != 0 && i != chars.length - 1 && c >= 'A' && c <= 'Z') {
                ret.append('-');
            }
            ret.append(Character.toLowerCase(c));
        }
        return ret.toString();
    }

    private static String getClassNameSuffix(Object o) {
        if (o == null) {
            return null;
        }
        String klassName = o.getClass().getName();
        for (String supportedSuffix : SUPPORTED_CLASS_NAME_SUFFIXES) {
            if (!klassName.endsWith(supportedSuffix)) continue;
            return supportedSuffix;
        }
        return null;
    }

    private static boolean isClassNameSuffixSupported(Object o) {
        if (o == null) {
            return false;
        }
        String klassName = o.getClass().getName();
        for (String supportedSuffix : SUPPORTED_CLASS_NAME_SUFFIXES) {
            if (!klassName.endsWith(supportedSuffix)) continue;
            return true;
        }
        return false;
    }
}

