/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.util;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class EnumerationUtil {
    public static <T> Enumeration<T> from(final Iterator<T> iterator) {
        Objects.requireNonNull(iterator);
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iterator.hasNext();
            }

            @Override
            public T nextElement() {
                return iterator.next();
            }
        };
    }

    public static <T> Enumeration<T> from(Spliterator<T> spliterator) {
        Objects.requireNonNull(spliterator);
        class Adapter
        implements Enumeration<T>,
        Consumer<T> {
            boolean valueReady;
            T nextElement;
            final /* synthetic */ Spliterator val$spliterator;

            Adapter(Spliterator spliterator) {
                this.val$spliterator = spliterator;
            }

            @Override
            public void accept(T t) {
                this.valueReady = true;
                this.nextElement = t;
            }

            @Override
            public boolean hasMoreElements() {
                if (!this.valueReady) {
                    this.val$spliterator.tryAdvance(this);
                }
                return this.valueReady;
            }

            @Override
            public T nextElement() {
                if (!this.valueReady && !this.hasMoreElements()) {
                    throw new NoSuchElementException();
                }
                this.valueReady = false;
                Object t = this.nextElement;
                this.nextElement = null;
                return t;
            }
        }
        return new Adapter(spliterator);
    }

    public static <T> Enumeration<T> from(Stream<T> stream) {
        return EnumerationUtil.from(stream.spliterator());
    }
}

