/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.logging;

import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigPhase;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.quarkus.runtime.configuration.CharsetConverter;
import io.quarkus.runtime.configuration.InetSocketAddressConverter;
import io.quarkus.runtime.configuration.MemorySize;
import io.quarkus.runtime.configuration.MemorySizeConverter;
import io.quarkus.runtime.logging.InheritableLevel;
import io.quarkus.runtime.logging.LevelConverter;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithConverter;
import io.smallrye.config.WithDefault;
import io.smallrye.config.WithName;
import io.smallrye.config.WithParentName;
import java.io.File;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.jboss.logmanager.handlers.AsyncHandler;
import org.jboss.logmanager.handlers.SocketHandler;
import org.jboss.logmanager.handlers.SyslogHandler;

@ConfigMapping(prefix="quarkus.log")
@ConfigRoot(phase=ConfigPhase.RUN_TIME)
public interface LogRuntimeConfig {
    @WithDefault(value="INFO")
    @WithConverter(value=LevelConverter.class)
    public Level level();

    @ConfigDocSection
    public ConsoleConfig console();

    @ConfigDocSection
    public FileConfig file();

    @ConfigDocSection
    public SyslogConfig syslog();

    @ConfigDocSection
    public SocketConfig socket();

    @WithName(value="category")
    @ConfigDocSection
    public Map<String, CategoryConfig> categories();

    @WithName(value="handler.console")
    @ConfigDocSection
    public Map<String, ConsoleConfig> consoleHandlers();

    @WithName(value="handler.file")
    @ConfigDocSection
    public Map<String, FileConfig> fileHandlers();

    @WithName(value="handler.syslog")
    @ConfigDocSection
    public Map<String, SyslogConfig> syslogHandlers();

    @WithName(value="handler.socket")
    @ConfigDocSection
    public Map<String, SocketConfig> socketHandlers();

    @WithName(value="filter")
    @ConfigDocSection
    public Map<String, CleanupFilterConfig> filters();

    public Optional<List<String>> handlers();

    public static interface AsyncConfig {
        @WithDefault(value="false")
        public boolean enable();

        @WithParentName
        @Deprecated(forRemoval=true, since="3.24")
        public Optional<Boolean> legacyEnable();

        @WithDefault(value="512")
        public int queueLength();

        @WithDefault(value="block")
        public AsyncHandler.OverflowAction overflow();
    }

    public static interface CleanupFilterConfig {
        @WithDefault(value="inherit")
        public List<String> ifStartsWith();

        @WithDefault(value="DEBUG")
        @WithConverter(value=LevelConverter.class)
        public Level targetLevel();
    }

    public static interface SocketConfig {
        @WithDefault(value="false")
        public boolean enable();

        @WithDefault(value="localhost:4560")
        @WithConverter(value=InetSocketAddressConverter.class)
        public InetSocketAddress endpoint();

        @WithDefault(value="tcp")
        public SocketHandler.Protocol protocol();

        @WithDefault(value="false")
        public boolean blockOnReconnect();

        @WithDefault(value="%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c{3.}] (%t) %s%e%n")
        public String format();

        @WithDefault(value="ALL")
        public Level level();

        public Optional<String> filter();

        public AsyncConfig async();
    }

    public static interface SyslogConfig {
        @WithDefault(value="false")
        public boolean enable();

        @WithDefault(value="localhost:514")
        @WithConverter(value=InetSocketAddressConverter.class)
        public InetSocketAddress endpoint();

        public Optional<String> appName();

        public Optional<String> hostname();

        @WithDefault(value="user-level")
        public SyslogHandler.Facility facility();

        @WithDefault(value="rfc5424")
        public SyslogHandler.SyslogType syslogType();

        @WithDefault(value="tcp")
        public SyslogHandler.Protocol protocol();

        @WithDefault(value="false")
        public boolean useCountingFraming();

        @WithDefault(value="true")
        public boolean truncate();

        @WithDefault(value="false")
        public boolean blockOnReconnect();

        @WithDefault(value="%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c{3.}] (%t) %s%e%n")
        public String format();

        @WithDefault(value="ALL")
        @WithConverter(value=LevelConverter.class)
        public Level level();

        public Optional<String> filter();

        public Optional<@WithConverter(value=MemorySizeConverter.class) MemorySize> maxLength();

        public AsyncConfig async();
    }

    public static interface ConsoleConfig {
        @WithDefault(value="true")
        public boolean enable();

        @WithDefault(value="false")
        public boolean stderr();

        @WithDefault(value="%d{yyyy-MM-dd HH:mm:ss,SSS} %-5p [%c{3.}] (%t) %s%e%n")
        public String format();

        @WithDefault(value="ALL")
        @WithConverter(value=LevelConverter.class)
        public Level level();

        @Deprecated
        public Optional<Boolean> color();

        @WithDefault(value="0")
        public int darken();

        public Optional<String> filter();

        public AsyncConfig async();
    }

    public static interface FileConfig {
        public static final String DEFAULT_LOG_FILE_NAME = "quarkus.log";

        @WithDefault(value="false")
        public boolean enable();

        @WithDefault(value="%d{yyyy-MM-dd HH:mm:ss,SSS} %h %N[%i] %-5p [%c{3.}] (%t) %s%e%n")
        public String format();

        @WithDefault(value="ALL")
        @WithConverter(value=LevelConverter.class)
        public Level level();

        @WithDefault(value="quarkus.log")
        public File path();

        public Optional<String> filter();

        public Optional<@WithConverter(value=CharsetConverter.class) Charset> encoding();

        public AsyncConfig async();

        public RotationConfig rotation();

        public static interface RotationConfig {
            @WithDefault(value="true")
            public boolean enabled();

            @WithDefault(value="10M")
            @WithConverter(value=MemorySizeConverter.class)
            public MemorySize maxFileSize();

            @WithDefault(value="5")
            public int maxBackupIndex();

            public Optional<String> fileSuffix();

            @WithDefault(value="true")
            public boolean rotateOnBoot();
        }
    }

    public static interface CategoryConfig {
        @WithDefault(value="inherit")
        public InheritableLevel level();

        public Optional<List<String>> handlers();

        @WithDefault(value="true")
        public boolean useParentHandlers();
    }
}

