/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.jar;

import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.JarBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarIgnoredResourceBuildItem;
import io.quarkus.deployment.pkg.builditem.UberJarMergedResourceBuildItem;
import io.quarkus.deployment.pkg.jar.AbstractJarBuilder;
import io.quarkus.deployment.pkg.jar.ArchiveCreator;
import io.quarkus.deployment.pkg.jar.ZipFileSystemArchiveCreator;
import io.quarkus.fs.util.ZipUtils;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.Dependency;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import io.quarkus.sbom.ApplicationComponent;
import io.quarkus.sbom.ApplicationManifestConfig;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;

public class UberJarBuilder
extends AbstractJarBuilder<JarBuildItem> {
    private static final Logger LOG = Logger.getLogger(UberJarBuilder.class);
    private static final Predicate<String> UBER_JAR_IGNORED_ENTRIES_PREDICATE = new IsEntryIgnoredForUberJarPredicate();
    private static final Predicate<String> UBER_JAR_CONCATENATED_ENTRIES_PREDICATE = new Predicate<String>(){

        @Override
        public boolean test(String path) {
            return "META-INF/io.netty.versions.properties".equals(path) || path.startsWith("META-INF/services/") && path.length() > 18 || "META-INF/sisu/javax.inject.Named".equals(path);
        }
    };
    private final List<UberJarMergedResourceBuildItem> mergedResources;
    private final List<UberJarIgnoredResourceBuildItem> ignoredResources;

    public UberJarBuilder(CurateOutcomeBuildItem curateOutcome, OutputTargetBuildItem outputTarget, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, MainClassBuildItem mainClass, ApplicationArchivesBuildItem applicationArchives, TransformedClassesBuildItem transformedClasses, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, Set<ArtifactKey> removedArtifactKeys, List<UberJarMergedResourceBuildItem> mergedResources, List<UberJarIgnoredResourceBuildItem> ignoredResources) {
        super(curateOutcome, outputTarget, applicationInfo, packageConfig, mainClass, applicationArchives, transformedClasses, generatedClasses, generatedResources, removedArtifactKeys);
        this.mergedResources = mergedResources;
        this.ignoredResources = ignoredResources;
    }

    @Override
    public JarBuildItem build() throws IOException {
        Path standardJar;
        Path tmpRunnerJar;
        Path runnerJar = this.outputTarget.getOutputDirectory().resolve(this.outputTarget.getBaseName() + this.packageConfig.computedRunnerSuffix() + ".jar");
        if (Files.exists(runnerJar, new LinkOption[0])) {
            tmpRunnerJar = this.outputTarget.getOutputDirectory().resolve(this.outputTarget.getBaseName() + this.packageConfig.computedRunnerSuffix() + ".tmp");
            Files.deleteIfExists(tmpRunnerJar);
        } else {
            tmpRunnerJar = runnerJar;
        }
        this.buildUberJar0(tmpRunnerJar);
        if (tmpRunnerJar != runnerJar) {
            Files.copy(tmpRunnerJar, runnerJar, StandardCopyOption.REPLACE_EXISTING);
            tmpRunnerJar.toFile().deleteOnExit();
        }
        Path originalJar = Files.exists(standardJar = this.outputTarget.getOutputDirectory().resolve(this.outputTarget.getOriginalBaseName() + ".jar"), new LinkOption[0]) ? standardJar : null;
        ResolvedDependency appArtifact = this.curateOutcome.getApplicationModel().getAppArtifact();
        String classifier = UberJarBuilder.suffixToClassifier(this.packageConfig.computedRunnerSuffix());
        if (classifier != null && !classifier.isEmpty()) {
            appArtifact = ((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)((ResolvedDependencyBuilder)ResolvedDependencyBuilder.newInstance().setGroupId(appArtifact.getGroupId())).setArtifactId(appArtifact.getArtifactId())).setClassifier(classifier)).setType(appArtifact.getType())).setVersion(appArtifact.getVersion())).setResolvedPaths(appArtifact.getResolvedPaths()).addDependencies(appArtifact.getDependencies()).setWorkspaceModule(appArtifact.getWorkspaceModule()).setFlags(appArtifact.getFlags())).build();
        }
        ApplicationManifestConfig manifestConfig = ApplicationManifestConfig.builder().setMainComponent(ApplicationComponent.builder().setPath(runnerJar).setResolvedDependency(appArtifact).build()).setRunnerPath(runnerJar).addComponents(this.curateOutcome.getApplicationModel().getDependencies()).build();
        return new JarBuildItem(runnerJar, originalJar, null, PackageConfig.JarConfig.JarType.UBER_JAR, UberJarBuilder.suffixToClassifier(this.packageConfig.computedRunnerSuffix()), manifestConfig);
    }

    private void buildUberJar0(Path runnerJar) throws IOException {
        try (ZipFileSystemArchiveCreator archiveCreator = new ZipFileSystemArchiveCreator(runnerJar, this.packageConfig.jar().compress(), this.packageConfig.outputTimestamp().orElse(null));){
            LOG.info((Object)("Building uber jar: " + String.valueOf(runnerJar)));
            HashMap seen = new HashMap();
            HashMap<String, Set<Dependency>> duplicateCatcher = new HashMap<String, Set<Dependency>>();
            HashMap<String, List<byte[]>> concatenatedEntries = new HashMap<String, List<byte[]>>();
            Set<String> mergeResourcePaths = this.mergedResources.stream().map(UberJarMergedResourceBuildItem::getPath).collect(Collectors.toSet());
            final HashSet ignoredEntries = new HashSet();
            this.packageConfig.jar().userConfiguredIgnoredEntries().ifPresent(ignoredEntries::addAll);
            this.ignoredResources.stream().map(UberJarIgnoredResourceBuildItem::getPath).forEach(ignoredEntries::add);
            Predicate<String> allIgnoredEntriesPredicate = new Predicate<String>(){

                @Override
                public boolean test(String path) {
                    return UBER_JAR_IGNORED_ENTRIES_PREDICATE.test(path) || ignoredEntries.contains(path);
                }
            };
            ResolvedDependency appArtifact = this.curateOutcome.getApplicationModel().getAppArtifact();
            UberJarBuilder.generateManifest(archiveCreator, "", this.packageConfig, appArtifact, this.mainClass.getClassName(), this.applicationInfo);
            for (ResolvedDependency appDep : this.curateOutcome.getApplicationModel().getRuntimeDependencies()) {
                if (!UberJarBuilder.includeAppDependency(appDep, this.outputTarget.getIncludedOptionalDependencies(), this.removedArtifactKeys)) continue;
                for (Path resolvedDep : appDep.getResolvedPaths()) {
                    HashSet<String> existingEntries = new HashSet<String>();
                    Set<String> transformedFilesByJar = this.transformedClasses.getTransformedFilesByJar().get(resolvedDep);
                    if (transformedFilesByJar != null) {
                        existingEntries.addAll(transformedFilesByJar);
                    }
                    this.generatedResources.stream().map(GeneratedResourceBuildItem::getName).forEach(existingEntries::add);
                    if (!Files.isDirectory(resolvedDep, new LinkOption[0])) {
                        FileSystem artifactFs = ZipUtils.newFileSystem((Path)resolvedDep);
                        try {
                            for (Path root : artifactFs.getRootDirectories()) {
                                this.walkFileDependencyForDependency(root, archiveCreator, duplicateCatcher, concatenatedEntries, allIgnoredEntriesPredicate, (Dependency)appDep, existingEntries, mergeResourcePaths);
                            }
                            continue;
                        }
                        finally {
                            if (artifactFs != null) {
                                artifactFs.close();
                            }
                            continue;
                        }
                    }
                    this.walkFileDependencyForDependency(resolvedDep, archiveCreator, duplicateCatcher, concatenatedEntries, allIgnoredEntriesPredicate, (Dependency)appDep, existingEntries, mergeResourcePaths);
                }
            }
            HashSet<Set> explained = new HashSet<Set>();
            for (Map.Entry entry : duplicateCatcher.entrySet()) {
                if (((Set)entry.getValue()).size() <= 1 || !explained.add((Set)entry.getValue())) continue;
                LOG.warn((Object)("Dependencies with duplicate files detected. The dependencies " + String.valueOf(entry.getValue()) + " contain duplicate files, e.g. " + (String)entry.getKey()));
            }
            this.copyCommonContent(archiveCreator, concatenatedEntries, allIgnoredEntriesPredicate);
            if (archiveCreator.isMultiVersion()) {
                LOG.debug((Object)"uber jar will be marked as multi-release jar");
                archiveCreator.makeMultiVersion();
            }
        }
        runnerJar.toFile().setReadable(true, false);
    }

    private void walkFileDependencyForDependency(final Path root, final ArchiveCreator archiveCreator, final Map<String, Set<Dependency>> duplicateCatcher, final Map<String, List<byte[]>> concatenatedEntries, final Predicate<String> ignoredEntriesPredicate, final Dependency appDep, final Set<String> existingEntries, final Set<String> mergeResourcePaths) throws IOException {
        final Path metaInfDir = root.resolve("META-INF");
        Files.walkFileTree(root, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                String relativePath = AbstractJarBuilder.toUri(root.relativize(dir));
                if (!relativePath.isEmpty()) {
                    archiveCreator.addDirectory(relativePath);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                String relativePath = AbstractJarBuilder.toUri(root.relativize(file));
                if (UberJarBuilder.isBlockOrSF(relativePath) && file.relativize(metaInfDir).getNameCount() == 1) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("Signature file " + String.valueOf(file.toAbsolutePath()) + " from app dependency " + String.valueOf(appDep) + " will not be included in uberjar"));
                    }
                    return FileVisitResult.CONTINUE;
                }
                if (!existingEntries.contains(relativePath)) {
                    if (UBER_JAR_CONCATENATED_ENTRIES_PREDICATE.test(relativePath) || mergeResourcePaths.contains(relativePath)) {
                        concatenatedEntries.computeIfAbsent(relativePath, u -> new ArrayList()).add(Files.readAllBytes(file));
                        return FileVisitResult.CONTINUE;
                    }
                    if (!ignoredEntriesPredicate.test(relativePath)) {
                        duplicateCatcher.computeIfAbsent(relativePath, a -> new HashSet()).add(appDep);
                        archiveCreator.addFileIfNotExists(file, relativePath, appDep.toString());
                    }
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    private static boolean isBlockOrSF(String s) {
        if (s == null) {
            return false;
        }
        return s.endsWith(".SF") || s.endsWith(".DSA") || s.endsWith(".RSA") || s.endsWith(".EC");
    }

    private static class IsEntryIgnoredForUberJarPredicate
    implements Predicate<String> {
        private static final Set<String> UBER_JAR_IGNORED_ENTRIES = Set.of("META-INF/INDEX.LIST", "META-INF/MANIFEST.MF", "module-info.class", "META-INF/LICENSE", "META-INF/LICENSE.txt", "META-INF/LICENSE.md", "META-INF/LGPL-3.0.txt", "META-INF/ASL-2.0.txt", "META-INF/NOTICE", "META-INF/NOTICE.txt", "META-INF/NOTICE.md", "META-INF/README", "META-INF/README.txt", "META-INF/README.md", "META-INF/DEPENDENCIES", "META-INF/DEPENDENCIES.txt", "META-INF/beans.xml", "META-INF/quarkus-config-roots.list", "META-INF/quarkus-javadoc.properties", "META-INF/quarkus-extension.properties", "META-INF/quarkus-extension.json", "META-INF/quarkus-extension.yaml", "META-INF/quarkus-deployment-dependency.graph", "META-INF/jandex.idx", "META-INF/panache-archive.marker", "META-INF/build.metadata", "META-INF/quarkus-config-doc/quarkus-config-javadoc.json", "LICENSE");

        private IsEntryIgnoredForUberJarPredicate() {
        }

        @Override
        public boolean test(String path) {
            return UBER_JAR_IGNORED_ENTRIES.contains(path) || path.endsWith("module-info.class");
        }
    }
}

