/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.jar;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.commons.classloading.ClassLoaderHelper;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.jar.ArchiveCreator;
import io.quarkus.deployment.pkg.jar.JarBuilder;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jboss.logging.Logger;

public abstract class AbstractJarBuilder<T extends BuildItem>
implements JarBuilder<T> {
    private static final Logger LOG = Logger.getLogger(AbstractJarBuilder.class);
    protected final CurateOutcomeBuildItem curateOutcome;
    protected final OutputTargetBuildItem outputTarget;
    protected final ApplicationInfoBuildItem applicationInfo;
    protected final PackageConfig packageConfig;
    protected final MainClassBuildItem mainClass;
    protected final ApplicationArchivesBuildItem applicationArchives;
    protected final TransformedClassesBuildItem transformedClasses;
    protected final List<GeneratedClassBuildItem> generatedClasses;
    protected final List<GeneratedResourceBuildItem> generatedResources;
    protected final Set<ArtifactKey> removedArtifactKeys;

    public AbstractJarBuilder(CurateOutcomeBuildItem curateOutcome, OutputTargetBuildItem outputTarget, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, MainClassBuildItem mainClass, ApplicationArchivesBuildItem applicationArchives, TransformedClassesBuildItem transformedClasses, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, Set<ArtifactKey> removedArtifactKeys) {
        this.curateOutcome = curateOutcome;
        this.outputTarget = outputTarget;
        this.applicationInfo = applicationInfo;
        this.packageConfig = packageConfig;
        this.mainClass = mainClass;
        this.applicationArchives = applicationArchives;
        this.transformedClasses = transformedClasses;
        this.generatedClasses = generatedClasses;
        this.generatedResources = generatedResources;
        this.removedArtifactKeys = removedArtifactKeys;
    }

    protected static void copyFiles(ApplicationArchive archive, ArchiveCreator archiveCreator, final Map<String, List<byte[]>> services, final Predicate<String> ignoredEntriesPredicate) throws IOException {
        try {
            final TreeMap pathsToCopy = new TreeMap();
            archive.accept(tree -> tree.walk(new PathVisitor(){

                public void visitPath(PathVisit visit) {
                    Path file = visit.getRoot().relativize(visit.getPath());
                    String relativePath = AbstractJarBuilder.toUri(file);
                    if (relativePath.isEmpty() || ignoredEntriesPredicate.test(relativePath)) {
                        return;
                    }
                    if (Files.isDirectory(visit.getPath(), new LinkOption[0])) {
                        pathsToCopy.put(relativePath, visit.getPath());
                    } else if (relativePath.startsWith("META-INF/services/") && relativePath.length() > 18 && services != null) {
                        byte[] content;
                        try {
                            content = Files.readAllBytes(visit.getPath());
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                        services.computeIfAbsent(relativePath, u -> new ArrayList()).add(content);
                    } else if (!relativePath.equals("META-INF/INDEX.LIST")) {
                        pathsToCopy.put(relativePath, visit.getPath());
                    }
                }
            }));
            for (Map.Entry pathEntry : pathsToCopy.entrySet()) {
                if (Files.isDirectory((Path)pathEntry.getValue(), new LinkOption[0])) {
                    archiveCreator.addDirectory((String)pathEntry.getKey());
                    continue;
                }
                archiveCreator.addFileIfNotExists((Path)pathEntry.getValue(), (String)pathEntry.getKey());
            }
        }
        catch (RuntimeException re) {
            Throwable cause = re.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw re;
        }
    }

    protected void copyCommonContent(ArchiveCreator archiveCreator, Map<String, List<byte[]>> concatenatedEntries, Predicate<String> ignoredEntriesPredicate) throws IOException {
        for (Set<TransformedClassesBuildItem.TransformedClass> set : this.transformedClasses.getTransformedClassesByJar().values()) {
            for (TransformedClassesBuildItem.TransformedClass i : set) {
                if (i.getData() == null) continue;
                archiveCreator.addFile(i.getData(), i.getFileName());
            }
        }
        for (GeneratedClassBuildItem generatedClassBuildItem : this.generatedClasses) {
            String fileName = ClassLoaderHelper.fromClassNameToResourceName((String)generatedClassBuildItem.internalName());
            archiveCreator.addFileIfNotExists(generatedClassBuildItem.getClassData(), fileName, "Current application");
        }
        for (GeneratedResourceBuildItem generatedResourceBuildItem : this.generatedResources) {
            if (ignoredEntriesPredicate.test(generatedResourceBuildItem.getName())) continue;
            if (generatedResourceBuildItem.getName().startsWith("META-INF/services/")) {
                concatenatedEntries.computeIfAbsent(generatedResourceBuildItem.getName(), u -> new ArrayList()).add(generatedResourceBuildItem.getData());
                continue;
            }
            archiveCreator.addFileIfNotExists(generatedResourceBuildItem.getData(), generatedResourceBuildItem.getName(), "Current application");
        }
        AbstractJarBuilder.copyFiles(this.applicationArchives.getRootArchive(), archiveCreator, concatenatedEntries, ignoredEntriesPredicate);
        for (Map.Entry entry : concatenatedEntries.entrySet()) {
            archiveCreator.addFile((List)entry.getValue(), (String)entry.getKey());
        }
    }

    protected static void generateManifest(ArchiveCreator archiveCreator, String classPath, PackageConfig config, ResolvedDependency appArtifact, String mainClassName, ApplicationInfoBuildItem applicationInfo) throws IOException {
        String existingMainClass;
        Manifest manifest = new Manifest();
        Attributes attributes = manifest.getMainAttributes();
        attributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        attributes.put(new Attributes.Name("Add-Opens"), "java.base/java.lang");
        for (Map.Entry<String, String> attribute : config.jar().manifest().attributes().entrySet()) {
            attributes.putValue(attribute.getKey(), attribute.getValue());
        }
        if (attributes.containsKey(Attributes.Name.CLASS_PATH)) {
            LOG.warn((Object)"A CLASS_PATH entry was already defined in your MANIFEST.MF or using the property quarkus.package.jar.manifest.attributes.\"Class-Path\". Quarkus has overwritten this existing entry.");
        }
        attributes.put(Attributes.Name.CLASS_PATH, classPath);
        if (attributes.containsKey(Attributes.Name.MAIN_CLASS) && !mainClassName.equals(existingMainClass = attributes.getValue(Attributes.Name.MAIN_CLASS))) {
            LOG.warn((Object)"A MAIN_CLASS entry was already defined in your MANIFEST.MF or using the property quarkus.package.jar.manifest.attributes.\"Main-Class\". Quarkus has overwritten your existing entry.");
        }
        attributes.put(Attributes.Name.MAIN_CLASS, mainClassName);
        if (config.jar().manifest().addImplementationEntries() && !attributes.containsKey(Attributes.Name.IMPLEMENTATION_TITLE)) {
            String name = "<<unset>>".equals(applicationInfo.getName()) ? appArtifact.getArtifactId() : applicationInfo.getName();
            attributes.put(Attributes.Name.IMPLEMENTATION_TITLE, name);
        }
        if (config.jar().manifest().addImplementationEntries() && !attributes.containsKey(Attributes.Name.IMPLEMENTATION_VERSION)) {
            String version = "<<unset>>".equals(applicationInfo.getVersion()) ? appArtifact.getVersion() : applicationInfo.getVersion();
            attributes.put(Attributes.Name.IMPLEMENTATION_VERSION, version);
        }
        for (String sectionName : config.jar().manifest().sections().keySet()) {
            for (Map.Entry<String, String> entry : config.jar().manifest().sections().get(sectionName).entrySet()) {
                Attributes attribs = manifest.getEntries().computeIfAbsent(sectionName, k -> new Attributes());
                attribs.putValue(entry.getKey(), entry.getValue());
            }
        }
        archiveCreator.addManifest(manifest);
    }

    protected static boolean includeAppDependency(ResolvedDependency appDep, Optional<Set<ArtifactKey>> optionalDependencies, Set<ArtifactKey> removedArtifacts) {
        if (!appDep.isJar()) {
            return false;
        }
        if (appDep.isOptional()) {
            return optionalDependencies.map(appArtifactKeys -> appArtifactKeys.contains(appDep.getKey())).orElse(true);
        }
        return !removedArtifacts.contains(appDep.getKey());
    }

    protected static String suffixToClassifier(String suffix) {
        return suffix.startsWith("-") ? suffix.substring(1) : suffix;
    }

    protected static String toUri(Path path) {
        if (path.isAbsolute()) {
            return path.toUri().getPath();
        }
        if (path.getNameCount() == 0) {
            return "";
        }
        return AbstractJarBuilder.toUri(new StringBuilder(), path, 0).toString();
    }

    private static StringBuilder toUri(StringBuilder b, Path path, int seg) {
        b.append(path.getName(seg));
        if (seg < path.getNameCount() - 1) {
            b.append('/');
            AbstractJarBuilder.toUri(b, path, seg + 1);
        }
        return b;
    }
}

