/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.IsolatedDevModeMain;
import io.quarkus.dev.appstate.ApplicationStateNotification;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jboss.logging.Logger;

public class DevModeMain
implements Closeable {
    public static final String DEV_MODE_CONTEXT = "META-INF/dev-mode-context.dat";
    private static final Logger log = Logger.getLogger(DevModeMain.class);
    private final DevModeContext context;
    private final ApplicationModel appModel;
    private volatile CuratedApplication curatedApplication;
    private Closeable realCloseable;

    public DevModeMain(DevModeContext context) {
        this(context, null);
    }

    public DevModeMain(DevModeContext context, ApplicationModel appModel) {
        this.context = context;
        this.appModel = appModel;
    }

    public static void main(String ... args) throws Exception {
        try (InputStream devModeCp = DevModeMain.class.getClassLoader().getResourceAsStream(DEV_MODE_CONTEXT);){
            DevModeContext context;
            try {
                context = (DevModeContext)new ObjectInputStream(new DataInputStream(devModeCp)).readObject();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to deserialize the dev mode context. Does the Quarkus plugin version match the version of Quarkus that is in use?", e);
            }
            context.setArgs(args);
            DevModeMain devModeMain = new DevModeMain(context);
            devModeMain.start();
        }
    }

    public void start() throws Exception {
        this.propagateSystemProperties();
        try {
            QuarkusBootstrap.Builder bootstrapBuilder = QuarkusBootstrap.builder().setApplicationRoot((PathCollection)this.getApplicationBuildDirs()).setExistingModel(this.appModel).setIsolateDeployment(true).setLocalProjectDiscovery(Boolean.valueOf(this.context.isLocalProjectDiscovery())).addAdditionalDeploymentArchive(this.getThisClassOrigin()).setBaseName(this.context.getBaseName()).setMode(this.context.getMode());
            if (this.context.getDevModeRunnerJarFile() != null) {
                bootstrapBuilder.setTargetDirectory(this.context.getDevModeRunnerJarFile().getParentFile().toPath());
            } else if (this.context.getApplicationRoot().getTargetDir() != null) {
                bootstrapBuilder.setTargetDirectory(Path.of(this.context.getApplicationRoot().getTargetDir(), new String[0]));
            }
            bootstrapBuilder.setProjectRoot(this.resolveProjectRoot());
            for (ArtifactKey i : this.context.getLocalArtifacts()) {
                bootstrapBuilder.addLocalArtifact(i);
            }
            this.linkDotEnvFile();
            Properties buildSystemProperties = new Properties();
            buildSystemProperties.putAll(this.context.getBuildSystemProperties());
            bootstrapBuilder.setBuildSystemProperties(buildSystemProperties);
            HashMap<String, DevModeContext> map = new HashMap<String, DevModeContext>();
            map.put(DevModeContext.class.getName(), this.context);
            map.put(DevModeType.class.getName(), (DevModeContext)DevModeType.LOCAL);
            this.curatedApplication = bootstrapBuilder.setTest(this.context.isTest()).build().bootstrap();
            this.realCloseable = (Closeable)this.curatedApplication.runInAugmentClassLoader(this.context.getAlternateEntryPoint() == null ? IsolatedDevModeMain.class.getName() : this.context.getAlternateEntryPoint(), map);
        }
        catch (Throwable t) {
            log.error((Object)"Quarkus dev mode failed to start", t);
            throw t instanceof RuntimeException ? (RuntimeException)t : new RuntimeException(t);
        }
    }

    private PathList getApplicationBuildDirs() {
        String classesDir = this.context.getApplicationRoot().getMain().getClassesPath();
        String resourcesOutputDir = this.context.getApplicationRoot().getMain().getResourcesOutputPath();
        if (resourcesOutputDir == null || resourcesOutputDir.equals(classesDir)) {
            return DevModeMain.toListOfExistingOrEmpty(Path.of(classesDir, new String[0]));
        }
        return DevModeMain.toListOfExistingOrEmpty(Path.of(classesDir, new String[0]), Path.of(resourcesOutputDir, new String[0]));
    }

    private static PathList toListOfExistingOrEmpty(Path p1, Path p2) {
        return !Files.exists(p1, new LinkOption[0]) ? DevModeMain.toListOfExistingOrEmpty(p2) : (!Files.exists(p2, new LinkOption[0]) ? DevModeMain.toListOfExistingOrEmpty(p1) : PathList.of((Path[])new Path[]{p1, p2}));
    }

    private static PathList toListOfExistingOrEmpty(Path path) {
        return Files.exists(path, new LinkOption[0]) ? PathList.of((Path[])new Path[]{path}) : PathList.empty();
    }

    private Path getThisClassOrigin() throws URISyntaxException {
        URL thisArchive = this.getClass().getResource(DevModeMain.class.getSimpleName() + ".class");
        int endIndex = thisArchive.getPath().indexOf("!");
        if (endIndex != -1) {
            return Path.of(new URI(thisArchive.getPath().substring(0, endIndex)));
        }
        Path path = Path.of(thisArchive.toURI());
        path = path.getParent();
        for (char i : DevModeMain.class.getName().toCharArray()) {
            if (i != '.') continue;
            path = path.getParent();
        }
        return path;
    }

    private void propagateSystemProperties() {
        for (Map.Entry<String, String> i : this.context.getSystemProperties().entrySet()) {
            System.getProperties().putIfAbsent(i.getKey(), i.getValue());
        }
    }

    private Path resolveProjectRoot() {
        Path projectRoot = this.context.getProjectDir() != null ? this.context.getProjectDir().toPath() : (this.context.getApplicationRoot().getProjectDirectory() != null ? Path.of(this.context.getApplicationRoot().getProjectDirectory(), new String[0]) : new File(".").toPath());
        return projectRoot;
    }

    private void linkDotEnvFile() {
        File projectDir = this.context.getProjectDir();
        if (projectDir == null) {
            return;
        }
        Path currentDir = Paths.get("", new String[0]).toAbsolutePath().normalize();
        if (projectDir.toPath().equals(currentDir)) {
            return;
        }
        Path dotEnvPath = projectDir.toPath().resolve(".env");
        if (Files.exists(dotEnvPath, new LinkOption[0])) {
            Path link = currentDir.resolve(".env");
            this.silentDeleteFile(link);
            try {
                Files.createSymbolicLink(link, dotEnvPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                log.warn((Object)"Unable to link .env file", (Throwable)e);
            }
            link.toFile().deleteOnExit();
        }
    }

    private void silentDeleteFile(Path path) {
        try {
            Files.delete(path);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        if (this.realCloseable != null) {
            this.realCloseable.close();
        }
        if (ApplicationStateNotification.getState() == ApplicationStateNotification.State.STARTED) {
            ApplicationStateNotification.waitForApplicationStop();
        }
        this.curatedApplication.close();
        this.curatedApplication = null;
    }
}

