/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.app.DependencyInfoProvider;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.builder.BuildChain;
import io.quarkus.builder.BuildChainBuilder;
import io.quarkus.builder.BuildExecutionBuilder;
import io.quarkus.builder.BuildResult;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.ExtensionLoader;
import io.quarkus.deployment.builditem.AdditionalApplicationArchiveBuildItem;
import io.quarkus.deployment.builditem.AppModelProviderBuildItem;
import io.quarkus.deployment.builditem.ArchiveRootBuildItem;
import io.quarkus.deployment.builditem.CuratedApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.QuarkusBuildCloseablesBuildItem;
import io.quarkus.deployment.builditem.RawCommandLineArgumentsBuildItem;
import io.quarkus.deployment.builditem.RuntimeApplicationShutdownBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.paths.PathCollection;
import io.quarkus.runtime.LaunchMode;
import io.smallrye.config.SmallRyeConfigProviderResolver;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.logging.Logger;

public class QuarkusAugmentor {
    private static final Logger log = Logger.getLogger(QuarkusAugmentor.class);
    private final ClassLoader classLoader;
    private final ClassLoader deploymentClassLoader;
    private final PathCollection root;
    private final Set<Class<? extends BuildItem>> finalResults;
    private final List<Consumer<BuildChainBuilder>> buildChainCustomizers;
    private final LaunchMode launchMode;
    private final DevModeType devModeType;
    private final List<PathCollection> additionalApplicationArchives;
    private final Collection<Path> excludedFromIndexing;
    private final LiveReloadBuildItem liveReloadBuildItem;
    private final Properties buildSystemProperties;
    private final Properties runtimeProperties;
    private final Path targetDir;
    private final ApplicationModel effectiveModel;
    private final Supplier<DependencyInfoProvider> depInfoProvider;
    private final String baseName;
    private final String originalBaseName;
    private final boolean rebuild;
    private final boolean auxiliaryApplication;
    private final Optional<DevModeType> auxiliaryDevModeType;
    private final boolean test;

    QuarkusAugmentor(Builder builder) {
        this.classLoader = builder.classLoader;
        this.root = builder.root;
        this.finalResults = new HashSet<Class<? extends BuildItem>>(builder.finalResults);
        this.buildChainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>(builder.buildChainCustomizers);
        this.launchMode = builder.launchMode;
        this.additionalApplicationArchives = new ArrayList<PathCollection>(builder.additionalApplicationArchives);
        this.excludedFromIndexing = builder.excludedFromIndexing;
        this.liveReloadBuildItem = builder.liveReloadState;
        this.buildSystemProperties = builder.buildSystemProperties;
        this.runtimeProperties = builder.runtimeProperties;
        this.targetDir = builder.targetDir;
        this.effectiveModel = builder.effectiveModel;
        this.baseName = builder.baseName;
        this.originalBaseName = builder.originalBaseName;
        this.deploymentClassLoader = builder.deploymentClassLoader;
        this.rebuild = builder.rebuild;
        this.devModeType = builder.devModeType;
        this.auxiliaryApplication = builder.auxiliaryApplication;
        this.auxiliaryDevModeType = Optional.ofNullable(builder.auxiliaryDevModeType);
        this.test = builder.test;
        this.depInfoProvider = builder.depInfoProvider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuildResult run() throws Exception {
        if (Runtime.version().major() < 17) {
            throw new IllegalStateException("Quarkus applications require Java 17 or higher to build");
        }
        long start = System.nanoTime();
        log.debug((Object)"Beginning Quarkus augmentation");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        QuarkusBuildCloseablesBuildItem buildCloseables = new QuarkusBuildCloseablesBuildItem();
        try {
            Thread.currentThread().setContextClassLoader(this.deploymentClassLoader);
            BuildChainBuilder chainBuilder = BuildChain.builder();
            chainBuilder.setClassLoader(this.deploymentClassLoader);
            ExtensionLoader.loadStepsFrom(this.deploymentClassLoader, this.buildSystemProperties == null ? new Properties() : this.buildSystemProperties, this.runtimeProperties == null ? new Properties() : this.runtimeProperties, this.effectiveModel, this.launchMode, this.devModeType).accept(chainBuilder);
            Thread.currentThread().setContextClassLoader(this.classLoader);
            chainBuilder.loadProviders(this.classLoader);
            chainBuilder.addInitial(QuarkusBuildCloseablesBuildItem.class).addInitial(ArchiveRootBuildItem.class).addInitial(ShutdownContextBuildItem.class).addInitial(RawCommandLineArgumentsBuildItem.class).addInitial(LaunchModeBuildItem.class).addInitial(LiveReloadBuildItem.class).addInitial(AdditionalApplicationArchiveBuildItem.class).addInitial(CuratedApplicationShutdownBuildItem.class).addInitial(BuildSystemTargetBuildItem.class).addInitial(AppModelProviderBuildItem.class);
            for (Class<? extends BuildItem> clazz : this.finalResults) {
                chainBuilder.addFinal(clazz);
            }
            for (Consumer consumer : this.buildChainCustomizers) {
                consumer.accept(chainBuilder);
            }
            if (this.launchMode.isDevOrTest()) {
                chainBuilder.addFinal(RuntimeApplicationShutdownBuildItem.class);
            }
            ArchiveRootBuildItem.Builder rootBuilder = ArchiveRootBuildItem.builder();
            if (this.root != null) {
                rootBuilder.addArchiveRoots(this.root);
            }
            rootBuilder.setExcludedFromIndexing(this.excludedFromIndexing);
            BuildChain buildChain = chainBuilder.build();
            BuildExecutionBuilder execBuilder = buildChain.createExecutionBuilder(this.baseName).produce((BuildItem)buildCloseables).produce((BuildItem)this.liveReloadBuildItem).produce((BuildItem)rootBuilder.build(buildCloseables)).produce((BuildItem)new ShutdownContextBuildItem()).produce((BuildItem)new RawCommandLineArgumentsBuildItem()).produce((BuildItem)new CuratedApplicationShutdownBuildItem((QuarkusClassLoader)this.deploymentClassLoader.getParent(), !this.liveReloadBuildItem.isLiveReload())).produce((BuildItem)new LaunchModeBuildItem(this.launchMode, this.devModeType == null ? Optional.empty() : Optional.of(this.devModeType), this.auxiliaryApplication, this.auxiliaryDevModeType, this.test)).produce((BuildItem)new BuildSystemTargetBuildItem(this.targetDir, this.baseName, this.originalBaseName, this.rebuild, this.buildSystemProperties == null ? new Properties() : this.buildSystemProperties)).produce((BuildItem)new AppModelProviderBuildItem(this.effectiveModel, this.depInfoProvider));
            for (PathCollection i : this.additionalApplicationArchives) {
                execBuilder.produce((BuildItem)new AdditionalApplicationArchiveBuildItem(i));
            }
            BuildResult buildResult = execBuilder.execute();
            String message = "Quarkus augmentation completed in " + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - start) + "ms";
            if (this.launchMode == LaunchMode.NORMAL) {
                log.info((Object)message);
                if (Boolean.parseBoolean(System.getProperty("quarkus.debug.dump-build-metrics"))) {
                    buildResult.getMetrics().dumpTo(this.targetDir.resolve("build-metrics.json"));
                }
            } else {
                log.debug((Object)message);
                if (this.launchMode == LaunchMode.DEVELOPMENT && !LaunchMode.isRemoteDev()) {
                    buildResult.getMetrics().dumpTo(this.targetDir.resolve("build-metrics.json"));
                }
            }
            BuildResult buildResult2 = buildResult;
            return buildResult2;
        }
        finally {
            try {
                ((SmallRyeConfigProviderResolver)SmallRyeConfigProviderResolver.instance()).releaseConfig(this.deploymentClassLoader);
            }
            catch (Exception exception) {}
            Thread.currentThread().setContextClassLoader(originalClassLoader);
            buildCloseables.close();
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private static final String QUARKUS_APPLICATION = "quarkus-application";
        public DevModeType auxiliaryDevModeType;
        boolean rebuild;
        List<PathCollection> additionalApplicationArchives = new ArrayList<PathCollection>();
        Collection<Path> excludedFromIndexing = Collections.emptySet();
        ClassLoader classLoader;
        PathCollection root;
        Path targetDir;
        Set<Class<? extends BuildItem>> finalResults = new HashSet<Class<? extends BuildItem>>();
        private final List<Consumer<BuildChainBuilder>> buildChainCustomizers = new ArrayList<Consumer<BuildChainBuilder>>();
        LaunchMode launchMode = LaunchMode.NORMAL;
        LiveReloadBuildItem liveReloadState = new LiveReloadBuildItem();
        Properties buildSystemProperties;
        Properties runtimeProperties;
        ApplicationModel effectiveModel;
        String baseName = "quarkus-application";
        String originalBaseName = "quarkus-application";
        ClassLoader deploymentClassLoader;
        DevModeType devModeType;
        boolean test;
        boolean auxiliaryApplication;
        private Supplier<DependencyInfoProvider> depInfoProvider;

        public Builder addBuildChainCustomizer(Consumer<BuildChainBuilder> customizer) {
            this.buildChainCustomizers.add(customizer);
            return this;
        }

        public List<PathCollection> getAdditionalApplicationArchives() {
            return this.additionalApplicationArchives;
        }

        public Builder addAdditionalApplicationArchive(PathCollection archive) {
            this.additionalApplicationArchives.add(archive);
            return this;
        }

        public Builder excludeFromIndexing(Collection<Path> excludedFromIndexing) {
            this.excludedFromIndexing = excludedFromIndexing;
            return this;
        }

        public Builder setAuxiliaryApplication(boolean auxiliaryApplication) {
            this.auxiliaryApplication = auxiliaryApplication;
            return this;
        }

        public Builder setAuxiliaryDevModeType(DevModeType auxiliaryDevModeType) {
            this.auxiliaryDevModeType = auxiliaryDevModeType;
            return this;
        }

        public LaunchMode getLaunchMode() {
            return this.launchMode;
        }

        public Builder setLaunchMode(LaunchMode launchMode) {
            this.launchMode = launchMode;
            return this;
        }

        public DevModeType getDevModeType() {
            return this.devModeType;
        }

        public Builder setDevModeType(DevModeType devModeType) {
            this.devModeType = devModeType;
            return this;
        }

        public boolean isTest() {
            return this.test;
        }

        public Builder setTest(boolean test) {
            this.test = test;
            return this;
        }

        public ClassLoader getClassLoader() {
            return this.classLoader;
        }

        public Builder setClassLoader(ClassLoader classLoader) {
            this.classLoader = classLoader;
            return this;
        }

        public PathCollection getRoot() {
            return this.root;
        }

        public <T extends BuildItem> Builder addFinal(Class<T> clazz) {
            this.finalResults.add(clazz);
            return this;
        }

        public Builder setRoot(PathCollection root) {
            this.root = root;
            return this;
        }

        public String getBaseName() {
            return this.baseName;
        }

        public Builder setBaseName(String baseName) {
            this.baseName = baseName;
            return this;
        }

        public Builder setOriginalBaseName(String originalBaseName) {
            this.originalBaseName = originalBaseName;
            return this;
        }

        public Properties getBuildSystemProperties() {
            return this.buildSystemProperties;
        }

        public Builder setBuildSystemProperties(Properties buildSystemProperties) {
            this.buildSystemProperties = buildSystemProperties;
            return this;
        }

        public Properties getRuntimeProperties() {
            return this.runtimeProperties;
        }

        public Builder setRuntimeProperties(Properties runtimeProperties) {
            this.runtimeProperties = runtimeProperties;
            return this;
        }

        public Builder setRebuild(boolean rebuild) {
            this.rebuild = rebuild;
            return this;
        }

        public QuarkusAugmentor build() {
            return new QuarkusAugmentor(this);
        }

        public LiveReloadBuildItem getLiveReloadState() {
            return this.liveReloadState;
        }

        public Builder setLiveReloadState(LiveReloadBuildItem liveReloadState) {
            this.liveReloadState = liveReloadState;
            return this;
        }

        public Builder setTargetDir(Path outputDir) {
            this.targetDir = outputDir;
            return this;
        }

        public Builder setEffectiveModel(ApplicationModel effectiveModel) {
            this.effectiveModel = effectiveModel;
            return this;
        }

        public ClassLoader getDeploymentClassLoader() {
            return this.deploymentClassLoader;
        }

        public Builder setDeploymentClassLoader(ClassLoader deploymentClassLoader) {
            this.deploymentClassLoader = deploymentClassLoader;
            return this;
        }

        public Builder setDependencyInfoProvider(Supplier<DependencyInfoProvider> depInfoProvider) {
            this.depInfoProvider = depInfoProvider;
            return this;
        }
    }
}

