/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.steps.NativeImageBuildRunner;
import io.quarkus.deployment.util.ContainerRuntimeUtil;
import io.quarkus.deployment.util.ProcessUtil;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.lang3.RandomStringUtils;
import org.jboss.logging.Logger;

public abstract class NativeImageBuildContainerRunner
extends NativeImageBuildRunner {
    private static final Logger log = Logger.getLogger(NativeImageBuildContainerRunner.class);
    final NativeConfig nativeConfig;
    protected final ContainerRuntimeUtil.ContainerRuntime containerRuntime;
    String[] baseContainerRuntimeArgs;
    private final String containerName;

    protected NativeImageBuildContainerRunner(NativeConfig nativeConfig) {
        this.nativeConfig = nativeConfig;
        this.containerRuntime = ContainerRuntimeUtil.detectContainerRuntime();
        this.baseContainerRuntimeArgs = new String[]{"--env", "LANG=C", "--rm"};
        this.containerName = "build-native-" + RandomStringUtils.insecure().next(5, true, false);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public void setup(boolean processInheritIODisabled) {
        if (this.containerRuntime != ContainerRuntimeUtil.ContainerRuntime.UNAVAILABLE) {
            String effectiveBuilderImage;
            block14: {
                log.infof("Using %s to run the native image builder", (Object)this.containerRuntime.getExecutableName());
                effectiveBuilderImage = this.nativeConfig.builderImage().getEffectiveImage();
                NativeConfig.ImagePullStrategy builderImagePull = this.nativeConfig.builderImage().pull();
                if (builderImagePull != NativeConfig.ImagePullStrategy.ALWAYS) {
                    log.infof("Checking status of builder image '%s'", (Object)effectiveBuilderImage);
                    Process imageInspectProcess = null;
                    try {
                        ProcessBuilder pb = new ProcessBuilder(Arrays.asList(this.containerRuntime.getExecutableName(), "image", "inspect", "-f", "{{ .Id }}", effectiveBuilderImage)).redirectOutput(ProcessBuilder.Redirect.DISCARD).redirectError(ProcessBuilder.Redirect.DISCARD);
                        imageInspectProcess = pb.start();
                        if (imageInspectProcess.waitFor() != 0) {
                            if (builderImagePull == NativeConfig.ImagePullStrategy.NEVER) {
                                throw new RuntimeException("Could not find builder image '" + effectiveBuilderImage + "' locally and 'quarkus.native.builder-image.pull' is set to 'never'.");
                            }
                            log.infof("Could not find builder image '%s' locally, pulling the builder image", (Object)effectiveBuilderImage);
                            break block14;
                        }
                        log.infof("Found builder image '%s' locally, skipping image pulling", (Object)effectiveBuilderImage);
                        return;
                    }
                    catch (IOException | InterruptedException e) {
                        throw new RuntimeException("Failed to check status of builder image '" + effectiveBuilderImage + "'", e);
                    }
                    finally {
                        if (imageInspectProcess != null) {
                            imageInspectProcess.destroy();
                        }
                    }
                }
            }
            try {
                log.infof("Pulling builder image '%s'", (Object)effectiveBuilderImage);
                this.pull(effectiveBuilderImage, processInheritIODisabled);
            }
            catch (Exception e) {
                log.infof("Retrying in 5 seconds", new Object[0]);
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException e1) {
                    throw new RuntimeException(e1);
                }
                log.infof("Pulling builder image '%s' (take 2)", (Object)effectiveBuilderImage);
                this.pull(effectiveBuilderImage, processInheritIODisabled);
            }
        }
    }

    private void pull(String effectiveBuilderImage, boolean processInheritIODisabled) {
        Process pullProcess = null;
        try {
            ProcessBuilder pb = new ProcessBuilder(Arrays.asList(this.containerRuntime.getExecutableName(), "pull", effectiveBuilderImage));
            pullProcess = ProcessUtil.launchProcess(pb, processInheritIODisabled);
            if (pullProcess.waitFor() != 0) {
                throw new RuntimeException("Failed to pull builder image '" + effectiveBuilderImage + "'");
            }
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException("Failed to pull builder image '" + effectiveBuilderImage + "'");
        }
        finally {
            if (pullProcess != null) {
                pullProcess.destroy();
            }
        }
    }

    @Override
    protected String[] getGraalVMVersionCommand(List<String> args) {
        List<String> containerRuntimeArgs;
        if (this.nativeConfig.containerRuntimeOptions().isPresent()) {
            List<String> runtimeOptions = this.nativeConfig.containerRuntimeOptions().get();
            containerRuntimeArgs = new ArrayList<String>(runtimeOptions.size() + 1);
            containerRuntimeArgs.addAll(runtimeOptions);
            containerRuntimeArgs.add("--rm");
        } else {
            containerRuntimeArgs = Collections.singletonList("--rm");
        }
        return this.buildCommand("run", containerRuntimeArgs, args);
    }

    @Override
    protected String[] getBuildCommand(Path outputDir, List<String> args) {
        List<String> containerRuntimeBuildArgs = this.getContainerRuntimeBuildArgs(outputDir);
        ArrayList<String> effectiveContainerRuntimeBuildArgs = new ArrayList<String>(containerRuntimeBuildArgs.size() + 2);
        effectiveContainerRuntimeBuildArgs.addAll(containerRuntimeBuildArgs);
        effectiveContainerRuntimeBuildArgs.add("--name");
        effectiveContainerRuntimeBuildArgs.add(this.containerName);
        return this.buildCommand("run", effectiveContainerRuntimeBuildArgs, args);
    }

    @Override
    protected void objcopy(Path outputDir, String ... args) {
        List<String> containerRuntimeBuildArgs = this.getContainerRuntimeBuildArgs(outputDir);
        Collections.addAll(containerRuntimeBuildArgs, "--entrypoint", "/bin/bash");
        ArrayList<String> objcopyCommand = new ArrayList<String>(2);
        objcopyCommand.add("-c");
        objcopyCommand.add("objcopy " + String.join((CharSequence)" ", args));
        String[] command = this.buildCommand("run", containerRuntimeBuildArgs, objcopyCommand);
        NativeImageBuildContainerRunner.runCommand(command, null, null);
    }

    @Override
    public void addShutdownHook(Process process) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            if (process.isAlive()) {
                try {
                    Process removeProcess = new ProcessBuilder(List.of(this.containerRuntime.getExecutableName(), "rm", "-f", this.containerName)).redirectOutput(ProcessBuilder.Redirect.DISCARD).redirectError(ProcessBuilder.Redirect.DISCARD).start();
                    removeProcess.waitFor(2L, TimeUnit.SECONDS);
                }
                catch (IOException | InterruptedException e) {
                    log.debug((Object)"Unable to stop running container", (Throwable)e);
                }
            }
        }));
    }

    protected List<String> getContainerRuntimeBuildArgs(Path outputDir) {
        ArrayList<String> containerRuntimeArgs = new ArrayList<String>();
        this.nativeConfig.containerRuntimeOptions().ifPresent(containerRuntimeArgs::addAll);
        if (this.nativeConfig.debugBuildProcess() && this.nativeConfig.publishDebugBuildProcessPort()) {
            containerRuntimeArgs.add("--publish=5005:5005");
        }
        return containerRuntimeArgs;
    }

    protected String[] buildCommand(String dockerCmd, List<String> containerRuntimeArgs, List<String> command) {
        return (String[])Stream.of(Stream.of(this.containerRuntime.getExecutableName()), Stream.of(dockerCmd), Stream.of(this.baseContainerRuntimeArgs), containerRuntimeArgs.stream(), Stream.of(this.nativeConfig.builderImage().getEffectiveImage()), command.stream()).flatMap(Function.identity()).toArray(String[]::new);
    }
}

