/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.steps.ErrorReplacingProcessReader;
import io.quarkus.deployment.pkg.steps.GraalVM;
import io.quarkus.deployment.util.ProcessUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import org.apache.commons.lang3.SystemUtils;
import org.jboss.logging.Logger;

public abstract class NativeImageBuildRunner {
    private static final Logger log = Logger.getLogger(NativeImageBuildRunner.class);
    private static GraalVM.Version graalVMVersion = null;

    public GraalVM.Version getGraalVMVersion() {
        if (graalVMVersion == null) {
            try {
                CharSequence[] versionCommand = this.getGraalVMVersionCommand(Collections.singletonList("--version"));
                log.debugf(String.join((CharSequence)" ", versionCommand).replace("$", "\\$"), new Object[0]);
                Process versionProcess = new ProcessBuilder((String[])versionCommand).redirectErrorStream(true).start();
                versionProcess.waitFor();
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(versionProcess.getInputStream(), StandardCharsets.UTF_8));){
                    graalVMVersion = GraalVM.Version.of(reader.lines());
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to get GraalVM version", e);
            }
        }
        return graalVMVersion;
    }

    public abstract boolean isContainer();

    public void setup(boolean processInheritIODisabled) {
    }

    public void addShutdownHook(Process buildNativeProcess) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result build(List<String> args, String nativeImageName, String resultingExecutableName, Path outputDir, GraalVM.Version graalVMVersion, boolean debugSymbolsEnabled, boolean processInheritIODisabled) throws InterruptedException, IOException {
        this.preBuild(outputDir, args);
        try {
            CountDownLatch errorReportLatch = new CountDownLatch(1);
            CharSequence[] buildCommand = this.getBuildCommand(outputDir, args);
            ProcessBuilder processBuilder = new ProcessBuilder((String[])buildCommand).directory(outputDir.toFile());
            log.info((Object)String.join((CharSequence)" ", buildCommand).replace("$", "\\$"));
            Process process = ProcessUtil.launchProcessStreamStdOut(processBuilder, processInheritIODisabled);
            this.addShutdownHook(process);
            ExecutorService executor = Executors.newSingleThreadExecutor();
            executor.submit(new ErrorReplacingProcessReader(process.getErrorStream(), outputDir.resolve("reports").toFile(), errorReportLatch));
            executor.shutdown();
            errorReportLatch.await();
            int exitCode = process.waitFor();
            boolean objcopyExists = this.objcopyExists();
            if (exitCode != 0) {
                Result result = new Result(exitCode);
                return result;
            }
            if (!debugSymbolsEnabled) {
                if (objcopyExists) {
                    this.objcopy(outputDir, "--strip-debug", resultingExecutableName);
                } else if (SystemUtils.IS_OS_LINUX) {
                    log.warn((Object)"objcopy executable not found in PATH. Debug symbols will therefore not be separated from the executable.");
                    log.warn((Object)"That also means that resulting native executable is larger as it embeds the debug symbols.");
                }
            }
            Result result = new Result(0);
            return result;
        }
        finally {
            this.postBuild(outputDir, nativeImageName, resultingExecutableName);
        }
    }

    protected abstract String[] getGraalVMVersionCommand(List<String> var1);

    protected abstract String[] getBuildCommand(Path var1, List<String> var2);

    protected boolean objcopyExists() {
        return true;
    }

    protected abstract void objcopy(Path var1, String ... var2);

    protected void preBuild(Path outputDir, List<String> buildArgs) throws IOException, InterruptedException {
    }

    protected void postBuild(Path outputDir, String nativeImageName, String resultingExecutableName) throws InterruptedException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void runCommand(String[] command, String errorMsg, File workingDirectory) {
        block16: {
            log.info((Object)String.join((CharSequence)" ", command).replace("$", "\\$"));
            Process process = null;
            try {
                String out;
                int exitCode;
                ProcessBuilder processBuilder = new ProcessBuilder(command).redirectErrorStream(true);
                if (workingDirectory != null) {
                    processBuilder.directory(workingDirectory);
                }
                if ((exitCode = (process = processBuilder.start()).waitFor()) == 0) break block16;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    out = reader.lines().collect(Collectors.joining("\n"));
                }
                if (errorMsg != null) {
                    log.error((Object)(errorMsg + " Output: " + out));
                } else {
                    log.debugf("Command: " + String.join((CharSequence)" ", command) + " failed with exit code " + exitCode + " Output: " + out, new Object[0]);
                }
            }
            catch (IOException | InterruptedException e) {
                if (errorMsg != null) {
                    log.errorf((Throwable)e, errorMsg, new Object[0]);
                } else {
                    log.debugf((Throwable)e, "Command: " + String.join((CharSequence)" ", command) + " failed.", new Object[0]);
                }
            }
            finally {
                if (process != null) {
                    process.destroy();
                }
            }
        }
    }

    static void runCommand(String[] command, String errorMsg) {
        NativeImageBuildRunner.runCommand(command, errorMsg, null);
    }

    static class Result {
        private final int exitCode;

        public Result(int exitCode) {
            this.exitCode = exitCode;
        }

        public int getExitCode() {
            return this.exitCode;
        }
    }
}

